       subroutine streamfctn
c
c=======================================================================
c                                                                    ===
c   Solver : CG with ILU pre-conditioner                             ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <fullwd.h>
#include <scalar.h>
#include <onedim.h>
#include <fields.h>
#include <workspb.h>
#include <bndata.h>
#include <filtdat.h>
#include <iounits.h>
#include <moddat.h>
#include <vertslabs.h>
#include <convinfo.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,j,luptd,luptdb
#ifdef coast
     *        ,l
#endif
#ifdef shapiro
     *        ,nn
#endif
      FLOAT
     *      fx,fxa,fxb,dxx,dyy
      FLOAT
     *      ptdb(imt,jmt)
      FLOAT
     *     a(imt,jmt,0:8),hvex(imt,jmt),
     *     vmetx(imt,jmt),tmetxi(imt,jmt),corfac(imt,jmt)
      integer ir(imt*jmt),ia(imt*jmt+1),ja(9*imt*jmt)
      FLOAT
     *     amt(9*imt*jmt),rp(imt*jmt),pspar(imt*jmt)
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
c=======================================================================
c  Begin introductory section to prepare for the relaxation  ===========
c=======================================================================
c
c-----------------------------------------------------------------------
c  Initiate reading of relaxation solution of 2 timesteps back
c  for the purpose of computing an initial guess for the present pass
c  (input unit alternates on timesteps between 5 & 6)
c-----------------------------------------------------------------------
c
      luptdb=6-mod(itt,2)
      luptd =5+mod(itt,2)
      call ofind(kflds,nwds,(luptdb-1)*nwds+1)
c
c-----------------------------------------------------------------------
c  Complete reading of relaxation solution of 2 timesteps back and
c  initiate reading of relaxation solution of previous timestep
c  (input unit alternates on timesteps between 6 & 5)
c-----------------------------------------------------------------------
c
      call oget(kflds,nwds,(luptdb-1)*nwds+1,ptdb)
      call ofind(kflds,nwds,(luptd-1)*nwds+1)
c
c-----------------------------------------------------------------------
c  Filter/smooth vorticity field.
c-----------------------------------------------------------------------
#ifdef shapiro
c
c  If requested, apply Shapiro filter:
c
c       ICNTZ = counter (for frequency of application)
c       NFRQZ = frequency with which filter is applied
c       NTIMZ = number of times filter is applied per time step
c       NORDZ = order of the filter
c
      if(mixztd.eq.1) then
        icntz=icntz+1
        if(icntz.eq.nfrqz)then
          icntz=0
          if(nordz.gt.0)then
            do 30 nn=1,ntimz
# ifndef cyclic
              call shap_lev(ztd,imtm1,jmtm1,zgrid,nordz)
# else
              call shap_lev(ztd,imt,jmtm1,zgrid,nordz)
# endif

  30        continue
          endif
        endif
      endif
#endif
c
c  Or, apply Laplacian filter.
c
      if(mixztd.eq.2) then
        call lap_filt(ztd,tgrid)
      endif
c
c  Save rate change of barotropic vorticity in array ZTDB for output
c  purposes.
c
      do 40 j=1,jmt
      do 40 i=1,imt
        ztdb(i,j)=ztd(i,j)
  40  continue
c
c-----------------------------------------------------------------------
c  Compute a first guess for the iteration by extrapolating the two
c  previous solutions forward in time.
c-----------------------------------------------------------------------
c
c  1st, complete reading of streamfunction solution of previous timestep.
c
      call oget(kflds,nwds,(luptd-1)*nwds+1,ptd)
c
c  2nd, perform time extrapolation (accounting for mixing timestep).
c
      fxa=c1
      fxb=c2
      if(mixts.or.mxpas2) fxa=p5
      do 110 j=1,jmt
      do 110 i=1,imt
        ptd(i,j)=fxa*(fxb*ptd(i,j)-ptdb(i,j))
 110  continue
c
c  Update the time change of stream function at the southern and
c  northern boundaries.
c
      do 120 i=2,imtm1
        ptd(i,1)=po(i,1,south)-pb(i,1)
        ptd(i,jmt)=po(i,1,north)-pb(i,jmt)
 120  continue
#ifdef cyclic
c
c  Set Cyclic boundary conditions.
c
      do 130 j=1,jmt
        ptd(1  ,j)=ptd(imtm1,j)
        ptd(imt,j)=ptd(2    ,j)
 130  continue
#else
c
c  Update the time change of stream function at the western and
c  eastern boundaries.
c
      do 140 j=1,jmt
        ptd(1,j)=po(j,1,west)-pb(1,j)
        ptd(imt,j)=po(j,1,east)-pb(imt,j)
 140  continue
#endif
#ifdef coast
c
c  Pass to coastal segments with end points at domain boundaries.
c
      do 150 l=1,ncseg
        fx=ptd(icoast(1,l),jcoast(1,l))
      do 150 i=2,lencoast(l)
        ptd(icoast(i,l),jcoast(i,l))=fx
 150  continue
#endif
c
c=======================================================================
c  End introductory section  ===========================================
c=======================================================================
c
c-----------------------------------------------------------------------
c  Set up the metrics and Coriolis terms for construction matrix elements.
c-----------------------------------------------------------------------
c
      do 134 i=1,imt
        do 136 j=1,jmt
           fx=-c2*c2dtsf*acor*omega*sine(i,j)
           vmetx(i,j)=cs(j)
           tmetxi(i,j)=cstr(j)
           corfac(i,j)=hv(i,j)*fx
136     continue
134   continue
c
#ifdef testsolver
c-----------------------------------------------------------------------
c  Write domain & BC data required by Pre-Conditioner tuner.
c-----------------------------------------------------------------------
c
      if (itt.eq.1) then
         write (tst2out) imt,jmt,km,lseg,gridx,gridy,coord,deg2rad*re
         do j = 1, jmt
            do i = 1, imt
# ifdef coast
               write (tst3out) landt(i,j)
# endif
               write (tst4out) hv(i,j)
               write (tst5out) vmetx(i,j),tmetxi(i,j),corfac(i,j)
            enddo
         enddo
         do j = 1, jmt
           write (tst6out) ptd(1,j),ptd(imt,j)
         enddo
         do i = 1, imt
           write (tst7out) ptd(i,jmt),ptd(i,1)
         enddo
      end if
c
#endif
c-----------------------------------------------------------------------
c  Adjust dx,dy according to coordinate system for Matrix construction.
c-----------------------------------------------------------------------
c
       if(coord.eq.0)then
          dxx=gridx
          dyy=gridy
       else
          dxx=gridx*deg2rad*re
          dyy=gridy*deg2rad*re
       endif
c
c-------------------------------------------------------
c  Get the weighted depth : Rigid-Lid or Free surface 
c  computation.
c-------------------------------------------------------
c
      do 146 i=1,imt
        do 148 j=1,jmt
          hvex(i,j)=hdv(i,j)
148     continue
146   continue
c
#ifdef coast
      call Stream_solve(imt,jmt,lseg,dxx,dyy,
     *                     isq,ieq,isz,iez,a,ptd,hvex,ztd,
#else
      call Stream_solve(imt,jmt,dxx,dyy,
     *                     a,ptd,hvex,ztd,
#endif
     *                     vmetx,tmetxi,corfac,
     *                     ir,ia,ja,amt,rp,pspar
     *                     )
c
c  Report convergence information.
c
         if(mod(itt,ntsi).eq.0) write(stdout,900)
     *        resini,residu,restarget,mican
c
c-----------------------------------------------------------------------
c  Update the stream function based upon the solution to elliptic bvp 
c-----------------------------------------------------------------------
c
      if(.not.mxpas2) then
        do 620 j=1,jmt
        do 620 i=1,imt
          ptdb(i,j)=pb(i,j)+ptd(i,j)
          pb(i,j)=p(i,j)
          p(i,j)=ptdb(i,j)
 620    continue
      else
        do 630 j=1,jmt
        do 630 i=1,imt
          p(i,j)=pb(i,j)+ptd(i,j)
 630    continue
      endif
c
c-----------------------------------------------------------------------
c  Filter/smooth transport stream function field
c-----------------------------------------------------------------------
#ifdef shapiro
c
c  If requested, apply Shapiro filter:
c
c       ICNTP = counter (for frequency of application)
c       NFRQP = frequency with which filter is applied
c       NTIMP = number of times filter is applied per time step
c       NORDP = order of the filter
c
      icntp=icntp+1
      if(icntp.eq.nfrqp)then
        icntp=0
        if(nordp.gt.0)then
          do 640 nn=1,ntimp
            call shap_lev(p,imt,jmt,tgrid,nordp)
 640      continue
          do 650 j=1,jmt
          do 650 i=1,imt
            ptdb(i,j)=p(i,j)
 650      continue
        endif
      endif
#endif
c
c-----------------------------------------------------------------------
c  Save PTD to compute 1st guess for iterations next timestep
c  (..note.. on 1st pass of Euler backward timestep, bypass this
c            save, since it will be done on the 2nd pass)
c  (..note.. on a mixing timestep, alter ptd to be consistent with
c            normal, leap-frog stepping)
c-----------------------------------------------------------------------
c
      if((mix.eq.1).and.eb) return
      if((mxp.ne.0).or.(mix.ne.0)) then
        do 660 j=1,jmt
        do 660 i=1,imt
          ptd(i,j)=c2*ptd(i,j)
 660    continue
      endif
      call oput(kflds,nwds,(luptdb-1)*nwds+1,ptd)
c
      return
c
 900  format (' PCG res.:',
     *        ' Initial ',1pe10.3,
     *        ' Final ',1pe10.3,
     *        ' Target ',1pe10.3,
     *        ' MICAN ', i4  )
c
      end
