        subroutine UV_hat
c
c=======================================================================
c                                                                    ===
c  This subroutine calculates the augmented velocities used in order ===
c  to split the Barotropic velocity equations from the Elliptic      ===
c  equation for the change in surface pressure (J. K. Dukowicz and   ===
c  R. D. Smith,JGR,99,7991-8014,1994).                               ===
c                                                                    ===
c=======================================================================
c
c----------------------------------------------------------------------
c  Define global data.
c----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <fieldsbar.h>
#include <fields.h>
#include <scalar.h>
#include <fullwd.h>
#include <onedim.h>
#include <sinfo.h>
#ifdef shapiro
# include <filtdat.h>
#endif
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,j
#ifdef coast
     &        ,iend,istr,jptr,l
#endif
#ifdef shapiro
     &        ,nn
#endif
      FLOAT
     &     fcori,frhsu,frhsv,pressgradu,pressgradu1,pressgradu2,
     &     pressgradv,pressgradv1,pressgradv2,ww
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Solve for the augmented velocities.
c-----------------------------------------------------------------------
c
      do 30 j=1,jmtm1
#if defined coast
c
c  Choose to compute at sea points only and avoid land points
c
         jptr = min( max(j, 2), jmtm2)
c
         do 20 l=1,lseg
            istr=isq(jptr,l)
            if (istr.eq.0) go to 30
# ifndef cyclic
            if ((istr.eq.2).and.(fkmq(2,jptr).gt.c0)) istr=1
# endif
            iend=ieq(jptr,l)
            if ((iend.eq.imtm2).and.(fkmq(imtm2,jptr).gt.c0)) iend=imtm1
        do 10 i=istr,iend
#elif !defined cyclic
c
        do 10 i=1,imtm1
#else
c
        do 10 i=2,imtm1
#endif
c
c    Surface pressure gradient contributions:
c
              pressgradu1=(pb(i+1,j+1)+pb(i+1,j))-(pb(i,j+1)+pb(i,j))
              pressgradu1=(c1-gammabar)*pressgradu1*csr(j)*dxu2r(i)
c
              pressgradu2=(p(i+1,j+1)+p(i+1,j))-(p(i,j+1)+p(i,j))
              pressgradu2=gammabar*pressgradu2*csr(j)*dxu2r(i)
c     
              pressgradu=pressgradu1+pressgradu2
c
              pressgradv1=(pb(i+1,j+1)+pb(i,j+1))-(pb(i+1,j)+pb(i,j))
              pressgradv1=(c1-gammabar)*pressgradv1*dyu2r(j)
c
              pressgradv2=(p(i+1,j+1)+p(i,j+1))-(p(i+1,j)+p(i,j))
              pressgradv2=gammabar*pressgradv2*dyu2r(j)
c
              pressgradv=pressgradv1+pressgradv2
c
c    Combine all of the contributions:
c
             frhsu=zum(i,j)-c2dtsf*pressgradu
             frhsv=zvm(i,j)-c2dtsf*pressgradv
c
c    Get Coriolis and inversion parameters:
c
             fcori=c2*omega*sine(i,j)
             ww=alphap*fcori*c2dtsf
c
c    Invert 2x2 matrix to get uhat and vhat velocities:
c
             ubarhat(i,j)=(+frhsu+ww*frhsv)/(c1+ww*ww)
     *                    +ubarob(i,j)
             vbarhat(i,j)=(-ww*frhsu+frhsv)/(c1+ww*ww)
     *                    +vbarob(i,j)
c
  10     continue
#ifdef coast
  20     continue
#endif
  30  continue
c
#ifdef shapiro
c-----------------------------------------------------------------------
c  If applicable, Shapiro filter the 2-d horizontal vertical averaged
c  modified accelerations
c-----------------------------------------------------------------------
c
c       ICNTZ = counter (for frequency of application)
c       NFRQZ = frequency with which filter is applied
c       NTIMZ = number of times filter is applied per time step
c       NORDZ = order of the filter
c
      if ((mixztd.eq.1).and.(nordz.ne.0)) then
         icntz=icntz+1
         if (icntz.eq.nfrqz) then
            icntz=0
            do 40 nn=1,ntimz
               call shap_lev(ubarhat,imu,jmtm1,hgrid,nordz)
               call shap_lev(vbarhat,imu,jmtm1,hgrid,nordz)
  40        continue
c
# ifndef cyclic
c  Why this next section?
c
            ubarhat(1,1)=p5*ubarhat(1,2)+p5*ubarhat(2,1)
            ubarhat(imu,1)=p5*ubarhat(imum1,1)+p5*ubarhat(imu,2)
            ubarhat(1,jmtm1)=p5*ubarhat(1,jmtm2)+p5*ubarhat(2,jmtm1)
            ubarhat(imu,jmtm1)=p5*ubarhat(imu,jmtm2)+
     *                         p5*ubarhat(imum1,jmtm1)
            vbarhat(1,1)=p5*vbarhat(1,2)+p5*vbarhat(2,1)
            vbarhat(imu,1)=p5*vbarhat(imum1,1)+p5*vbarhat(imu,2)
            vbarhat(1,jmtm1)=p5*vbarhat(1,jmtm2)+p5*vbarhat(2,jmtm1)
            vbarhat(imu,jmtm1)=p5*vbarhat(imu,jmtm2)+
     *                         p5*vbarhat(imum1,jmtm1)
c
# endif
         endif
      endif
c
#endif
#ifdef cyclic
c-----------------------------------------------------------------------
c  Set Cyclic boundary conditions.
c-----------------------------------------------------------------------
c
      do 50 j=1,jmt
        ubarhat(1  ,j)=ubarhat(imtm1,j)
        vbarhat(1  ,j)=vbarhat(imtm1,j)
        ubarhat(imt,j)=ubarhat(2    ,j)
        vbarhat(imt,j)=vbarhat(2    ,j)
  50  continue
c
#endif
      return
      end
