$ set verify
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!                                                                          !
$!  VAX VMS Script to compile and link the PE_INITIAL Package.  Use the     !
$!  following command:                                                      !
$!                                                                          !
$!                @ VMSmakefile                                             !
$!                                                                          !
$!                                 Patrick J. Haley Jr.   08/17/2001        !
$!                                 Version                9.10              !
$!                                                                          !
$!  It uses file "compile.com" to C-preprocessing and compiling.            !
$!                                                                          !
$!  C-preprocessing options:                                                !
$!                                                                          !
$!  AIXDATE	AIX intrinsic date routine (IBM RS6000).                    !
$!  CRAYDATE	CRAY's intrinsic date routine.                              !
$!  DECDATE	DEC's VMS intrinsic date routine.                           !
$!  GENDBG      Generic Debugging:  Preserves intermediate files            !
$!  LEQSTATE    Temporary option:   Linear Equation of State                !
$!  RESET_H     Temporary option:  Reset topography for new fluxes (PE 8.3) !
$!  RMCOMMENTS  Remove comments when pre-processing.                        !
$!  RMDOCINC    Remove documentation in all include files                   !
$!  RMPSIMEAN   Temporary option:  removal of level by level dyn. ht. mean  !
$!  SUNDATE	SUN's intrinsic date routine.                               !
$!  SUNFLUSH    regularly flush output buffers in SUN systems.              !
$!  SUNFPE      enable SUN's Floating Point Exception trap.                 !
$!  UNESCO      Temp. option:  Unesco (1980) nonlinear eq. state: seawater  !
$!                                                                          !
$! New options                                                              !
$!                                                                          !
$!  GRIDOLD       Use old algorithm to set vertical coordinates (back compat.).
$!  MEANTRACER    Compute mean tracers for shapiro mean removal             !
$!  TRYTRBY       Try imposing transport streamfunction BC's in open domains.
$!                                                                          !
$!  PEPSIB      Compute PSIBAR with PE model weighting (precedence over ubpsib)
$!  UBPSIB      Compute PSIBAR with weighting for uniform UBARO             !
$!                                                                          !
$! even newer options                                                       !
$!                                                                          !
$!  BIODUSE        Dusenberry biological model                              !
$!  TRCASCII       ascii file input for biological tracers                  !
$!  READBIOERR     read error fields for biological tracers                 !
$!  MEANTRACER_ZIP Set mean tracer to initial tracer values                 !
$!                                                                          !
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!!!!!!!!!!!!!!!!!!!!!! USERS's tunable definitions !!!!!!!!!!!!!!!!!!!!!!!!!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$!  Set directory paths
$!
$  define/nolog  pibin$dir   [...bin]
$  define/nolog  pi$bin      pibin$dir:pe_initial.exe
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!!!!!!!!!!!!!!!!!!!!!! End USERS's tunable definitions !!!!!!!!!!!!!!!!!!!!!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$goto proceed
$!
$@Compile PE_initial.F
$@Compile all_uc.F
$@Compile avg_isle.F
$@Compile bess1d.F
$@Compile bess2d.F
$@Compile bess2d_pmsk.F
$@Compile blank.F
$@Compile blkdat.F
$@Compile cgpois.F
$@Compile cgpois1.F
$@Compile day_code.F
$@Compile defcdf.F
$@Compile exitus.F
$@Compile external.F
$@Compile fdiagn.F
$@Compile filter.F
$@Compile fsave.F
$@Compile get_cdfdat.F
$@Compile get_data.F
$@Compile get_date.F
$@Compile get_dom.F
$@Compile get_ewpt.F
$@Compile get_opn.F
$@Compile get_parm.F
$@Compile get_pbar.F
$@Compile get_trc.F
$@Compile get_unif.F
$@Compile head_unif.F
$@Compile header_fm.F
$@Compile header_qg.F
$@Compile headln.F
$@Compile inside.F
$@Compile interp.F
$@Compile intrp2d.F
$@Compile intrp_pbar.F
$@Compile length.F
$@Compile lintrp.F
$@Compile ll2xy.F
$@Compile lnblk.F
$@Compile make_transbdy.F
$@Compile mktby_data.F
$@Compile mktby_parm.F
$@Compile no_digit.F
$@Compile op.F
$@Compile op1.F
$@Compile opencdf.F
$@Compile psibar.F
$@Compile psibavg.F
$@Compile psibdy.F
$@Compile put_bry.F
$@Compile put_init.F
$@Compile putdiag.F
$@Compile read1cdf.F
$@Compile read_grids.F
$@Compile read_surfnm.F
$@Compile readcdf.F
$@Compile reset_isle.F
$@Compile rotparm.F
$@Compile save.F
$@Compile scale_err.F
$@Compile set_baro.F
$@Compile set_land.F
$@Compile set_meantrc.F
$@Compile set_oerr.F
$@Compile set_pmask.F
$@Compile set_psi.F
$@Compile setbyclsd.F
$@Compile setbyopn.F
$@Compile setclsd.F
$@Compile setdepths.F
$@Compile shapmean.F
$@Compile spline.F
$@Compile splint.F
$@Compile state_ini.F
$@Compile swapdata.F
$@Compile transbdy.F
$@Compile transobdy.F
$@Compile trc_names.F
$@Compile ts2psi.F
$@Compile vel_err.F
$@Compile velocity.F
$@Compile vertgrid.F
$@Compile wrt_transbdy.F
$@Compile xread.F
$@Compile xtr_psiby.F
$@Compile xy2ll.F
$!
$proceed:
$ set verify
$ DEFINE  LNK$LIBRARY  SYS$LIBRARY:VAXCRTL
$ link/executable=PE_INITIAL	PE_initial,				-
	all_uc,		avg_isle,	blank,		blkdat,		-
	cgpois,		cgpois1,	defcdf,		exitus,		-
	external,	fdiagn,		filter,		fsave,		-
	get_cdfdat,	get_data,	get_date,	get_ewpt,	-
	get_opn,	get_parm,	get_trc,	get_unif,	-
	header_fm,	header_qg,	head_unif,	headln,		-
	inside,		interp,		intrp2d,	length,		-
	lintrp,		ll2xy,		lnblk,		op,		-
	op1,		opencdf,	psibar,		psibavg,	-
	psibdy,		put_bry,	put_init,	read_grids,	-
	read1cdf,	readcdf,	read_surfnm,	reset_isle,	-
	rotparm,	save,		scale_err,	set_baro,	-
	set_land,	set_meantrc,	set_oerr,	set_pmask,	-
	set_psi,	setbyclsd,	setbyopn,	setclsd,	-
	setdepths,	shapmean,	spline,		splint,		-
	state_ini,	swapdata,	transbdy,	transobdy,	-
	trc_names,	ts2psi,		vel_err,	velocity,	-
	xread,		xy2ll,		day_code,	vertgrid,	-
			SYS$USERROOT2:[GUEST.LIB]NETCDF.OLB/lib
$!
$ link/executable=MAKE_TRANSBDY		make_transbdy,			-
	bess1d,		bess2d,		bess2d_pmsk,	blkdat,		-
	exitus,		get_dom,	get_ewpt,	get_opn,	-
	get_pbar,	intrp_pbar,	length,		ll2xy,		-
	mktby_data,	mktby_parm,	no_digit,	rotparm,	-
	set_pmask,	wrt_transbdy,	xtr_psiby,	xy2ll,		-
			SYS$USERROOT2:[GUEST.LIB]NETCDF.OLB/lib
$!
$ exit
