      function avg_isle (lenseg,cstsegx,cstsegy,psi,im,jm)
c
c=======================================================================
c                                                                    ===
c     This function computes the average value of the transport      ===
c     streamfunction along the island coastal segment.               ===
c                                                                    ===
c     Input:                                                         ===
c                                                                    ===
c        lenseg.....Integer.  Number of points in coastal segment.   ===
c        cstsegx....Integer array.  X-coordinates of coastal segment.===
c        cstsegy....Integer array.  Y-coordinates of coastal segment.===
c        psi........Real array.  Estimated transport streamfunction. ===
c        im.........Integer.  Number of grid points in x-direction.  ===
c        jm.........Integer.  Number of grid points in y-direction.  ===
c                                                                    ===
c     Output:                                                        ===
c                                                                    ===
c        avg_isle...Real.  Average value of transport streamfunction ===
c                   along coastal segment.                           ===
c                                                                    ===
c=======================================================================
c
      integer im,jm,lenseg,n
      integer cstsegx(lenseg),cstsegy(lenseg)
      real    avg_isle,c1,psi(im,jm),wt
c
      parameter (c1=1.0)
c
c=======================================================================
c     Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c     Set up weighting.  Initialize average value.
c-----------------------------------------------------------------------
c
      wt = c1/float(lenseg)
c
      avg_isle = psi(cstsegx(1),cstsegy(1))*wt
c
c-----------------------------------------------------------------------
c     Loop over remaining points, adding their contribution to average.
c-----------------------------------------------------------------------
c
      do 10 n = 2, lenseg
         avg_isle = avg_isle + psi(cstsegx(n),cstsegy(n))*wt
10    continue
c
      return
      end
