c
c=======================================================================
c  Include file "cstseg.h" for PE_initial.
c=======================================================================
#ifndef rmdocinc
c
c  CSMASK     mask for land P-points.
c  CSTSEGX    x-index coordinate for each coastal segment.
c  CSTSEGY    y-index coordinate for each coastal segment.
c  CVAL       values of transport function at coastal segments.
c  CVALIS     values of transport function at islands coastal segments.
c  CVALOPN    transport streamfunction at each point for the N-open
c             basin segment.
c  ICVALIS    Switch that indicates how to set transport streamfunction
c             around island N:
c             ICVALIS(n)=0  impose value found internally at the
c                           beginning of the island segment.
c             ICVALIS(n)=1  inpose value given in CVALIS(n).
c  IEIS       ending I-index for each island box.
c  ISIS       starting I-index for each island box.
c  ISMASK     mask at the velocity points used for segment extraction.
c  JEIS       ending J-index for each island box.
c  JSIS       starting J-index for each island box.
c  LANDP      transport streamfunction land/sea mask. [0] sea, [other] cst #
c  LANDT      mask for tracer points: [0] land, [1] sea.
c  LANDV      mask for velocity points: [0] land, [1] boundary, [2] sea.
c  LENSEG     number of points in each coastal segment.
c  LSEGMX     current maximum number of points per coastal segment.
c  NISLE      number of islands in the model basin.
c  NOPNSEG    number of open basin segments (excluding interior
c             islands).
c  NPTSOPN    number of points in each N-open basin segment.
c  NSEG       number of coastal segments.
c  OPENSEG    Switch for handling transport streamfunction along the
c             N-open basin segments:
c             OPENSEG=0     impose values found internally at the
c                           open basin segment (open boundary).
c             OPENSEG=1     impose the values given in CVALOPN(n)
c                           which are prescribed in the file.
# ifdef trytrby
c  USETRBY    Switch for using external transport streamfunction
c             boundary conditions in open domains.
# endif
c
c=======================================================================
#endif
c
      integer lsegmx,nisle,nopnseg,nseg,openseg
      integer csmask(np),cstsegx(mpseg,mcseg),cstsegy(mpseg,mcseg),
     &        icvalis(mcseg),ieis(misle),isis(misle),ismask(np),
     &        jeis(misle),jsis(misle),landp(np),landt(np),landv(np),
     &        lenseg(mcseg),nptsopn(mcseg)
#ifdef trytrby
      logical usetrby
#endif
c
      common /icstseg/ landp,landt,landv,ismask,nseg,lsegmx,lenseg,
     &                 cstsegx,cstsegy,nisle,isis,ieis,jsis,jeis,
     &                 icvalis,csmask,openseg,nopnseg,nptsopn
#ifdef trytrby
     &                ,usetrby
#endif
c
      real cval(mcseg),cvalis(mcseg),cvalopn(mpseg,mcseg)
c
      common /fcstseg/ cval,cvalis,cvalopn
