      subroutine defcdf
c
c=======================================================================
c                                                                    ===
c  This routine creates the PE model netCDF output file, defines the ===
c  netCDF dimensions,  defines  the geometry (coordinates) variables ===
c  and their attributes,  and defines the requested output variables ===
c  and their attributes.  Depth positions are written in "meters" to ===
c  facilitate post-processing and visualization.                     ===
c                                                                    ===
c  Calls:                                                            ===
c                                                                    ===
c     NCCRE, NCDDEF, NCVDEF, NCAPT, NCAPTC, NCVPTC, NCVPT, NCVPT1    ===
c     GET_DATE, LENGTH                                               ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <baropar.h>
#include <cstseg.h>
#include <hybrid.h>
#include <meants.h>
#include <moddat.h>
#include <ndimen.h>
#include <netcdf.inc>
#include <pi_netcdf.h>
#include <switches.h>
#include <iounits.h>
#include <version.h>
#include <zdat.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer ax2dim,ax3dim,chid,dbgn,dend,grdt2id,grdv2id,i,ip,istr,j,
     *        k,ldate,lmod,lrunic,lvnum,m,mbgn,mend,n,omode,rbgn,rend,
     *        rundim,sbgn,send,slen,titldim,tslevdim,usrdim,vbgn,vecdim,
     *        vend
      integer count(4),start(4)
      real c0,c1,cm2m,jul_off,spval
      real blat(mx),blon(mx),f(np),lat(np),lon(np)
      character*44  fldnam,errnam,date_str
      character*80  runic,titleic
      character*120 history
      character*256 wkstr
      parameter (c0=0.0,c1=1.0,cm2m=0.01,jul_off=2440000.0,
     *           spval=1.0e+35)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c  Create netCDF file.
c
      call ncpopt (ncverbos)
      call length (fname(1),slen,sbgn,send)
      ncoutid = nccre (fname(1)(sbgn:send),ncclob,rcode)
      if (rcode.eq.0) then
        ncoutfl = 1
       else
        write(stdout,900) fname(1)(sbgn:send)
        call exitus ('DEFCDF')
      endif
c
c  Create history attribute.
c
      call get_date (date_str)
      call length (date_str,ldate,dbgn,dend)
      call length (model,lmod,mbgn,mend)
      call length (vnum,lvnum,vbgn,vend)
      if (ldate.gt.0) then
        history=model(mbgn:mend)//', Version '//vnum(vbgn:vend)//', '
     &          //date_str(dbgn:dend)
      else
        history=model(mbgn:mend)//', Version '//vnum(vbgn:vend)
      endif
c
c  Create run identifier.
c
      call length (vdate,slen,sbgn,send)
      runic = model(mbgn:mend)//', version '//vnum(vbgn:vend)//'   '
     &        //vdate(sbgn:send)
      call length (runic,lrunic,rbgn,rend)
c
c  Define fill mode.  Initialize arrays to default.
c
      omode=ncsfil(ncoutid,ncfill,rcode)
c
c  Define the dimensions of the netCDF fields.
c
      tlondim = ncddef (ncoutid,'tlon',im,rcode)
      tlatdim = ncddef (ncoutid,'tlat',jm,rcode)
      vlondim = ncddef (ncoutid,'vlon',im,rcode)
      vlatdim = ncddef (ncoutid,'vlat',jm,rcode)
      levdim  = ncddef (ncoutid,'level',km,rcode)
      if ((idbug.ne.0).and.(job.ne.3)) then
         lvldim  = ncddef (ncoutid,'flatlevel',kfld,rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'dimension '//char(34)//'flatlevel'//
     &                         char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
      end if
      vecdim  = ncddef (ncoutid,'vector',2,rcode)
      ntrcdim = ncddef (ncoutid,'tracer',nt,rcode)
      if (job.ne.1) then
        time0dim = ncddef (ncoutid,'time0',1,rcode)
      endif
      timedim = ncddef (ncoutid,'time',ncunlim,rcode)
      ax2dim  = ncddef (ncoutid,'axis2',2,rcode)
      ax3dim  = ncddef (ncoutid,'axis3',3,rcode)
      if (job.ne.1) then
        brydim  = ncddef (ncoutid,'boundary',4,rcode)
        bptsdim = ncddef (ncoutid,'bpts',max(im,jm),rcode)
      endif
      if (icoast.ne.0) then
        ncsegdim = ncddef (ncoutid,'ncseg',nseg,rcode)
        lcsegdim = ncddef (ncoutid,'lcseg',lsegmx,rcode)
        if(nisle.gt.0) isledim = ncddef (ncoutid,'island',nisle,rcode)
      endif
      if (lwrtoerr.and.(job.eq.1)) then
        flddim = ncddef (ncoutid,'field',nt+3,rcode)
      endif
      tslevdim = ncddef (ncoutid,'tslev',nprof,rcode)
      usrdim   = ncddef (ncoutid,'usrdim',10,rcode)
      rundim   = ncddef (ncoutid,'lenrun',lrunic,rcode)
      titldim  = ncddef (ncoutid,'lentit',80,rcode)
c
c  Define dimension vectors for tracer and velocity type variables.
c
      tdim(1) = levdim
      tdim(2) = tlondim
      tdim(3) = tlatdim
      if (job.eq.1) then
        tdim(4) = timedim
      else
        tdim(4) = time0dim
      endif
c
      tbdim(1) = ntrcdim
      tbdim(2) = levdim
      tbdim(3) = bptsdim
      tbdim(4) = brydim
      tbdim(5) = timedim
c
      tg2dim(1) = ax2dim
      tg2dim(2) = tlondim
      tg2dim(3) = tlatdim
c
      tg3dim(1) = ax3dim
      tg3dim(2) = levdim
      tg3dim(3) = tlondim
      tg3dim(4) = tlatdim
c
      vdim(1) = vecdim
      vdim(2) = levdim
      vdim(3) = vlondim
      vdim(4) = vlatdim
      if (job.eq.1) then
        vdim(5) = timedim
      else
        vdim(5) = time0dim
      endif
c
      vbdim(1) = vecdim
      vbdim(2) = levdim
      vbdim(3) = bptsdim
      vbdim(4) = brydim
      vbdim(5) = timedim
c
      vg2dim(1) = ax2dim
      vg2dim(2) = vlondim
      vg2dim(3) = vlatdim
c
      vg3dim(1) = ax3dim
      vg3dim(2) = levdim
      vg3dim(3) = vlondim
      vg3dim(4) = vlatdim
c
      gb2dim(1) = ax2dim
      gb2dim(2) = bptsdim
      gb2dim(3) = brydim
c
      gb3dim(1) = ax3dim
      gb3dim(2) = levdim
      gb3dim(3) = bptsdim
      gb3dim(4) = brydim
c
      if (icoast.ne.0) then
        cstdim(1) = lcsegdim
        cstdim(2) = ncsegdim
      endif
c
      if (lwrtoerr.and.(job.eq.1)) then
        fdim(1) = flddim
        fdim(2) = levdim
        fdim(3) = timedim
      endif
c
      vartyp = ncfloat
c
c-----------------------------------------------------------------------
c  Define titles and scalar variables and their attributes in the
c   netCDF file.
c-----------------------------------------------------------------------
c
c  Define global titles to netCDF file.
c
      if (job.eq.1) then
        wkstr = 'PE model assimilation data'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,ncglobal,'title',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
      else
        wkstr = 'PE model initialization and boundary data'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,ncglobal,'title',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
      endif
      call length (fname(1),slen,sbgn,send)
      call ncaptc (ncoutid,ncglobal,'out_file',ncchar,slen,
     *             fname(1)(sbgn:send),rcode)
      call length (fname(3),slen,sbgn,send)
      call ncaptc (ncoutid,ncglobal,'inp_file',ncchar,slen,
     *             fname(3)(sbgn:send),rcode)
      call length (fname(5),slen,sbgn,send)
      call ncaptc (ncoutid,ncglobal,'grd_file',ncchar,slen,
     *             fname(5)(sbgn:send),rcode)
      call length (fname(4),slen,sbgn,send)
      call ncaptc (ncoutid,ncglobal,'T-S_file',ncchar,slen,
     *             fname(4)(sbgn:send),rcode)
      if ((iflag(5)/4).eq.2) then
         call length (fname(9),slen,sbgn,send)
         call ncaptc (ncoutid,ncglobal,'SurfNM_file',ncchar,slen,
     &                fname(9)(sbgn:send),rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'global attribute '//char(34)//'SurfNM'//
     &                         '_file'//char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
      endif
      call ncaptc (ncoutid,ncglobal,'type',ncchar,lmod,model(mbgn:mend),
     *             rcode)
      call ncaptc (ncoutid,ncglobal,'version',ncchar,lvnum,
     *             vnum(vbgn:vend),rcode)
      call length (history,slen,sbgn,send)
      call ncaptc (ncoutid,ncglobal,'history',ncchar,slen,
     *             history(sbgn:send),rcode)
c
c  Define character variables (titles).
c
      chid = ncvdef (ncoutid,'titleic',ncchar,1,titldim,rcode)
      chid = ncvdef (ncoutid,'runic',ncchar,1,rundim,rcode)
c
c  PE model dimensions.
c
      varid = ncvdef (ncoutid,'imt',nclong,0,0,rcode)
      wkstr = 'number of tracer points in the x-direction'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'jmt',nclong,0,0,rcode)
      wkstr = 'number of tracer points in the y-direction'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'km',nclong,0,0,rcode)
      wkstr = 'number of vertical levels'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'nt',nclong,0,0,rcode)
      wkstr = 'number of tracer type variables'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      if (job.ne.1) then
        varid = ncvdef (ncoutid,'bpts',nclong,0,0,rcode)
        wkstr = 'maximum number of boundary points, max(IMT,JMT)'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
c
        varid = ncvdef (ncoutid,'boundary',nclong,0,0,rcode)
        wkstr = 'boundary edge'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = '1: west, 2: south, 3: east, 4: north'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,varid,'options',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
      endif
      if (icoast.ne.0) then
        varid = ncvdef (ncoutid,'ncseg',nclong,0,0,rcode)
        wkstr = 'number of coastal segments'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
c
        varid = ncvdef (ncoutid,'lcseg',nclong,0,0,rcode)
        wkstr = 'maximum length of coastal segments'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
c
        if (nisle.gt.0) then
          varid = ncvdef (ncoutid,'nisle',nclong,0,0,rcode)
          wkstr = 'number of islands'
          call length (wkstr,slen,sbgn,send)
          call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *                 wkstr(sbgn:send),rcode)
        endif
      endif
c
c  Model domain parameters.
c
      varid = ncvdef (ncoutid,'coord',nclong,0,0,rcode)
      wkstr = 'flag for type of horizontal grid'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'cartesian (tangent plane) grid'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'option_0',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'unrotated spherical grid'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'option_1',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'rotated spherical grid'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'option_2',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'rlngd',ncfloat,0,0,rcode)
      wkstr = 'Transformation centroid longitude'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'degrees_east'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'rlatd',ncfloat,0,0,rcode)
      wkstr = 'Transformation centroid latitude'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'degrees_north'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'delx',ncfloat,0,0,rcode)
      wkstr = 'Longitudinal offset from transformation point to grid '//
     &        'center'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      if (coord.eq.0) then
        wkstr = 'centimeter'
       elseif ((coord.eq.1).or.(coord.eq.2)) then
        wkstr = 'degrees'
      endif
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'dely',ncfloat,0,0,rcode)
      wkstr = 'Latitudinal offset from transformation point to grid '//
     &        'center'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      if (coord.eq.0) then
        wkstr = 'centimeter'
       elseif ((coord.eq.1).or.(coord.eq.2)) then
        wkstr = 'degrees'
      endif
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'thetad',ncfloat,0,0,rcode)
      wkstr = 'domain rotation angle'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'degrees'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'gridx',ncfloat,0,0,rcode)
      wkstr = 'zonal grid spacing across tracer boxes'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      if (coord.eq.0) then
        wkstr = 'centimeter'
       elseif ((coord.eq.1).or.(coord.eq.2)) then
        wkstr = 'degrees'
      endif
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'gridy',ncfloat,0,0,rcode)
      wkstr = 'meridional grid spacing across tracer boxes'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      if (coord.eq.0) then
        wkstr = 'centimeter'
       elseif ((coord.eq.1).or.(coord.eq.2)) then
        wkstr = 'degrees'
      endif
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
c  Define double vertical coordinate transformation parameters.
c  Application programs will access these parameters in meters.
c
      if (dblsigma.eq.1) then
        varid = ncvdef (ncoutid,'zc1',ncfloat,0,0,rcode)
        wkstr = 'minimum depth of the coordinate interface'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'centimeter'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
c
        varid = ncvdef (ncoutid,'zc2',ncfloat,0,0,rcode)
        wkstr = 'maximum depth of the coordinate interface'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'centimeter'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
c
        varid = ncvdef (ncoutid,'zref',ncfloat,0,0,rcode)
        wkstr = 'reference depth for coordinate interface'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'centimeter'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
c
        varid = ncvdef (ncoutid,'zslope',ncfloat,0,0,rcode)
        wkstr = 'slope parameter of the coordinate interface'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
      endif
c
c-----------------------------------------------------------------------
c  Define flags and mean T-S profile arrays and their attributes
c  in the netCDF file.
c-----------------------------------------------------------------------
c
c  Switches.
c
      varid = ncvdef (ncoutid,'iflag',nclong,1,usrdim,rcode)
      wkstr = 'initialization flags'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
c  Velocity computation parameters.
c
      varid = ncvdef (ncoutid,'its2psi',nclong,0,0,rcode)
      if (rcode.ne.0) then
         call length (fname(1),slen,sbgn,send)
         write (stdout,910) 'variable '//char(34)//'its2psi'//
     &                      char(34),fname(1)(sbgn:send)
         call exitus ('DEFCDF')
      endif
      wkstr = 'flag to recompute dynamic height from input TS fields'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
      if (rcode.ne.0) then
         call length (fname(1),slen,sbgn,send)
         write (stdout,910) 'attribute '//char(34)//'its2psi:'//
     &                      'long_name'//char(34),fname(1)(sbgn:send)
         call exitus ('DEFCDF')
      endif
      wkstr = 'do NOT recompute'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'option_0',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
      if (rcode.ne.0) then
         call length (fname(1),slen,sbgn,send)
         write (stdout,910) 'attribute '//char(34)//'its2psi:'//
     &                      'option_0'//char(34),fname(1)(sbgn:send)
         call exitus ('DEFCDF')
      endif
      wkstr = 'recompute'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'option_1',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
      if (rcode.ne.0) then
         call length (fname(1),slen,sbgn,send)
         write (stdout,910) 'attribute '//char(34)//'its2psi:'//
     &                      'option_1'//char(34),fname(1)(sbgn:send)
         call exitus ('DEFCDF')
      endif
c
c  External mode computation parameters.
c
      if ((iflag(5)/4).eq.1) then
         varid = ncvdef (ncoutid,'def_depth',ncfloat,0,0,rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'variable '//char(34)//'def_depth'//
     &                         char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
         wkstr = 'reference depth for geostrophic recalculation'
         call length (wkstr,slen,sbgn,send)
         call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     &                wkstr(sbgn:send),rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'attribute '//char(34)//'def_depth:'//
     &                         'long_name'//char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
         wkstr = 'meter'
         call length (wkstr,slen,sbgn,send)
         call ncaptc (ncoutid,varid,'units',ncchar,slen,
     &                wkstr(sbgn:send),rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'attribute '//char(34)//'def_depth:'//
     &                         'units'//char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
      end if
c
      if (mod(iflag(5),4).gt.1) then
         varid = ncvdef (ncoutid,'wbot_depth',ncfloat,0,0,rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'variable '//char(34)//'wbot_depth'//
     &                         char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
         wkstr = 'maximum depth for complete bottom steering'
         call length (wkstr,slen,sbgn,send)
         call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     &                wkstr(sbgn:send),rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'attribute '//char(34)//'wbot_depth:'//
     &                         'long_name'//char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
         wkstr = 'meter'
         call length (wkstr,slen,sbgn,send)
         call ncaptc (ncoutid,varid,'units',ncchar,slen,
     &                wkstr(sbgn:send),rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'attribute '//char(34)//'wbot_depth:'//
     &                         'units'//char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
      end if
c
c  Mean TS profile.
c
      varid = ncvdef (ncoutid,'zclima',ncfloat,1,tslevdim,rcode)
      wkstr = 'depths of mean TS profile'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'meter'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'tclima',ncfloat,1,tslevdim,rcode)
      wkstr = 'mean temperature profile'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'Celsius'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'sclima',ncfloat,1,tslevdim,rcode)
      wkstr = 'mean salinity profile'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'PSU'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
c-----------------------------------------------------------------------
c  Define geometry variables and their attributes in the netCDF file.
c-----------------------------------------------------------------------
c
c  Define depths and thicknesses for the flat reference levels.
c  Application programs will access these field in meters.
c
      varid = ncvdef (ncoutid,'refz',ncfloat,1,levdim,rcode)
      wkstr = 'depths at center of the flat-grid vertical boxes'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'centimeter'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'hz',ncfloat,1,levdim,rcode)
      wkstr = 'thicknesses of the flat-grid vertical boxes'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'centimeter'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
c  Bathymetry (meters) at the tracer points.
c
      tbthid = ncvdef (ncoutid,'tbath',ncfloat,2,tdim(2),rcode)
      wkstr = 'bathymetry at tracer points'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,tbthid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'meter'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,tbthid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'bathymetry, scalar'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,tbthid,'field',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'tgrid2'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,tbthid,'positions',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
#ifndef gridold
c
c  Bathymetry (meters) at the velocity points.
c
      vbthid = ncvdef (ncoutid,'vbath',ncfloat,2,tdim(2),rcode)
      wkstr = 'bathymetry at velocity points'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,vbthid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'meter'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,vbthid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'bathymetry, scalar'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,vbthid,'field',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'vgrid2'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,vbthid,'positions',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
c  Coordinate Interface (meters) at the tracer points.
c
      if (dblsigma.eq.1) then
         tifcid = ncvdef (ncoutid,'interface',ncfloat,2,tdim(2),rcode)
         wkstr = 'coordinate interface at tracer points'
         call length (wkstr,slen,sbgn,send)
         call ncaptc (ncoutid,tifcid,'long_name',ncchar,slen,
     *                wkstr(sbgn:send),rcode)
         wkstr = 'meter'
         call length (wkstr,slen,sbgn,send)
         call ncaptc (ncoutid,tifcid,'units',ncchar,slen,
     *                wkstr(sbgn:send),rcode)
         wkstr = 'interface, scalar'
         call length (wkstr,slen,sbgn,send)
         call ncaptc (ncoutid,tifcid,'field',ncchar,slen,
     *                wkstr(sbgn:send),rcode)
         wkstr = 'tgrid2'
         call length (wkstr,slen,sbgn,send)
         call ncaptc (ncoutid,tifcid,'positions',ncchar,slen,
     *                wkstr(sbgn:send),rcode)
      end if
c
c  Coordinate Interface (meters) at the velocity points.
c
      if (dblsigma.eq.1) then
         vifcid = ncvdef (ncoutid,'viface',ncfloat,2,tdim(2),rcode)
         wkstr = 'coordinate interface at velocity points'
         call length (wkstr,slen,sbgn,send)
         call ncaptc (ncoutid,vifcid,'long_name',ncchar,slen,
     *                wkstr(sbgn:send),rcode)
         wkstr = 'meter'
         call length (wkstr,slen,sbgn,send)
         call ncaptc (ncoutid,vifcid,'units',ncchar,slen,
     *                wkstr(sbgn:send),rcode)
         wkstr = 'vel_interface, scalar'
         call length (wkstr,slen,sbgn,send)
         call ncaptc (ncoutid,vifcid,'field',ncchar,slen,
     *                wkstr(sbgn:send),rcode)
         wkstr = 'vgrid2'
         call length (wkstr,slen,sbgn,send)
         call ncaptc (ncoutid,vifcid,'positions',ncchar,slen,
     *                wkstr(sbgn:send),rcode)
      end if
#endif
c
c  Define coastal segments and land/sea mask at the tracer and
c  velocity points.  Define island box(es).
c
      if (icoast.ne.0) then
        varid = ncvdef (ncoutid,'lencoast',nclong,1,ncsegdim,rcode)
        wkstr = 'length of coastal segments'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
c
        csegxid = ncvdef (ncoutid,'icoast',nclong,2,cstdim,rcode)
        wkstr = 'coastal segment x-index coordinate'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,csegxid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt  (ncoutid,csegxid,'valid_min',nclong,1,1,rcode)
        call ncapt  (ncoutid,csegxid,'valid_max',nclong,1,im,rcode)
        call ncapt  (ncoutid,csegxid,'_FillValue',nclong,1,0,rcode)
c
        csegyid = ncvdef (ncoutid,'jcoast',nclong,2,cstdim,rcode)
        wkstr = 'coastal segment y-index coordinate'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,csegyid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt  (ncoutid,csegyid,'valid_min',nclong,1,1,rcode)
        call ncapt  (ncoutid,csegyid,'valid_max',nclong,1,jm,rcode)
        call ncapt  (ncoutid,csegyid,'_FillValue',nclong,1,0,rcode)
c
        landtid = ncvdef (ncoutid,'landt',nclong,2,tdim(2),rcode)
        wkstr = 'land/sea mask at tracer points'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,landtid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = '0: land, 1: sea'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,landtid,'options',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'Tmask, scalar'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,landtid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'tgrid2'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,landtid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
c
        landvid = ncvdef (ncoutid,'landv',nclong,2,vdim(3),rcode)
        wkstr = 'land/sea mask at velocity points'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,landvid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = '0: land, 1: boundary, 2: sea'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,landvid,'options',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'Vmask, scalar'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,landvid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'vgrid2'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,landvid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
c
        if (nisle.gt.0) then
          isisid = ncvdef (ncoutid,'isis',nclong,1,isledim,rcode)
          wkstr = 'starting x-index coordinate of island box'
          call length (wkstr,slen,sbgn,send)
          call ncaptc (ncoutid,isisid,'long_name',ncchar,slen,
     *                 wkstr(sbgn:send),rcode)
          call ncapt (ncoutid,isisid,'valid_min',nclong,1,1,rcode)
          call ncapt (ncoutid,isisid,'valid_max',nclong,1,im,rcode)
c
          ieisid = ncvdef (ncoutid,'ieis',nclong,1,isledim,rcode)
          wkstr = 'ending x-index coordinate of island box'
          call length (wkstr,slen,sbgn,send)
          call ncaptc (ncoutid,ieisid,'long_name',ncchar,slen,
     *                 wkstr(sbgn:send),rcode)
          call ncapt (ncoutid,ieisid,'valid_min',nclong,1,1,rcode)
          call ncapt (ncoutid,ieisid,'valid_max',nclong,1,im,rcode)
c
          jsisid = ncvdef (ncoutid,'jsis',nclong,1,isledim,rcode)
          wkstr = 'starting y-index coordinate of island box'
          call length (wkstr,slen,sbgn,send)
          call ncaptc (ncoutid,jsisid,'long_name',ncchar,slen,
     *                 wkstr(sbgn:send),rcode)
          call ncapt (ncoutid,jsisid,'valid_min',nclong,1,1,rcode)
          call ncapt (ncoutid,jsisid,'valid_max',nclong,1,jm,rcode)
c
          jeisid = ncvdef (ncoutid,'jeis',nclong,1,isledim,rcode)
          wkstr = 'ending y-index coordinate of island box'
          call length (wkstr,slen,sbgn,send)
          call ncaptc (ncoutid,jeisid,'long_name',ncchar,slen,
     *                 wkstr(sbgn:send),rcode)
          call ncapt (ncoutid,jeisid,'valid_min',nclong,1,1,rcode)
          call ncapt (ncoutid,jeisid,'valid_max',nclong,1,jm,rcode)
        endif
      endif
c
c  Define 2D grid positions at tracer and velocity points.  These fields
c  are used in the visualization modules.
c
c  2D Tracer grid
c
      tg2did = ncvdef (ncoutid,'tgrid2',ncfloat,3,tg2dim,rcode)
      wkstr = '2D grid positions at tracer points'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,tg2did,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = '1: longitude, 2: latitude'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,tg2did,'axis',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'degrees_east, degrees_north'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,tg2did,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
c  2D Velocity grid
c
      vg2did = ncvdef (ncoutid,'vgrid2',ncfloat,3,vg2dim,rcode)
      wkstr = '2D grid positions at velocity points'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,vg2did,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = '1: longitude, 2: latitude'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,vg2did,'axis',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'degrees_east, degrees_north'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,vg2did,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
c  Flat-level Velocity grid
c
c
      if ((idbug.ne.0).and.(job.ne.3)) then
c
c    Horizontal components
c
         vg2dim(1) = ax3dim
         vgflid = ncvdef (ncoutid,'vgridfl',ncfloat,3,vg2dim,rcode)
         vg2dim(1) = ax2dim
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'variable '//char(34)//'vgridfl'//
     &                         char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
c
         wkstr = 'Flat grid horizontal positions at velocity points'
         call length (wkstr,slen,sbgn,send)
         call ncaptc (ncoutid,vgflid,'long_name',ncchar,slen,
     &                wkstr(sbgn:send),rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'attribute '//char(34)//'vgridfl:'//
     &                         'long_name'//char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
c
         wkstr = '1: longitude, 2: latitude, 3: depth'
         call length (wkstr,slen,sbgn,send)
         call ncaptc (ncoutid,vgflid,'axis',ncchar,slen,
     *                wkstr(sbgn:send),rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'attribute '//char(34)//'vgridfl:'//
     &                         'axis'//char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
c
         wkstr = 'degrees_east, degrees_north, meter'
         call length (wkstr,slen,sbgn,send)
         call ncaptc (ncoutid,vgflid,'units',ncchar,slen,
     *                wkstr(sbgn:send),rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'attribute '//char(34)//'vgridfl:'//
     &                         'units'//char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
c
         call ncapt (ncoutid,vgflid,'_FillValue',ncfloat,1,spval,rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'attribute '//char(34)//'vgridfl:_Fill'//
     &                         'Value'//char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
c
c    Vertical component
c
         vg3dim(2) = lvldim
         zfltid = ncvdef (ncoutid,'zflat',ncfloat,2,vg3dim,rcode)
         vg3dim(2) = levdim
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'variable '//char(34)//'zflat'//
     &                         char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
c
         wkstr = 'Depths at original flat levels'
         call length (wkstr,slen,sbgn,send)
         call ncaptc (ncoutid,zfltid,'long_name',ncchar,slen,
     &                wkstr(sbgn:send),rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'attribute '//char(34)//'zflat:'//
     &                         'long_name'//char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
c
         wkstr = '1: longitude, 2: latitude, 3: depth'
         call length (wkstr,slen,sbgn,send)
         call ncaptc (ncoutid,zfltid,'axis',ncchar,slen,
     *                wkstr(sbgn:send),rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'attribute '//char(34)//'zflat:'//
     &                         'axis'//char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
c
         wkstr = 'degrees_east, degrees_north, meter'
         call length (wkstr,slen,sbgn,send)
         call ncaptc (ncoutid,zfltid,'units',ncchar,slen,
     *                wkstr(sbgn:send),rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'attribute '//char(34)//'zflat:'//
     &                         'units'//char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
c
         call ncapt (ncoutid,zfltid,'_FillValue',ncfloat,1,spval,rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'attribute '//char(34)//'zflat:_Fill'//
     &                         'Value'//char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
      end if
c
c  Define 3D grid positions at tracer and velocity points.  These fields
c  are used in the vizualization modules.
c
      tg3did = ncvdef (ncoutid,'tgrid3',ncfloat,4,tg3dim,rcode)
      wkstr = '3D grid positions at tracer points'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,tg3did,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = '1: longitude, 2: latitude, 3: depth'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,tg3did,'axis',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'degrees_east, degrees_north, meter'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,tg3did,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      vg3did = ncvdef (ncoutid,'vgrid3',ncfloat,4,vg3dim,rcode)
      wkstr = '3D grid positions at velocity points'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,vg3did,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = '1: longitude, 2: latitude, 3: depth'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,vg3did,'axis',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'degrees_east, degrees_north, meter'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,vg3did,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
c  Define 3D tracer and velocity box thicknesses.  These fields
c  are used to define the vertical system.
c
      varid = ncvdef (ncoutid,'dzt',ncfloat,3,tg3dim(2),rcode)
      wkstr = '3D tracer box thicknesses'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'meter'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'dzv',ncfloat,3,vg3dim(2),rcode)
      wkstr = '3D velocity box thicknesses'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'meter'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
c  Define 2D and 3D grid positions for boundary tracer and velocity
c  points.  These fields are used in the visualization of boundary
c  conditions by the visualization modules.
c
      if (job.eq.0) then
        tg2bid = ncvdef (ncoutid,'tbgrid2',ncfloat,3,gb2dim,rcode)
        wkstr = '2D boundary grid positions at tracer points'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,tg2bid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = '1: longitude, 2: latitude'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,tg2bid,'axis',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'degrees_east, degrees_north'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,tg2bid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'west; south; east; north'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,tg2bid,'boundary',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,tg2bid,'_FillValue',ncfloat,1,spval,rcode)
c
        qg2bid = ncvdef (ncoutid,'qbgrid2',ncfloat,3,gb2dim,rcode)
        wkstr = '2D boundary grid positions for vorticity'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,qg2bid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = '1: longitude, 2: latitude'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,qg2bid,'axis',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'degrees_east, degrees_north'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,qg2bid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'west; south; east; north'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,qg2bid,'boundary',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,qg2bid,'_FillValue',ncfloat,1,spval,rcode)
c
        tg3bid = ncvdef (ncoutid,'tbgrid3',ncfloat,4,gb3dim,rcode)
        wkstr = '3D boundary grid positions at tracer points'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,tg3bid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = '1: longitude, 2: latitude, 3: depth'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,tg3bid,'axis',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'degrees_east, degrees_north, meter'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,tg3bid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'west; south; east; north'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,tg3bid,'boundary',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,tg3bid,'_FillValue',ncfloat,1,spval,rcode)
c
        vg3bid = ncvdef (ncoutid,'vbgrid3',ncfloat,4,gb3dim,rcode)
        wkstr = '3D boundary grid positions at velocity points'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vg3bid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = '1: longitude, 2: latitude, 3: depth'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vg3bid,'axis',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'degrees_east, degrees_north, meter'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vg3bid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'west; south; east; north'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vg3bid,'boundary',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,vg3bid,'_FillValue',ncfloat,1,spval,rcode)
      endif
c
c-----------------------------------------------------------------------
c  Define time coordinates.
c-----------------------------------------------------------------------
c
      if (job.ne.1) then
        time0id = ncvdef (ncoutid,'time0',ncfloat,1,time0dim,rcode)
        wkstr = 'initialization time'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,time0id,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
      endif
      timeid = ncvdef (ncoutid,'time',ncfloat,1,timedim,rcode)
      wkstr = 'time'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,timeid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      if (ifile.eq.2) then
        if (job.ne.1) then
          wkstr = 'days since QG initialization'
          call length (wkstr,slen,sbgn,send)
          call ncaptc (ncoutid,time0id,'units',ncchar,slen,
     *                 wkstr(sbgn:send),rcode)
        endif
        wkstr = 'days since QG initialization'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,timeid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
      else
        if(job.ne.1) then
          wkstr = 'modified Julian day'
          call length (wkstr,slen,sbgn,send)
          call ncaptc (ncoutid,time0id,'units',ncchar,slen,
     *                 wkstr(sbgn:send),rcode)
          call ncapt (ncoutid,time0id,'add_offset',ncfloat,1,jul_off,
     *                rcode)
        endif
        wkstr = 'modified Julian day'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,timeid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,timeid,'add_offset',ncfloat,1,jul_off,rcode)
      endif
c
c-----------------------------------------------------------------------
c  Define initial and boundary fields and their attributes.
c-----------------------------------------------------------------------
c
      if (job.ne.1) then
c
c  Internal mode velocity.
c
        viniid = ncvdef (ncoutid,'vclin',vartyp,5,vdim,rcode)
        wkstr = 'initialization, internal mode velocity'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,viniid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'zonal, meridional'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,viniid,'vector',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'centimeter second-1'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,viniid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'baroclinic velocity, vector, series'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,viniid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'vgrid3'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,viniid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,viniid,'_FillValue',ncfloat,1,spval,rcode)
c
        vbryid = ncvdef (ncoutid,'vbry',vartyp,5,vbdim,rcode)
        wkstr = 'boundary, baroclinic velocity'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vbryid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'zonal, meridional'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vbryid,'vector',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'centimeter second-1'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vbryid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'boundary velocity, vector, series'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vbryid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'vbgrid3'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vbryid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'west; south; east; north'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vbryid,'boundary',ncchar,sbgn,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,vbryid,'_FillValue',ncfloat,1,spval,rcode)
c
c  Define tracer type variables.
c
        do 10 m=1,nt
c
c    Basic tracer.
c
          fldnam = tname(1,m)
          call length (fldnam,slen,sbgn,send)
          tiniid(m) = ncvdef (ncoutid,fldnam(sbgn:send),vartyp,4,tdim,
     &                        rcode)
          call length (tname(2,m),slen,sbgn,send)
          wkstr = 'initialization, '//tname(2,m)(sbgn:send)
          call length (wkstr,slen,sbgn,send)
          call ncaptc (ncoutid,tiniid(m),'long_name',ncchar,slen,
     *                 wkstr(sbgn:send),rcode)
          call length (tname(3,m),slen,sbgn,send)
          call ncaptc(ncoutid,tiniid(m),'units',ncchar,slen,
     *                tname(3,m)(sbgn:send),rcode)
          call length (tname(4,m),slen,sbgn,send)
          wkstr = tname(4,m)(sbgn:send)//', series'
          call length (wkstr,slen,sbgn,send)
          call ncaptc (ncoutid,tiniid(m),'field',ncchar,slen,
     *                 wkstr(sbgn:send),rcode)
          wkstr = 'tgrid3'
          call length (wkstr,slen,sbgn,send)
          call ncaptc (ncoutid,tiniid(m),'positions',ncchar,slen,
     *                 wkstr(sbgn:send),rcode)
          call ncapt (ncoutid,tiniid(m),'_FillValue',ncfloat,1,spval,
     &                rcode)
#ifdef meantracer
c
c    "Mean" tracer.
c
          call length (tname(1,m),slen,sbgn,send)
          fldnam = tname(1,m)(sbgn:send)//'mean'
          call length (fldnam,slen,sbgn,send)
          tmenid(m) = ncvdef (ncoutid,fldnam(sbgn:send),vartyp,4,tdim,
     &                        rcode)
          call length (tname(2,m),slen,sbgn,send)
          wkstr = 'mean, '//tname(2,m)(sbgn:send)
          call length (wkstr,slen,sbgn,send)
          call ncaptc (ncoutid,tmenid(m),'long_name',ncchar,slen,
     *                 wkstr(sbgn:send),rcode)
          call length (tname(3,m),slen,sbgn,send)
          call ncaptc(ncoutid,tmenid(m),'units',ncchar,slen,
     *                tname(3,m)(sbgn:send),rcode)
          call length (tname(4,m),slen,sbgn,send)
          wkstr = 'mean '//tname(4,m)(sbgn:send)//', series'
          call length (wkstr,slen,sbgn,send)
          call ncaptc (ncoutid,tmenid(m),'field',ncchar,slen,
     *                 wkstr(sbgn:send),rcode)
          wkstr = 'tgrid3'
          call length (wkstr,slen,sbgn,send)
          call ncaptc (ncoutid,tmenid(m),'positions',ncchar,slen,
     *                 wkstr(sbgn:send),rcode)
#endif
  10    continue
c
        tbryid = ncvdef (ncoutid,'tbry',vartyp,5,tbdim,rcode)
        wkstr = 'boundary, tracer type of variables'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,tbryid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'temperature, salinity, other tracers'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,tbryid,'tracer',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'Celsius, PSS, other tracer units'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,tbryid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'boundary tracers, vector, series'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,tbryid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'tbgrid3'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,tbryid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'west; south; east; north'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,tbryid,'boundary',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,tbryid,'_FillValue',ncfloat,1,spval,rcode)
c
c  Define transport streamfunction.
c
        piniid = ncvdef (ncoutid,'pbar',vartyp,3,tdim(2),rcode)
        wkstr = 'initialization, transport streamfunction'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,piniid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'centimeter3 second-1'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,piniid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'transport, scalar, series'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,piniid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'tgrid2'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,piniid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,piniid,'_FillValue',ncfloat,1,spval,rcode)
c
        pbryid = ncvdef (ncoutid,'pbry',vartyp,3,tbdim(3),rcode)
        wkstr = 'boundary, transport streamfunction'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,pbryid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'centimeter3 second-1'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,pbryid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'boundary transport, scalar, series'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,pbryid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'tbgrid2'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,pbryid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'west; south; east; north'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,pbryid,'boundary',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,pbryid,'_FillValue',ncfloat,1,spval,rcode)
c
c  Define rate of change of barotropic vorticity across the boundary.
c
        qbryid = ncvdef (ncoutid,'qbry',vartyp,3,tbdim(3),rcode)
        wkstr = 'boundary, time rate of change of barotropic vorticity'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,qbryid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'second-1'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,qbryid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'boundary vorticity, scalar, series'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,qbryid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'qbgrid2'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,qbryid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'west; south; east; north'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,qbryid,'boundary',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,qbryid,'_FillValue',ncfloat,1,spval,rcode)
      endif
c
c-----------------------------------------------------------------------
c  Define assimilation fields and their attributes.
c-----------------------------------------------------------------------
c
      if (job.eq.1) then
c
c  Internal mode velocity.
c
        vobsid = ncvdef (ncoutid,'vclin',vartyp,5,vdim,rcode)
        wkstr = 'assimilation, baroclinic velocity'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vobsid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'zonal, meridional'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vobsid,'vector',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'centimeter second-1'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vobsid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'baroclinic velocity, vector, series'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vobsid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'vgrid3'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vobsid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,vobsid,'_FillValue',ncfloat,1,spval,rcode)
        if (lwrtoerr) then
          verrid = ncvdef (ncoutid,'vclinerr',vartyp,5,vdim,rcode)
          wkstr = 'observation error, baroclinic velocity'
          call length (wkstr,slen,sbgn,send)
          call ncaptc (ncoutid,verrid,'long_name',ncchar,slen,
     *                 wkstr(sbgn:send),rcode)
          wkstr = 'zonal, meridional'
          call length (wkstr,slen,sbgn,send)
          call ncaptc (ncoutid,verrid,'vector',ncchar,slen,
     *                 wkstr(sbgn:send),rcode)
          wkstr = 'normalized'
          call length (wkstr,slen,sbgn,send)
          call ncaptc (ncoutid,verrid,'units',ncchar,slen,
     *                 wkstr(sbgn:send),rcode)
          wkstr = 'velocity error, vector, series'
          call length (wkstr,slen,sbgn,send)
          call ncaptc (ncoutid,verrid,'field',ncchar,slen,
     *                 wkstr(sbgn:send),rcode)
          wkstr = 'vgrid3'
          call length (wkstr,slen,sbgn,send)
          call ncaptc (ncoutid,verrid,'positions',ncchar,slen,
     *                 wkstr(sbgn:send),rcode)
          call ncapt (ncoutid,verrid,'valid_min',ncfloat,1,c0,rcode)
          call ncapt (ncoutid,verrid,'valid_max',ncfloat,1,c1,rcode)
          call ncapt (ncoutid,verrid,'_FillValue',ncfloat,1,spval,rcode)
        endif
c
c  Define tracer type variables.
c
        do 20 m=1,nt
          fldnam = tname(1,m)
          call length (fldnam,slen,sbgn,send)
          tobsid(m) = ncvdef (ncoutid,fldnam(sbgn:send),vartyp,4,tdim,
     *                        rcode)
          call length (tname(2,m),slen,sbgn,send)
          wkstr = 'assimilation, '//tname(2,m)(sbgn:send)
          call length (wkstr,slen,sbgn,send)
          call ncaptc (ncoutid,tobsid(m),'long_name',ncchar,slen,
     *                 wkstr(sbgn:send),rcode)
          call length (tname(3,m),slen,sbgn,send)
          call ncaptc (ncoutid,tobsid(m),'units',ncchar,slen,
     *                 tname(3,m)(sbgn:send),rcode)
          call length (tname(4,m),slen,sbgn,send)
          wkstr = tname(4,m)(sbgn:send)//', series'
          call length (wkstr,slen,sbgn,send)
          call ncaptc (ncoutid,tobsid(m),'field',ncchar,slen,
     *                 wkstr(sbgn:send),rcode)
          wkstr = 'tgrid3'
          call length (wkstr,slen,sbgn,send)
          call ncaptc (ncoutid,tobsid(m),'positions',ncchar,slen,
     *                 wkstr(sbgn:send),rcode)
          call ncapt (ncoutid,tobsid(m),'_FillValue',ncfloat,1,spval,
     &                rcode)
          if (lwrtoerr) then
            call length (fldnam,slen,sbgn,send)
            errnam = fldnam(sbgn:send)//'err'
            call length (errnam,slen,sbgn,send)
            terrid(m) = ncvdef (ncoutid,errnam(sbgn:send),vartyp,4,tdim,
     *                          rcode)
            call length (tname(2,m),slen,sbgn,send)
            wkstr = 'observation error, '//tname(2,m)(sbgn:send)
            call length (wkstr,slen,sbgn,send)
            call ncaptc (ncoutid,terrid(m),'long_name',ncchar,slen,
     *                   wkstr(sbgn:send),rcode)
            wkstr = 'normalized'
            call length (wkstr,slen,sbgn,send)
            call ncaptc (ncoutid,terrid(m),'units',ncchar,slen,
     *                   wkstr(sbgn:send),rcode)
            call length (tname(4,m),slen,sbgn,send)
            wkstr = 'error '//tname(4,m)(sbgn:send)//', series'
            call length (wkstr,slen,sbgn,send)
            call ncaptc (ncoutid,terrid(m),'field',ncchar,slen,
     *                   wkstr(sbgn:send),rcode)
            wkstr = 'tgrid3'
            call length (wkstr,slen,sbgn,send)
            call ncaptc (ncoutid,terrid(m),'positions',ncchar,slen,
     *                   wkstr(sbgn:send),rcode)
            call ncapt(ncoutid,terrid(m),'valid_min',ncfloat,1,c0,rcode)
            call ncapt(ncoutid,terrid(m),'valid_max',ncfloat,1,c1,rcode)
            call ncapt (ncoutid,terrid(m),'_FillValue',ncfloat,1,spval,
     &                  rcode)
          endif
  20    continue
c
c  Define transport streamfunction.
c
        pobsid = ncvdef (ncoutid,'pbar',vartyp,3,tdim(2),rcode)
        wkstr = 'assimilation, transport streamfunction'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,pobsid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'centimeter3 second-1'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,pobsid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'transport, scalar, series'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,pobsid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'tgrid2'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,pobsid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,pobsid,'_FillValue',ncfloat,1,spval,rcode)
        if (lwrtoerr) then
          perrid = ncvdef (ncoutid,'pbarerr',vartyp,3,tdim(2),rcode)
          wkstr = 'observation error, transport streamfunction'
          call length (wkstr,slen,sbgn,send)
          call ncaptc (ncoutid,perrid,'long_name',ncchar,slen,
     *                 wkstr(sbgn:send),rcode)
          wkstr = 'normalized'
          call length (wkstr,slen,sbgn,send)
          call ncaptc (ncoutid,perrid,'units',ncchar,slen,
     *                 wkstr(sbgn:send),rcode)
          wkstr = 'transport error, scalar, series'
          call length (wkstr,slen,sbgn,send)
          call ncaptc (ncoutid,perrid,'field',ncchar,slen,
     *                 wkstr(sbgn:send),rcode)
          wkstr = 'tgrid2'
          call length (wkstr,slen,sbgn,send)
          call ncaptc (ncoutid,perrid,'positions',ncchar,slen,
     *                 wkstr(sbgn:send),rcode)
          call ncapt (ncoutid,perrid,'_FillValue',ncfloat,1,spval,rcode)
        endif
c
c  Define minimum and maximum observation errors.
c
        if (lwrtoerr) then
          eminid = ncvdef (ncoutid,'oerrmin',vartyp,3,fdim,rcode)
          wkstr = 'minimum observation error'
          call length (wkstr,slen,sbgn,send)
          call ncaptc (ncoutid,eminid,'long_name',ncchar,slen,
     *                 wkstr(sbgn:send),rcode)
          wkstr = 'normalized'
          call length (wkstr,slen,sbgn,send)
          call ncaptc (ncoutid,eminid,'units',ncchar,slen,
     *                 wkstr(sbgn:send),rcode)
c
          emaxid = ncvdef (ncoutid,'oerrmax',vartyp,3,fdim,rcode)
          wkstr = 'maximum observation error'
          call length (wkstr,slen,sbgn,send)
          call ncaptc (ncoutid,emaxid,'long_name',ncchar,slen,
     *                 wkstr(sbgn:send),rcode)
          wkstr = 'normalized'
          call length (wkstr,slen,sbgn,send)
          call ncaptc (ncoutid,emaxid,'units',ncchar,slen,
     *                 wkstr(sbgn:send),rcode)
        endif
      endif
c
c-----------------------------------------------------------------------
c  Define diagnostic fields and their attributes.
c-----------------------------------------------------------------------
c
c  Not valid for the static initialization.
c
      if (job.ne.3) then
c
c     Ensure the diagnostic fields written at all times.
c
         vdim(5) = timedim
c
c     Total (internal plus external) velocity.
c
         vtotid = ncvdef (ncoutid,'vtot',vartyp,5,vdim,rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'variable '//char(34)//'vtot'//
     &                         char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
c
         wkstr = 'total velocity'
         call length (wkstr,slen,sbgn,send)
         call ncaptc (ncoutid,vtotid,'long_name',ncchar,slen,
     &                wkstr(sbgn:send),rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'attribute '//char(34)//'vtot:long_name'
     &                         //char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
c
         wkstr = 'zonal, meridional'
         call length (wkstr,slen,sbgn,send)
         call ncaptc (ncoutid,vtotid,'vector',ncchar,slen,
     &                wkstr(sbgn:send),rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'attribute '//char(34)//'vtot:vector'//
     &                         char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
c
         wkstr = 'centimeter second-1'
         call length (wkstr,slen,sbgn,send)
         call ncaptc (ncoutid,vtotid,'units',ncchar,slen,
     &                wkstr(sbgn:send),rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'attribute '//char(34)//'vtot:units'//
     &                         char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
c
         wkstr = 'total velocity, vector, series'
         call length (wkstr,slen,sbgn,send)
         call ncaptc (ncoutid,vtotid,'field',ncchar,slen,
     &                wkstr(sbgn:send),rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'attribute '//char(34)//'vtot:field'//
     &                         char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
c
         wkstr = 'vgrid3'
         call length (wkstr,slen,sbgn,send)
         call ncaptc (ncoutid,vtotid,'positions',ncchar,slen,
     &                wkstr(sbgn:send),rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'attribute '//char(34)//'vtot:positions'
     &                         //char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
c
         call ncapt (ncoutid,vtotid,'_FillValue',ncfloat,1,spval,rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'attribute '//char(34)//'vtot:_FillValue'
     &                         //char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
c
c     Barotropic velocity.
c
         vdim(2) = vecdim
         vbarid = ncvdef (ncoutid,'vbaro',vartyp,4,vdim(2),rcode)
         vdim(2) = levdim
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'variable '//char(34)//'vbaro'//
     &                         char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
c
         wkstr = 'barotropic velocity'
         call length (wkstr,slen,sbgn,send)
         call ncaptc (ncoutid,vbarid,'long_name',ncchar,slen,
     &                wkstr(sbgn:send),rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'attribute '//char(34)//'vbaro:long_name'
     &                         //char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
c
         wkstr = 'zonal, meridional'
         call length (wkstr,slen,sbgn,send)
         call ncaptc (ncoutid,vbarid,'vector',ncchar,slen,
     &                wkstr(sbgn:send),rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'attribute '//char(34)//'vbaro:vector'//
     &                         char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
c
         wkstr = 'centimeter second-1'
         call length (wkstr,slen,sbgn,send)
         call ncaptc (ncoutid,vbarid,'units',ncchar,slen,
     &                wkstr(sbgn:send),rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'attribute '//char(34)//'vbaro:units'//
     &                         char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
c
         wkstr = 'barotropic velocity, vector, series'
         call length (wkstr,slen,sbgn,send)
         call ncaptc (ncoutid,vbarid,'field',ncchar,slen,
     &                wkstr(sbgn:send),rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'attribute '//char(34)//'vbaro:field'//
     &                         char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
c
         wkstr = 'vgrid2'
         call length (wkstr,slen,sbgn,send)
         call ncaptc (ncoutid,vbarid,'positions',ncchar,slen,
     &                wkstr(sbgn:send),rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'attribute '//char(34)//'vbaro:positions'
     &                         //char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
c
         call ncapt (ncoutid,vbarid,'_FillValue',ncfloat,1,spval,rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'attribute '//char(34)//'vbaro:_Fill'
     &                         //'Value'//char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
c
c     Integrated geostrophic shear velocity.
c
         vgeoid = ncvdef (ncoutid,'vgeo',vartyp,5,vdim,rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'variable '//char(34)//'vgeo'//
     &                         char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
c
         wkstr = 'integrated geostrophic shear velocity'
         call length (wkstr,slen,sbgn,send)
         call ncaptc (ncoutid,vgeoid,'long_name',ncchar,slen,
     &                wkstr(sbgn:send),rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'attribute '//char(34)//'vgeo:long_name'
     &                         //char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
c
         wkstr = 'zonal, meridional'
         call length (wkstr,slen,sbgn,send)
         call ncaptc (ncoutid,vgeoid,'vector',ncchar,slen,
     &                wkstr(sbgn:send),rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'attribute '//char(34)//'vgeo:vector'//
     &                         char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
c
         wkstr = 'centimeter second-1'
         call length (wkstr,slen,sbgn,send)
         call ncaptc (ncoutid,vgeoid,'units',ncchar,slen,
     &                wkstr(sbgn:send),rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'attribute '//char(34)//'vgeo:units'//
     &                         char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
c
         wkstr = 'integrated shear, vector, series'
         call length (wkstr,slen,sbgn,send)
         call ncaptc (ncoutid,vgeoid,'field',ncchar,slen,
     &                wkstr(sbgn:send),rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'attribute '//char(34)//'vgeo:field'//
     &                         char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
c
         wkstr = 'vgrid3'
         call length (wkstr,slen,sbgn,send)
         call ncaptc (ncoutid,vgeoid,'positions',ncchar,slen,
     &                wkstr(sbgn:send),rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'attribute '//char(34)//'vgeo:positions'
     &                         //char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
c
         call ncapt (ncoutid,vgeoid,'_FillValue',ncfloat,1,spval,rcode)
         if (rcode.ne.0) then
            call length (fname(1),slen,sbgn,send)
            write (stdout,910) 'attribute '//char(34)//'vgeo:_Fill'
     &                         //'Value'//char(34),fname(1)(sbgn:send)
            call exitus ('DEFCDF')
         endif
c
c     Intermediate variables.
c
         if (idbug.ne.0) then
c
c        Geostrophic velocity at flat levels.
c
            vdim(2) = lvldim
            vfltid = ncvdef (ncoutid,'vflt',vartyp,5,vdim,rcode)
            vdim(2) = levdim
            if (rcode.ne.0) then
               call length (fname(1),slen,sbgn,send)
               write (stdout,910) 'variable '//char(34)//'vflt'//
     &                            char(34),fname(1)(sbgn:send)
               call exitus ('DEFCDF')
            endif
c
            wkstr = 'geostrophic velocity at flat levels'
            call length (wkstr,slen,sbgn,send)
            call ncaptc (ncoutid,vfltid,'long_name',ncchar,slen,
     &                   wkstr(sbgn:send),rcode)
            if (rcode.ne.0) then
               call length (fname(1),slen,sbgn,send)
               write (stdout,910) 'attribute '//char(34)//'vflt:long_'
     &                            //'name'//char(34),fname(1)(sbgn:send)
               call exitus ('DEFCDF')
            endif
c
            wkstr = 'zonal, meridional'
            call length (wkstr,slen,sbgn,send)
            call ncaptc (ncoutid,vfltid,'vector',ncchar,slen,
     &                   wkstr(sbgn:send),rcode)
            if (rcode.ne.0) then
               call length (fname(1),slen,sbgn,send)
               write (stdout,910) 'attribute '//char(34)//'vflt:vector'
     &                            //char(34),fname(1)(sbgn:send)
               call exitus ('DEFCDF')
            endif
c
            wkstr = 'centimeter second-1'
            call length (wkstr,slen,sbgn,send)
            call ncaptc (ncoutid,vfltid,'units',ncchar,slen,
     &                   wkstr(sbgn:send),rcode)
            if (rcode.ne.0) then
               call length (fname(1),slen,sbgn,send)
               write (stdout,910) 'attribute '//char(34)//'vflt:units'//
     &                            char(34),fname(1)(sbgn:send)
               call exitus ('DEFCDF')
            endif
c
            wkstr = 'geostrophic velocity, vector, series'
            call length (wkstr,slen,sbgn,send)
            call ncaptc (ncoutid,vfltid,'field',ncchar,slen,
     &                   wkstr(sbgn:send),rcode)
            if (rcode.ne.0) then
               call length (fname(1),slen,sbgn,send)
               write (stdout,910) 'attribute '//char(34)//'vflt:field'//
     &                            char(34),fname(1)(sbgn:send)
               call exitus ('DEFCDF')
            endif
c
            wkstr = 'vgridfl, product; zflat, product'
            call length (wkstr,slen,sbgn,send)
            call ncaptc (ncoutid,vfltid,'positions',ncchar,slen,
     &                   wkstr(sbgn:send),rcode)
            if (rcode.ne.0) then
               call length (fname(1),slen,sbgn,send)
               write (stdout,910) 'attribute '//char(34)//'vflt:positio'
     &                            //'ns'//char(34),fname(1)(sbgn:send)
               call exitus ('DEFCDF')
            endif
c
            call ncapt (ncoutid,vfltid,'_FillValue',ncfloat,1,spval,
     &                  rcode)
            if (rcode.ne.0) then
               call length (fname(1),slen,sbgn,send)
               write (stdout,910) 'attribute '//char(34)//'vflt:_Fill'
     &                         //'Value'//char(34),fname(1)(sbgn:send)
               call exitus ('DEFCDF')
            endif
c
c       First guess barotropic velocity.
c
            vdim(2) = vecdim
            vba1id = ncvdef (ncoutid,'vb1st',vartyp,4,vdim(2),rcode)
            vdim(2) = levdim
            if (rcode.ne.0) then
               call length (fname(1),slen,sbgn,send)
               write (stdout,910) 'variable '//char(34)//'vb1st'//
     &                            char(34),fname(1)(sbgn:send)
               call exitus ('DEFCDF')
            endif
c
            wkstr = 'first guess barotropic velocity'
            call length (wkstr,slen,sbgn,send)
            call ncaptc (ncoutid,vba1id,'long_name',ncchar,slen,
     &                   wkstr(sbgn:send),rcode)
            if (rcode.ne.0) then
               call length (fname(1),slen,sbgn,send)
               write (stdout,910) 'attribute '//char(34)//'vb1st:'//
     &                         'long_name'//char(34),fname(1)(sbgn:send)
               call exitus ('DEFCDF')
            endif
c
            wkstr = 'zonal, meridional'
            call length (wkstr,slen,sbgn,send)
            call ncaptc (ncoutid,vba1id,'vector',ncchar,slen,
     &                   wkstr(sbgn:send),rcode)
            if (rcode.ne.0) then
               call length (fname(1),slen,sbgn,send)
               write (stdout,910) 'attribute '//char(34)//'vb1st:vector'
     &                            //char(34),fname(1)(sbgn:send)
               call exitus ('DEFCDF')
            endif
c
            wkstr = 'centimeter second-1'
            call length (wkstr,slen,sbgn,send)
            call ncaptc (ncoutid,vba1id,'units',ncchar,slen,
     &                   wkstr(sbgn:send),rcode)
            if (rcode.ne.0) then
               call length (fname(1),slen,sbgn,send)
               write (stdout,910) 'attribute '//char(34)//'vb1st:units'
     &                            //char(34),fname(1)(sbgn:send)
               call exitus ('DEFCDF')
            endif
c
            wkstr = 'first barotropic velocity, vector, series'
            call length (wkstr,slen,sbgn,send)
            call ncaptc (ncoutid,vba1id,'field',ncchar,slen,
     &                   wkstr(sbgn:send),rcode)
            if (rcode.ne.0) then
               call length (fname(1),slen,sbgn,send)
               write (stdout,910) 'attribute '//char(34)//'vb1st:field'
     &                            //char(34),fname(1)(sbgn:send)
               call exitus ('DEFCDF')
            endif
c
            wkstr = 'vgrid2'
            call length (wkstr,slen,sbgn,send)
            call ncaptc (ncoutid,vba1id,'positions',ncchar,slen,
     &                   wkstr(sbgn:send),rcode)
            if (rcode.ne.0) then
               call length (fname(1),slen,sbgn,send)
               write (stdout,910) 'attribute '//char(34)//'vb1st:'//
     &                         'positions'//char(34),fname(1)(sbgn:send)
               call exitus ('DEFCDF')
            endif
c
            call ncapt (ncoutid,vba1id,'_FillValue',ncfloat,1,spval,
     &                  rcode)
            if (rcode.ne.0) then
               call length (fname(1),slen,sbgn,send)
               write (stdout,910) 'attribute '//char(34)//'vb1st:_Fill'
     &                         //'Value'//char(34),fname(1)(sbgn:send)
               call exitus ('DEFCDF')
            endif
c
c       Topography adjusted guess barotropic velocity.
c
            if (mod(iflag(5),4).gt.1) then
c
               vdim(2) = vecdim
               vba2id = ncvdef (ncoutid,'vb2nd',vartyp,4,vdim(2),rcode)
               vdim(2) = levdim
               if (rcode.ne.0) then
                  call length (fname(1),slen,sbgn,send)
                  write (stdout,910) 'variable '//char(34)//'vb2nd'//
     &                               char(34),fname(1)(sbgn:send)
                  call exitus ('DEFCDF')
               endif
c
               wkstr ='topography adjusted guess to barotropic velocity'
               call length (wkstr,slen,sbgn,send)
               call ncaptc (ncoutid,vba2id,'long_name',ncchar,slen,
     &                      wkstr(sbgn:send),rcode)
               if (rcode.ne.0) then
                  call length (fname(1),slen,sbgn,send)
                  write (stdout,910) 'attribute '//char(34)//'vb2nd:'//
     &                         'long_name'//char(34),fname(1)(sbgn:send)
                  call exitus ('DEFCDF')
               endif
c
               wkstr = 'zonal, meridional'
               call length (wkstr,slen,sbgn,send)
               call ncaptc (ncoutid,vba2id,'vector',ncchar,slen,
     &                      wkstr(sbgn:send),rcode)
               if (rcode.ne.0) then
                  call length (fname(1),slen,sbgn,send)
                  write (stdout,910) 'attribute '//char(34)//'vb2nd:'//
     &                            'vector'//char(34),fname(1)(sbgn:send)
                  call exitus ('DEFCDF')
               endif
c
               wkstr = 'centimeter second-1'
               call length (wkstr,slen,sbgn,send)
               call ncaptc (ncoutid,vba2id,'units',ncchar,slen,
     &                      wkstr(sbgn:send),rcode)
               if (rcode.ne.0) then
                  call length (fname(1),slen,sbgn,send)
                  write (stdout,910) 'attribute '//char(34)//'vb2nd:'//
     &                             'units'//char(34),fname(1)(sbgn:send)
                  call exitus ('DEFCDF')
               endif
c
               wkstr = 'second barotropic velocity, vector, series'
               call length (wkstr,slen,sbgn,send)
               call ncaptc (ncoutid,vba2id,'field',ncchar,slen,
     &                     wkstr(sbgn:send),rcode)
               if (rcode.ne.0) then
                  call length (fname(1),slen,sbgn,send)
                  write (stdout,910) 'attribute '//char(34)//'vb2nd:fie'
     &                              //'ld'//char(34),fname(1)(sbgn:send)
                  call exitus ('DEFCDF')
               endif
c
               wkstr = 'vgrid2'
               call length (wkstr,slen,sbgn,send)
               call ncaptc (ncoutid,vba2id,'positions',ncchar,slen,
     &                      wkstr(sbgn:send),rcode)
               if (rcode.ne.0) then
                  call length (fname(1),slen,sbgn,send)
                  write (stdout,910) 'attribute '//char(34)//'vb2nd:'//
     &                         'positions'//char(34),fname(1)(sbgn:send)
                  call exitus ('DEFCDF')
               endif
c
               call ncapt (ncoutid,vba2id,'_FillValue',ncfloat,1,spval,
     &                  rcode)
               if (rcode.ne.0) then
                  call length (fname(1),slen,sbgn,send)
                  write (stdout,910) 'attribute '//char(34)//'vb2nd:_Fi'
     &                         //'llValue'//char(34),fname(1)(sbgn:send)
                  call exitus ('DEFCDF')
               endif
c
            endif
c
         endif
c
      endif
c
c=======================================================================
c  Leave definition mode.  =============================================
c=======================================================================
c
      call ncendf(ncoutid,rcode)
      ncoutfl=2
c
c=======================================================================
c  Write out titles and scalar variables.
c=======================================================================
c
c  Write out titles.
c
      chid=ncvid(ncoutid,'runic',rcode)
      call ncvptc(ncoutid,chid,1,lrunic,runic(rbgn:rend),lrunic,rcode)
      if(rcode.ne.0) then
        write(stdout,920) 'runic'
        call exitus('DEFCDF')
      endif
      write(titleic,30) model(mbgn:mend),date_str(dbgn:dend)
  30  format('HOPS ',a,' file created on ',a)
      chid=ncvid(ncoutid,'titleic',rcode)
      call ncvptc(ncoutid,chid,1,80,titleic,80,rcode)
      if(rcode.ne.0) then
        write(stdout,920) 'titleic'
        call exitus('DEFCDF')
      endif
c
c  Write out PE model dimensions.
c
      varid=ncvid(ncoutid,'imt',rcode)
      call ncvpt1(ncoutid,varid,1,im,rcode)
      if(rcode.ne.0) then
        write(stdout,920) 'imt'
        call exitus('DEFCDF')
      endif
      varid=ncvid(ncoutid,'jmt',rcode)
      call ncvpt1(ncoutid,varid,1,jm,rcode)
      if(rcode.ne.0) then
        write(stdout,920) 'jmt'
        call exitus('DEFCDF')
      endif
      varid=ncvid(ncoutid,'km',rcode)
      call ncvpt1(ncoutid,varid,1,km,rcode)
      if(rcode.ne.0) then
        write(stdout,920) 'km'
        call exitus('DEFCDF')
      endif
      varid=ncvid(ncoutid,'nt',rcode)
      call ncvpt1(ncoutid,varid,1,nt,rcode)
      if(rcode.ne.0) then
        write(stdout,920) 'nt'
        call exitus('DEFCDF')
      endif
      if(job.ne.1) then
        varid=ncvid(ncoutid,'bpts',rcode)
        call ncvpt1(ncoutid,varid,1,max(im,jm),rcode)
        if(rcode.ne.0) then
          write(stdout,920) 'bpts'
          call exitus('DEFCDF')
        endif
        varid=ncvid(ncoutid,'boundary',rcode)
        call ncvpt1(ncoutid,varid,1,4,rcode)
        if(rcode.ne.0) then
          write(stdout,920) 'boundary'
          call exitus('DEFCDF')
        endif
      endif
      if(icoast.ne.0) then
        varid=ncvid(ncoutid,'ncseg',rcode)
        call ncvpt1(ncoutid,varid,1,nseg,rcode)
        if(rcode.ne.0) then
          write(stdout,920) 'ncseg'
          call exitus('DEFCDF')
        endif
        varid=ncvid(ncoutid,'lcseg',rcode)
        call ncvpt1(ncoutid,varid,1,lsegmx,rcode)
        if(rcode.ne.0) then
          write(stdout,920) 'lcseg'
          call exitus('DEFCDF')
        endif
        if(nisle.gt.0) then
          varid=ncvid(ncoutid,'nisle',rcode)
          call ncvpt1(ncoutid,varid,1,nisle,rcode)
          if(rcode.ne.0) then
            write(stdout,920) 'nisle'
            call exitus('DEFCDF')
          endif
        endif
      endif
c
c  Write out model domain parameters.
c
      varid=ncvid(ncoutid,'coord',rcode)
      call ncvpt1(ncoutid,varid,1,coord,rcode)
      if(rcode.ne.0) then
        write(stdout,920) 'coord'
        call exitus('DEFCDF')
      endif
      varid=ncvid(ncoutid,'rlngd',rcode)
      call ncvpt1(ncoutid,varid,1,rlng0,rcode)
      if(rcode.ne.0) then
        write(stdout,920) 'rlngd'
        call exitus('DEFCDF')
      endif
      varid=ncvid(ncoutid,'rlatd',rcode)
      call ncvpt1(ncoutid,varid,1,rlat0,rcode)
      if(rcode.ne.0) then
        write(stdout,920) 'rlatd'
        call exitus('DEFCDF')
      endif
      varid=ncvid(ncoutid,'delx',rcode)
      call ncvpt1(ncoutid,varid,1,delx,rcode)
      if(rcode.ne.0) then
        write(stdout,920) 'delx'
        call exitus('DEFCDF')
      endif
      varid=ncvid(ncoutid,'dely',rcode)
      call ncvpt1(ncoutid,varid,1,dely,rcode)
      if(rcode.ne.0) then
        write(stdout,920) 'dely'
        call exitus('DEFCDF')
      endif
      varid=ncvid(ncoutid,'thetad',rcode)
      call ncvpt1(ncoutid,varid,1,thetad,rcode)
      if(rcode.ne.0) then
        write(stdout,920) 'thetad'
        call exitus('DEFCDF')
      endif
      varid=ncvid(ncoutid,'gridx',rcode)
      call ncvpt1(ncoutid,varid,1,dx,rcode)
      if(rcode.ne.0) then
        write(stdout,920) 'gridx'
        call exitus('DEFCDF')
      endif
      varid=ncvid(ncoutid,'gridy',rcode)
      call ncvpt1(ncoutid,varid,1,dy,rcode)
      if(rcode.ne.0) then
        write(stdout,920) 'gridy'
        call exitus('DEFCDF')
      endif
c
c  Write out double vertical coordinate transformation parameters.
c
      if(dblsigma.eq.1) then
        varid=ncvid(ncoutid,'zc1',rcode)
        call ncvpt1(ncoutid,varid,1,zc1,rcode)
        if(rcode.ne.0) then
          write(stdout,920) 'zc1'
          call exitus('DEFCDF')
        endif
        varid=ncvid(ncoutid,'zc2',rcode)
        call ncvpt1(ncoutid,varid,1,zc2,rcode)
        if(rcode.ne.0) then
          write(stdout,920) 'zc2'
          call exitus('DEFCDF')
        endif
        varid=ncvid(ncoutid,'zref',rcode)
        call ncvpt1(ncoutid,varid,1,zref,rcode)
        if(rcode.ne.0) then
          write(stdout,920) 'zref'
          call exitus('DEFCDF')
        endif
        varid=ncvid(ncoutid,'zslope',rcode)
        call ncvpt1(ncoutid,varid,1,zslope,rcode)
        if(rcode.ne.0) then
          write(stdout,920) 'zslope'
          call exitus('DEFCDF')
        endif
      endif
c
c=======================================================================
c  Write out flags and mean T-S arrays.
c=======================================================================
c
c  Switches.
c
      varid=ncvid(ncoutid,'iflag',rcode)
      call ncvpt(ncoutid,varid,1,10,iflag,rcode)
      if(rcode.ne.0) then
        write(stdout,920) 'iflag'
        call exitus('DEFCDF')
      endif
c
c  Velocity computation parameters.
c
      varid = ncvid (ncoutid,'its2psi',rcode)
      if (rcode.ne.0) then
        write(stdout,930) 'its2psi'
        call exitus('DEFCDF')
      endif
      call ncvpt1 (ncoutid,varid,1,its2psi,rcode)
      if (rcode.ne.0) then
        write(stdout,920) 'its2psi'
        call exitus('DEFCDF')
      endif
c
c  External mode computation parameters.
c
      if ((iflag(5)/4).eq.1) then
         varid = ncvid (ncoutid,'def_depth',rcode)
         if (rcode.ne.0) then
           write(stdout,930) 'def_depth'
           call exitus('DEFCDF')
         endif
         call ncvpt1 (ncoutid,varid,1,def_depth*cm2m,rcode)
         if (rcode.ne.0) then
           write(stdout,920) 'def_depth'
           call exitus('DEFCDF')
         endif
      end if
c
      if (mod(iflag(5),4).gt.1) then
         varid = ncvid (ncoutid,'wbot_depth',rcode)
         if (rcode.ne.0) then
           write(stdout,930) 'wbot_depth'
           call exitus('DEFCDF')
         endif
         call ncvpt1 (ncoutid,varid,1,wbot_depth*cm2m,rcode)
         if (rcode.ne.0) then
           write(stdout,920) 'wbot_depth'
           call exitus('DEFCDF')
         endif
      end if
c
c  Write out mean TS profile.
c
      varid=ncvid(ncoutid,'zclima',rcode)
      call ncvpt(ncoutid,varid,1,nprof,zm,rcode)
      if(rcode.ne.0) then
        write(stdout,920) 'zclima'
        call exitus('DEFCDF')
      endif
      varid=ncvid(ncoutid,'tclima',rcode)
      call ncvpt(ncoutid,varid,1,nprof,tm,rcode)
      if(rcode.ne.0) then
        write(stdout,920) 'tclima'
        call exitus('DEFCDF')
      endif
      varid=ncvid(ncoutid,'sclima',rcode)
      call ncvpt(ncoutid,varid,1,nprof,sm,rcode)
      if(rcode.ne.0) then
        write(stdout,920) 'sclima'
        call exitus('DEFCDF')
      endif
c
c=======================================================================
c  Write geometry variables into netCDF file.
c=======================================================================
c
c  Write depths and thicknesses for the reference flat levels.
c
      varid=ncvid(ncoutid,'refz',rcode)
      call ncvpt(ncoutid,varid,1,km,zpe,rcode)
      if(rcode.ne.0) then
        write(stdout,920) 'refz'
        call exitus('DEFCDF')
      endif
      varid=ncvid(ncoutid,'hz',rcode)
      call ncvpt(ncoutid,varid,1,km,hz,rcode)
      if(rcode.ne.0) then
        write(stdout,920) 'hz'
        call exitus('DEFCDF')
      endif
c
c-----------------------------------------------------------------------
c  Set longitude/latitude at the tracers and velocity points.
c-----------------------------------------------------------------------
c
c  Read in (x,y) positions at tracer points from GRIDS file.
c
      start(1)=xindx
      count(1)=1
      start(2)=1
      count(2)=im
      start(3)=1
      count(3)=jm
      grdt2id=ncvid(ncgrdid,'tgrid2',rcode)
      if (rcode.ne.0) then
        write(stdout,930) 'tgrid2 in GRIDS file.'
        call exitus('DEFCDF')
      end if
      call ncvgt(ncgrdid,grdt2id,start,count,lon,rcode)
      if (rcode.ne.0) then
        write(stdout,940) 'GRIDS - tgrid2 x-axis'
        call exitus('DEFCDF')
      endif
      start(1)=yindx
      count(1)=1
      call ncvgt(ncgrdid,grdt2id,start,count,lat,rcode)
      if (rcode.ne.0) then
        write(stdout,940) 'GRIDS - tgrid2 y-axis'
        call exitus('DEFCDF')
      endif
c
c  Write out (x,y) positions at the tracer points for array TGRID2.
c
      start(1)=xindx
      count(1)=1
      start(2)=1
      count(2)=im
      start(3)=1
      count(3)=jm
      call ncvpt(ncoutid,tg2did,start,count,lon,rcode)
      if(rcode.ne.0) then
        write(stdout,920) 'tgrid2 x-axis'
        call exitus('DEFCDF')
      endif
      start(1)=yindx
      count(1)=1
      call ncvpt(ncoutid,tg2did,start,count,lat,rcode)
      if(rcode.ne.0) then
        write(stdout,920) 'tgrid2 y-axis'
        call exitus('DEFCDF')
      endif
c
c  Write out (x,y) positions at the tracer points for array TGRID3.
c
      start(3)=1
      count(3)=im
      start(4)=1
      count(4)=jm
      do 40 k=1,km
        start(1)=xindx
        count(1)=1
        start(2)=k
        count(2)=1
        call ncvpt(ncoutid,tg3did,start,count,lon,rcode)
        if(rcode.ne.0) then
          write(stdout,950) 'tgrid3 x-axis',k
          call exitus('DEFCDF')
        endif
        start(1)=yindx
        count(1)=1
        call ncvpt(ncoutid,tg3did,start,count,lat,rcode)
        if(rcode.ne.0) then
          write(stdout,950) 'tgrid3 x-axis',k
          call exitus('DEFCDF')
        endif
  40  continue
c
c  Write out (x,y) positions at the tracer points for boundary array
c  TBGRID2.
c
      if (job.eq.0) then
        istr=1
        start(1)=xindx
        count(1)=1
        start(2)=1
        count(2)=im
        start(3)=south
        count(3)=1
        call ncvpt(ncoutid,tg2bid,start,count,lon(istr),rcode)
        if(rcode.ne.0) then
          write(stdout,960) 'tbgrid2 x-axis',south
          call exitus('DEFCDF')
        endif
        start(1)=yindx
        count(1)=1
        call ncvpt(ncoutid,tg2bid,start,count,lat(istr),rcode)
        if(rcode.ne.0) then
          write(stdout,960) 'tbgrid2 y-axis',south
          call exitus('DEFCDF')
        endif
        istr=1+(jm-1)*im
        start(1)=xindx
        count(1)=1
        start(3)=north
        count(3)=1
        call ncvpt(ncoutid,tg2bid,start,count,lon(istr),rcode)
        if(rcode.ne.0) then
          write(stdout,960) 'tbgrid2 x-axis',north
          call exitus('DEFCDF')
        endif
        start(1)=yindx
        count(1)=1
        call ncvpt(ncoutid,tg2bid,start,count,lat(istr),rcode)
        if(rcode.ne.0) then
          write(stdout,960) 'tbgrid2 y-axis',north
          call exitus('DEFCDF')
        endif
        do 50 j=1,jm
          ip=1+(j-1)*im
          blon(j)=lon(ip)
          blat(j)=lat(ip)
  50    continue
        start(1)=xindx
        count(1)=1
        start(2)=1
        count(2)=jm
        start(3)=west
        count(3)=1
        call ncvpt(ncoutid,tg2bid,start,count,blon,rcode)
        if(rcode.ne.0) then
          write(stdout,960) 'tbgrid2 x-axis',west
          call exitus('DEFCDF')
        endif
        start(1)=yindx
        count(1)=1
        call ncvpt(ncoutid,tg2bid,start,count,blat,rcode)
        if(rcode.ne.0) then
          write(stdout,960) 'tbgrid2 y-axis',west
          call exitus('DEFCDF')
        endif
        do 60 j=1,jm
          ip=im+(j-1)*im
          blon(j)=lon(ip)
          blat(j)=lat(ip)
  60    continue
        start(1)=xindx
        count(1)=1
        start(3)=east
        count(3)=1
        call ncvpt(ncoutid,tg2bid,start,count,blon,rcode)
        if(rcode.ne.0) then
          write(stdout,960) 'tbgrid2 x-axis',east
          call exitus('DEFCDF')
        endif
        start(1)=yindx
        count(1)=1
        call ncvpt(ncoutid,tg2bid,start,count,blat,rcode)
        if(rcode.ne.0) then
          write(stdout,960) 'tbgrid2 y-axis',east
          call exitus('DEFCDF')
        endif
      endif
c
c  Write out (x,y) positions at the tracer points for vorticity
c  boundary array QBGRID2.
c
      if (job.eq.0) then
        istr=im+1
        start(1)=xindx
        count(1)=1
        start(2)=1
        count(2)=im
        start(3)=south
        count(3)=1
        call ncvpt(ncoutid,qg2bid,start,count,lon(istr),rcode)
        if(rcode.ne.0) then
          write(stdout,960) 'qbgrid2 x-axis',south
          call exitus('DEFCDF')
        endif
        start(1)=yindx
        count(1)=1
        call ncvpt(ncoutid,qg2bid,start,count,lat(istr),rcode)
        if(rcode.ne.0) then
          write(stdout,960) 'qbgrid2 y-axis',south
          call exitus('DEFCDF')
        endif
        istr=1+((jm-1)-1)*im
        start(1)=xindx
        count(1)=1
        start(3)=north
        count(3)=1
        call ncvpt(ncoutid,qg2bid,start,count,lon(istr),rcode)
        if(rcode.ne.0) then
          write(stdout,960) 'qbgrid2 x-axis',north
          call exitus('DEFCDF')
        endif
        start(1)=yindx
        count(1)=1
        call ncvpt(ncoutid,qg2bid,start,count,lat(istr),rcode)
        if(rcode.ne.0) then
          write(stdout,960) 'qbgrid2 y-axis',north
          call exitus('DEFCDF')
        endif
        do 70 j=1,jm
          ip=2+(j-1)*im
          blon(j)=lon(ip)
          blat(j)=lat(ip)
  70    continue
        start(1)=xindx
        count(1)=1
        start(2)=1
        count(2)=jm
        start(3)=west
        count(3)=1
        call ncvpt(ncoutid,qg2bid,start,count,blon,rcode)
        if(rcode.ne.0) then
          write(stdout,960) 'qbgrid2 x-axis',west
          call exitus('DEFCDF')
        endif
        start(1)=yindx
        count(1)=1
        call ncvpt(ncoutid,qg2bid,start,count,blat,rcode)
        if(rcode.ne.0) then
          write(stdout,960) 'qbgrid2 y-axis',west
          call exitus('DEFCDF')
        endif
        do 80 j=1,jm
          ip=(im-1)+(j-1)*im
          blon(j)=lon(ip)
          blat(j)=lat(ip)
  80    continue
        start(1)=xindx
        count(1)=1
        start(3)=east
        count(3)=1
        call ncvpt(ncoutid,qg2bid,start,count,blon,rcode)
        if(rcode.ne.0) then
          write(stdout,960) 'qbgrid2 x-axis',east
          call exitus('DEFCDF')
        endif
        start(1)=yindx
        count(1)=1
        call ncvpt(ncoutid,qg2bid,start,count,blat,rcode)
        if(rcode.ne.0) then
          write(stdout,960) 'qbgrid2 y-axis',east
          call exitus('DEFCDF')
        endif
      endif
c
c  Write out (x,y) positions at the tracer points for boundary array
c  TBGRID3.
c
      if (job.eq.0) then
        do 110 k=1,km
          istr=1
          start(1)=xindx
          count(1)=1
          start(2)=k
          count(2)=1
          start(3)=1
          count(3)=im
          start(4)=south
          count(4)=1
          call ncvpt(ncoutid,tg3bid,start,count,lon(istr),rcode)
          if(rcode.ne.0) then
            write(stdout,970) 'tbgrid3 x-axis',k,south
            call exitus('DEFCDF')
          endif
          start(1)=yindx
          count(1)=1
          call ncvpt(ncoutid,tg3bid,start,count,lat(istr),rcode)
          if(rcode.ne.0) then
            write(stdout,970) 'tbgrid3 y-axis',k,south
            call exitus('DEFCDF')
          endif
          istr=1+(jm-1)*im
          start(1)=xindx
          count(1)=1
          start(4)=north
          count(4)=1
          call ncvpt(ncoutid,tg3bid,start,count,lon(istr),rcode)
          if(rcode.ne.0) then
            write(stdout,970) 'tbgrid3 x-axis',k,north
            call exitus('DEFCDF')
          endif
          start(1)=yindx
          count(1)=1
          call ncvpt(ncoutid,tg3bid,start,count,lat(istr),rcode)
          if(rcode.ne.0) then
            write(stdout,970) 'tbgrid3 y-axis',k,north
            call exitus('DEFCDF')
          endif
          do 90 j=1,jm
            ip=1+(j-1)*im
            blon(j)=lon(ip)
            blat(j)=lat(ip)
  90      continue
          start(1)=xindx
          count(1)=1
          start(3)=1
          count(3)=jm
          start(4)=west
          count(4)=1
          call ncvpt(ncoutid,tg3bid,start,count,blon,rcode)
          if(rcode.ne.0) then
            write(stdout,970) 'tbgrid3 x-axis',k,west
            call exitus('DEFCDF')
          endif
          start(1)=yindx
          count(1)=1
          call ncvpt(ncoutid,tg3bid,start,count,blat,rcode)
          if(rcode.ne.0) then
            write(stdout,970) 'tbgrid3 y-axis',k,west
            call exitus('DEFCDF')
          endif
          do 100 j=1,jm
            ip=im+(j-1)*im
            blon(j)=lon(ip)
            blat(j)=lat(ip)
 100      continue
          start(1)=xindx
          count(1)=1
          start(4)=east
          count(4)=1
          call ncvpt(ncoutid,tg3bid,start,count,blon,rcode)
          if(rcode.ne.0) then
            write(stdout,970) 'tbgrid3 x-axis',k,east
            call exitus('DEFCDF')
          endif
          start(1)=yindx
          count(1)=1
          call ncvpt(ncoutid,tg3bid,start,count,blat,rcode)
          if(rcode.ne.0) then
            write(stdout,970) 'tbgrid3 y-axis',k,east
            call exitus('DEFCDF')
          endif
 110    continue
      endif
c
c  Read in (x,y) positions at velocity points from GRIDS file.
c
      start(1)=xindx
      count(1)=1
      start(2)=1
      count(2)=im
      start(3)=1
      count(3)=jm
      grdv2id=ncvid(ncgrdid,'vgrid2',rcode)
      if (rcode.ne.0) then
        write(stdout,930) 'vgrid2 in GRIDS file.'
        call exitus('DEFCDF')
      end if
      call ncvgt(ncgrdid,grdv2id,start,count,lon,rcode)
      if (rcode.ne.0) then
        write(stdout,940) 'GRIDS - vgrid2 x-axis'
        call exitus('DEFCDF')
      endif
      start(1)=yindx
      count(1)=1
      call ncvgt(ncgrdid,grdv2id,start,count,lat,rcode)
      if (rcode.ne.0) then
        write(stdout,940) 'GRIDS - vgrid2 y-axis'
        call exitus('DEFCDF')
      endif
c
c  Write out (x,y) positions at the velocity points for array VGRID2.
c
      start(1)=xindx
      count(1)=1
      start(2)=1
      count(2)=im
      start(3)=1
      count(3)=jm
      call ncvpt(ncoutid,vg2did,start,count,lon,rcode)
      if(rcode.ne.0) then
        write(stdout,920) 'vgrid2 x-axis'
        call exitus('DEFCDF')
      endif
      start(1)=yindx
      count(1)=1
      call ncvpt(ncoutid,vg2did,start,count,lat,rcode)
      if(rcode.ne.0) then
        write(stdout,920) 'vgrid2 y-axis'
        call exitus('DEFCDF')
      endif
c
c  Write out (x,y,z) positions at the velocity points for arrays VGRIDFL &
c  ZFLAT.
c
      if ((idbug.ne.0).and.(job.ne.3)) then
c
c    Horizontal components
c
         start(1)=xindx
         count(1)=1
         start(2)=1
         count(2)=im
         start(3)=1
         count(3)=jm
         call ncvpt(ncoutid,vgflid,start,count,lon,rcode)
         if(rcode.ne.0) then
           write(stdout,920) 'vgridfl x-axis'
           call exitus('DEFCDF')
         endif
         start(1)=yindx
         count(1)=1
         call ncvpt(ncoutid,vgflid,start,count,lat,rcode)
         if(rcode.ne.0) then
           write(stdout,920) 'vgridfl y-axis'
           call exitus('DEFCDF')
         endif
c
c    Vertical component
c
         start(1)=zindx
         count(1)=1
         start(2)=1
         count(2)=kfld
         call ncvpt(ncoutid,zfltid,start,count,zfld,rcode)
         if(rcode.ne.0) then
           write(stdout,920) 'zflat z-axis'
           call exitus('DEFCDF')
         endif
c
      endif
c
c  Write out (x,y) positions at the velocity points for array VGRID3.
c
      start(3)=1
      count(3)=im
      start(4)=1
      count(4)=jm
      do 120 k=1,km
        start(1)=xindx
        count(1)=1
        start(2)=k
        count(2)=1
        call ncvpt(ncoutid,vg3did,start,count,lon,rcode)
        if(rcode.ne.0) then
          write(stdout,950) 'vgrid3 x-axis',k
          call exitus('DEFCDF')
        endif
        start(1)=yindx
        count(1)=1
        call ncvpt(ncoutid,vg3did,start,count,lat,rcode)
        if(rcode.ne.0) then
          write(stdout,950) 'vgrid3 x-axis',k
          call exitus('DEFCDF')
        endif
 120  continue
c
c  Write out (x,y) positions at the velocity points for boundary array
c  VBGRID3.
c
      if (job.eq.0) then
        do 150 k=1,km
          istr=1
          start(1)=xindx
          count(1)=1
          start(2)=k
          count(2)=1
          start(3)=1
          count(3)=im
          start(4)=south
          count(4)=1
          call ncvpt(ncoutid,vg3bid,start,count,lon(istr),rcode)
          if(rcode.ne.0) then
            write(stdout,970) 'vbgrid3 x-axis',k,south
            call exitus('DEFCDF')
          endif
          start(1)=yindx
          count(1)=1
          call ncvpt(ncoutid,vg3bid,start,count,lat(istr),rcode)
          if(rcode.ne.0) then
            write(stdout,970) 'vbgrid3 y-axis',k,south
            call exitus('DEFCDF')
          endif
          istr=1+((jm-1)-1)*im
          start(1)=xindx
          count(1)=1
          start(4)=north
          count(4)=1
          call ncvpt(ncoutid,vg3bid,start,count,lon(istr),rcode)
          if(rcode.ne.0) then
            write(stdout,970) 'vbgrid3 x-axis',k,north
            call exitus('DEFCDF')
          endif
          start(1)=yindx
          count(1)=1
          call ncvpt(ncoutid,vg3bid,start,count,lat(istr),rcode)
          if(rcode.ne.0) then
            write(stdout,970) 'vbgrid3 y-axis',k,north
            call exitus('DEFCDF')
          endif
          do 130 j=1,jm
            ip=1+(j-1)*im
            blon(j)=lon(ip)
            blat(j)=lat(ip)
 130      continue
          start(1)=xindx
          count(1)=1
          start(3)=1
          count(3)=jm
          start(4)=west
          count(4)=1
          call ncvpt(ncoutid,vg3bid,start,count,blon,rcode)
          if(rcode.ne.0) then
            write(stdout,970) 'vbgrid3 x-axis',k,west
            call exitus('DEFCDF')
          endif
          start(1)=yindx
          count(1)=1
          call ncvpt(ncoutid,vg3bid,start,count,blat,rcode)
          if(rcode.ne.0) then
            write(stdout,970) 'vbgrid3 y-axis',k,west
            call exitus('DEFCDF')
          endif
          do 140 j=1,jm
            ip=(im-1)+(j-1)*im
            blon(j)=lon(ip)
            blat(j)=lat(ip)
 140      continue
          start(1)=xindx
          count(1)=1
          start(4)=east
          count(4)=1
          call ncvpt(ncoutid,vg3bid,start,count,blon,rcode)
          if(rcode.ne.0) then
            write(stdout,970) 'vbgrid3 x-axis',k,east
            call exitus('DEFCDF')
          endif
          start(1)=yindx
          count(1)=1
          call ncvpt(ncoutid,vg3bid,start,count,blat,rcode)
          if(rcode.ne.0) then
            write(stdout,970) 'vbgrid3 y-axis',k,east
            call exitus('DEFCDF')
          endif
 150    continue
      endif
c
c-----------------------------------------------------------------------
c  Write out bathymetry (meters) at the tracer points.
c-----------------------------------------------------------------------
c
      start(1)=1
      count(1)=im
      start(2)=1
      count(2)=jm
      do 160 j=1,jm
      do 160 i=1,im
        ip=i+(j-1)*im
#if defined reset_h & defined gridold
        f(ip)=-cm2m*abs(hsave(ip))
#else
        f(ip)=-cm2m*abs(h(ip))
#endif
 160  continue
      call ncvpt(ncoutid,tbthid,start,count,f,rcode)
      if(rcode.ne.0) then
        write(stdout,920) 'tbath'
        call exitus('DEFCDF')
      endif
c
#ifndef gridold
c-----------------------------------------------------------------------
c  Write out bathymetry (meters) at the velocity points.
c-----------------------------------------------------------------------
c
      start(1)=1
      count(1)=im
      start(2)=1
      count(2)=jm
      do 170 j=1,jm
      do 170 i=1,im
        ip=i+(j-1)*im
        f(ip)=-cm2m*abs(hv(ip))
 170  continue
      call ncvpt(ncoutid,vbthid,start,count,f,rcode)
      if(rcode.ne.0) then
        write(stdout,920) 'vbath'
        call exitus('DEFCDF')
      endif
c
c-----------------------------------------------------------------------
c  Write out coordinate interface (meters) at the tracer points.
c-----------------------------------------------------------------------
c
      if (dblsigma.eq.1) then
         start(1)=1
         count(1)=im
         start(2)=1
         count(2)=jm
         do 180 j=1,jm
         do 180 i=1,im
            ip=i+(j-1)*im
            f(ip)=-cm2m*abs(tinter(ip))
 180     continue
         call ncvpt(ncoutid,tifcid,start,count,f,rcode)
         if (rcode.ne.0) then
            write(stdout,920) 'interface'
            call exitus('DEFCDF')
         endif
      endif
c
c-----------------------------------------------------------------------
c  Write out coordinate interface (meters) at the velocity points.
c-----------------------------------------------------------------------
c
      if (dblsigma.eq.1) then
         start(1)=1
         count(1)=im
         start(2)=1
         count(2)=jm
         do 190 j=1,jm
         do 190 i=1,im
            ip=i+(j-1)*im
            f(ip)=-cm2m*abs(vinter(ip))
 190     continue
         call ncvpt(ncoutid,vifcid,start,count,f,rcode)
         if (rcode.ne.0) then
            write(stdout,920) 'viface'
            call exitus('DEFCDF')
         endif
      endif
c
#endif
c-----------------------------------------------------------------------
c  Write out coastal segments and land/sea masks.  Write out island
c  box(es).
c-----------------------------------------------------------------------
c
      if(icoast.ne.0) then
        start(1)=1
        count(1)=nseg
        varid=ncvid(ncoutid,'lencoast',rcode)
        call ncvpt(ncoutid,varid,start,count,lenseg,rcode)
        if(rcode.ne.0) then
          write(stdout,920) 'lencoast'
          call exitus('DEFCDF')
        endif
        do 200 n=1,nseg
          start(1)=1
          count(1)=lenseg(n)
          start(2)=n
          count(2)=1
          call ncvpt(ncoutid,csegxid,start,count,cstsegx(1,n),rcode)
          if(rcode.ne.0) then
            write(stdout,980) 'icoast',n
            call exitus('DEFCDF')
          endif
          call ncvpt(ncoutid,csegyid,start,count,cstsegy(1,n),rcode)
          if(rcode.ne.0) then
            write(stdout,980) 'jcoast',n
            call exitus('DEFCDF')
          endif
 200    continue
        start(1)=1
        count(1)=im
        start(2)=1
        count(2)=jm
        call ncvpt(ncoutid,landtid,start,count,landt,rcode)
        if(rcode.ne.0) then
          write(stdout,920) 'landt'
          call exitus('DEFCDF')
        endif
        call ncvpt(ncoutid,landvid,start,count,landv,rcode)
        if(rcode.ne.0) then
          write(stdout,920) 'landv'
          call exitus('DEFCDF')
        endif
        if(nisle.gt.0) then
          start(1)=1
          count(1)=nisle
          call ncvpt(ncoutid,isisid,start,count,isis,rcode)
          if(rcode.ne.0) then
            write(stdout,920) 'isis'
            call exitus('DEFCDF')
          endif
          call ncvpt(ncoutid,ieisid,start,count,ieis,rcode)
          if(rcode.ne.0) then
            write(stdout,920) 'ieis'
            call exitus('DEFCDF')
          endif
          call ncvpt(ncoutid,jsisid,start,count,jsis,rcode)
          if(rcode.ne.0) then
            write(stdout,920) 'jsis'
            call exitus('DEFCDF')
          endif
          call ncvpt(ncoutid,jeisid,start,count,jeis,rcode)
          if(rcode.ne.0) then
            write(stdout,920) 'jeis'
            call exitus('DEFCDF')
          endif
        endif
      endif
c
c-----------------------------------------------------------------------
c  Write out depths (meters) at the center of the tracer and velocity
c  boxes into positional arrays.
c-----------------------------------------------------------------------
c
      start(1)=zindx
      count(1)=1
      do 270 k=1,km
        start(2)=k
        count(2)=1
c
c  Write (z) positions for 3D fields tracer points.
c
        start(3)=1
        count(3)=im
        start(4)=1
        count(4)=jm
        do 210 j=1,jm
        do 210 i=1,im
          ip=i+(j-1)*im
          f(ip)=-cm2m*depthmt(ip,k)
 210    continue
        call ncvpt(ncoutid,tg3did,start,count,f,rcode)
        if(rcode.ne.0) then
          write(stdout,950) 'tgrid3 z-axis',k
          call exitus('DEFCDF')
        endif
c
c  Write (z) positions for 3D boundary fields tracer points.
c
        if(job.eq.0) then
          istr=1
          start(3)=1
          count(3)=im
          start(4)=south
          count(4)=1
          call ncvpt(ncoutid,tg3bid,start,count,f(istr),rcode)
          if(rcode.ne.0) then
            write(stdout,970) 'tbgrid3 z-axis',k,south
            call exitus('DEFCDF')
          endif
          start(4)=north
          count(4)=1
          istr=1+(jm-1)*im
          call ncvpt(ncoutid,tg3bid,start,count,f(istr),rcode)
          if(rcode.ne.0) then
            write(stdout,970) 'tbgrid3 z-axis',k,north
            call exitus('DEFCDF')
          endif
          start(3)=1
          count(3)=jm
          do 220 j=1,jm
            ip=1+(j-1)*im
            f(j)=-cm2m*depthmt(ip,k)
 220      continue
          start(4)=west
          count(4)=1
          call ncvpt(ncoutid,tg3bid,start,count,f,rcode)
          if(rcode.ne.0) then
            write(stdout,970) 'tbgrid3 z-axis',k,west
            call exitus('DEFCDF')
          endif
          do 230 j=1,jm
            ip=im+(j-1)*im
            f(j)=-cm2m*depthmt(ip,k)
 230      continue
          start(4)=east
          count(4)=1
          call ncvpt(ncoutid,tg3bid,start,count,f,rcode)
          if(rcode.ne.0) then
            write(stdout,970) 'tbgrid3 z-axis',k,east
            call exitus('DEFCDF')
          endif
        endif
c
c  Write (z) positions for 3D fields at velocity points.
c
        start(3)=1
        count(3)=im
        start(4)=1
        count(4)=jm
        do 240 j=1,jm
        do 240 i=1,im
          ip=i+(j-1)*im
          f(ip)=-cm2m*depthmv(ip,k)
 240    continue
        call ncvpt(ncoutid,vg3did,start,count,f,rcode)
        if(rcode.ne.0) then
          write(stdout,950) 'vgrid3 z-axis',k
          call exitus('DEFCDF')
        endif
c
c  Write (z) positions for 3D boundary fields velocity points.
c
        if(job.eq.0) then
          istr=1
          start(3)=1
          count(3)=im
          start(4)=south
          count(4)=1
          call ncvpt(ncoutid,vg3bid,start,count,f(istr),rcode)
          if(rcode.ne.0) then
            write(stdout,970) 'vbgrid3 z-axis',k,south
            call exitus('DEFCDF')
          endif
          start(4)=north
          count(4)=1
          istr=1+((jm-1)-1)*im
          call ncvpt(ncoutid,vg3bid,start,count,f(istr),rcode)
          if(rcode.ne.0) then
            write(stdout,970) 'vbgrid3 z-axis',k,north
            call exitus('DEFCDF')
          endif
          start(3)=1
          count(3)=jm
          do 250 j=1,jm
            ip=1+(j-1)*im
            f(j)=-cm2m*depthmt(ip,k)
 250      continue
          start(4)=west
          count(4)=1
          call ncvpt(ncoutid,vg3bid,start,count,f,rcode)
          if(rcode.ne.0) then
            write(stdout,970) 'vbgrid3 z-axis',k,west
            call exitus('DEFCDF')
          endif
          do 260 j=1,jm
            ip=(im-1)+(j-1)*im
            f(j)=-cm2m*depthmt(ip,k)
 260      continue
          start(4)=east
          count(4)=1
          call ncvpt(ncoutid,vg3bid,start,count,f,rcode)
          if(rcode.ne.0) then
            write(stdout,970) 'vbgrid3 z-axis',k,east
            call exitus('DEFCDF')
          endif
        endif
 270  continue
c
c-----------------------------------------------------------------------
c  Write 3D tracer and velocity box thicknesses.
c-----------------------------------------------------------------------
c
      start(2)=1
      start(3)=1
      count(1)=1
      count(2)=im
      count(3)=jm
c
      varid = ncvid (ncoutid,'dzt',rcode)
      if (rcode.ne.0) then
         write(stdout,930) 'dzt'
         call exitus('DEFCDF')
      endif
      do 290 k=1,km
         start(1)=k
          do 280 ip = 1, im*jm
            f(ip)=cm2m*dzt(ip,k)
 280      continue
         call ncvpt(ncoutid,varid,start,count,f,rcode)
         if (rcode.ne.0) then
            write(stdout,950) 'dzt',k
            call exitus('DEFCDF')
         endif
 290  continue
c
      varid = ncvid (ncoutid,'dzv',rcode)
      if (rcode.ne.0) then
         write(stdout,930) 'dzv'
         call exitus('DEFCDF')
      endif
      do 310 k=1,km
         start(1)=k
          do 300 ip = 1, im*jm
            f(ip)=cm2m*dzv(ip,k)
 300      continue
         call ncvpt(ncoutid,varid,start,count,f,rcode)
         if (rcode.ne.0) then
            write(stdout,950) 'dzv',k
            call exitus('DEFCDF')
         endif
 310  continue
c
 900  format(/' DEFCDF - unable to create NetCDF file: ',a)
 910  format(/' DEFCDF - unable to define ',a,' in file:'/10x,1h",a,1h")
 920  format(/' DEFCDF - error while writing variable: ',a)
 930  format(/' DEFCDF - unable to find variable: ',a)
 940  format(/' DEFCDF - error while reading variable: ',a)
 950  format(/' DEFCDF - error while writing variable: ',a,
     *        ' at LEVEL = ',i5)
 960  format(/' DEFCDF - error while writing variable: ',a,
     *        ' at BOUNDARY = ',i1)
 970  format(/' DEFCDF - error while writing variable: ',a,
     *        ' at LEVEL = ',i5,2x,' and BOUNDARY = ',i1)
 980  format(/' DEFCDF - error while writing variable: ',a,
     *        ' at INDEX = ',i5)
      return
      end
