      subroutine exitus(module)
c
c=======================================================================
c                                                                    ===
c  This routine is used to terminate execution during abnormal       ===
c  computations.   All output units  are properly  flushed and       ===
c  closed.                                                           ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     MODULE   routine issuing termination (character)               ===
c                                                                    ===
c  Calls:  LENGTH                                                    ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <iounits.h>
#include <pi_netcdf.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer slen,sbgn,send
      logical       opnd
      character*(*) module
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
#ifdef sunflush
c-----------------------------------------------------------------------
c  Flush output buffers.
c-----------------------------------------------------------------------
c
      call flush(stdout)
c
#endif
c-----------------------------------------------------------------------
c  Close opened files.
c-----------------------------------------------------------------------
c
c  Close hexadecimal input file.
c
      inquire (unit=hexinp, opened=opnd)
      if (opnd) close (hexinp)
c
c  Close transport streamfunction boundary condition input file.
c
      inquire (unit=islinp, opened=opnd)
      if (opnd) close (islinp)
c
c  Close mean tracer input file.
c
      inquire (unit=mtsinp, opened=opnd)
      if (opnd) close (mtsinp)
c
c  Close additional tracer input file.
c
      inquire (unit=trcinp, opened=opnd)
      if (opnd) close (trcinp)
c
c  Close external mode velocity input file.
c
      inquire (unit=extinp, opened=opnd)
      if (opnd) close (extinp)
c
c-----------------------------------------------------------------------
c  Close opened NetCDF files.
c-----------------------------------------------------------------------
c
c  Close output NetCDF file.
c
      if (ncoutfl.eq.1) then
        call ncabor(ncoutid,rcode)
       else if (ncoutfl.eq.2) then
        call ncclos(ncoutid,rcode)
      end if
c
c  Close input OA(G)/FM NetCDF file.
c
      if (ncinpfl.eq.1) call ncclos(ncinpid,rcode)
c
c  Close input GRIDS NetCDF file.
c
      if (ncgrdfl.eq.1) call ncclos(ncgrdid,rcode)
c
c  Close input "surface of no motion" NetCDF file.
c
      if (ncsnmfl.eq.1) call ncclos(ncsnmid,rcode)
c
c-----------------------------------------------------------------------
c  Indicate which routine issued abnormal termination.
c-----------------------------------------------------------------------
c
      call length (module,slen,sbgn,send)
c
      if (slen.lt.5) then
         write(stdout,10) module
  10     format (/' Execution abnormally terminated in module: ',a/)
c
       elseif (module((send-4):send).eq.' DONE') then
         write(stdout,20) module
  20     format (a)
c
       else
         write(stdout,10) module
      endif
c
      stop
      end
