      subroutine external (p,pv)
c
c=======================================================================
c                                                                    ===
c  This routine computes computes transport streamfunction from      ===
c  specified external mode velocity via Conjugate Gradient.          ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <baropar.h>
#include <cstseg.h>
#include <curflds.h>
#include <grddat.h>
#include <hybrid.h>
#include <moddat.h>
#include <iounits.h>
#include <ndimen.h>
#include <switches.h>
#include <zdat.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,ic,ier,iguess,ip,iter,ipt,j
      logical rstil
      real    big,c0,c1,c2,cm1,cm2m,eps,fac,p5,
     *     uf1,uf2,uf3,uf4,vf1,vf2,vf3,vf4,wt_exp,wt_expm1,
     *     wt_expm2,wt_hv,wx_hv,wy_hv
      real p(np),pv(np),pvsave(np),vor(np),wk1(np,2),wk2(np,2),
     *     wk3(np,3),mwk(np,2)
c
      parameter (big=1.0e+5,c0=0.0,c1=1.0,cm2m=0.01,eps=2.0e-7,
     *           iter=100000,p5=0.5,cm1=-1.0,c2=2.0)
#if !defined pepsib & !defined ubpsib
      parameter (wt_exp=c2, wt_expm1=wt_exp-c1, wt_expm2=wt_exp-c2)
# elif defined pepsib
      parameter (wt_exp=c1, wt_expm1=wt_exp-c1, wt_expm2=wt_exp-c2)
# else
      parameter (wt_exp=c0, wt_expm1=wt_exp-c1, wt_expm2=wt_exp-c2)
#endif
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  If coastal set-up, mask land.  Also, find mean depth over active
c  velocity points for "conditioning" the weighted laplacian.
c-----------------------------------------------------------------------
c
#ifndef ubpsib
      if(icoast.ne.0) then
        wt_hv=c0
        ic=0
        do 20 j=1,jm
          do 10 i=1,im
            ip=i+(j-1)*im
            if(landv(ip).ne.2) then
              ubar(ip)=c0
              vbar(ip)=c0
              ic=ic+1
              wt_hv=hv(ip)+wt_hv
            endif
 10       continue
 20     continue
      else
        wt_hv=c0
        ic=0
        do 25 j=2,jm-1
           do 24 i=2,im-1
              ip=i+(j-1)*im
              ic=ic+1
              wt_hv=hv(ip)+wt_hv
 24        continue
 25     continue           
      endif
      wt_hv=(float(ic)/wt_hv)**wt_expm2
# else
      wt_hv=c1
#endif
c
c-----------------------------------------------------------------------
c  Calculate PE transport: Solve Poisson Equation.
c  (Note:  Equation is multiplied by dx*tmetx*dy*tmety .)
c-----------------------------------------------------------------------
c
      write(stdout,30) dcur
  30  format(/,' Computing transport streamfunction for day = ',f12.4)
c
c  Compute vorticity (forcing term) using a five points TIMES (X) stencil
c  for the Laplacian.
c
      ic=0
      wx_hv=p5*dx*wt_hv
      wy_hv=p5*dy*wt_hv
c
      do 50 j=2,jm-1
        do 40 i=2,im-1
          ic=ic+1
          ip=i+(j-1)*im
          uf1=ubar(ip-im-1)*vmetx(ip-im-1)*(hv(ip-im-1)**wt_expm1)*wx_hv
          uf2=ubar(ip-im  )*vmetx(ip-im  )*(hv(ip-im  )**wt_expm1)*wx_hv
          uf3=ubar(ip     )*vmetx(ip     )*(hv(ip     )**wt_expm1)*wx_hv
          uf4=ubar(ip-1   )*vmetx(ip-1   )*(hv(ip-1   )**wt_expm1)*wx_hv
          vf1=vbar(ip-im-1)*vmety(ip-im-1)*(hv(ip-im-1)**wt_expm1)*wy_hv
          vf2=vbar(ip-im  )*vmety(ip-im  )*(hv(ip-im  )**wt_expm1)*wy_hv
          vf3=vbar(ip     )*vmety(ip     )*(hv(ip     )**wt_expm1)*wy_hv
          vf4=vbar(ip-1   )*vmety(ip-1   )*(hv(ip-1   )**wt_expm1)*wy_hv
          vor(ic)= ((vf2-vf1)+(vf3-vf4)) - ((uf4-uf1)+(uf3-uf2))
  40    continue
  50  continue
c
c  Load vorticity into the interior of array PV.
c
      ic=0
      do 80 j=2,jm-1
        do 70 i=2,im-1
          ip=i+(j-1)*im
          ic=ic+1
          pv(ip)=vor(ic)
  70    continue
  80  continue
c
c  Load the ratios of the metric terms into the work arrays.
c
      wx_hv=wt_hv*(dy/dx)
      wy_hv=wt_hv*(dx/dy)
c
      do 90 j=1,jm
      do 90 i=1,im
        ip=i+(j-1)*im
        mwk(ip,1)=(vmety(ip)/vmetx(ip))*(hv(ip)**wt_expm2)*wx_hv
        mwk(ip,2)=(vmetx(ip)/vmety(ip))*(hv(ip)**wt_expm2)*wy_hv
  90  continue
c
c  Use conjugate algorithm to solve Poisson equation.  The percent of
c  RMS of the solution allowed as error is EPS.
c
      if(icoast.eq.0) then
        iguess=1
        ipt=1
#ifdef trytrby
        if (usetrby) call transobdy (p,pv,im,jm,np)
#endif
        call cgpois(wk1,wk2,wk3,p,pv,eps,iter,im,jm,mwk(1,1),mwk(1,2),
     *              np,iguess,ipt,ier)
      else
c
c  Reset boundary values at grid boundary for the coastal setup.
c
        iguess=1
        call transbdy (p,pv,im,jm,np,rstil,pvsave)
        call cgpois1 (wk1,wk2,wk3,p,pv,eps,iter,im,jm,mwk(1,1),mwk(1,2),
     *                np,iguess,ier)
        if (rstil) then
           call reset_isle (im,jm,np,pvsave,pv,p)
           call cgpois1 (wk1,wk2,wk3,p,pv,eps,iter,im,jm,mwk(1,1),
     *                   mwk(1,2),np,iguess,ier)
        endif
      endif
c
c  Load solution.
c
      do 100 j=1,jm
      do 100 i=1,im
        ip=i+(j-1)*im
        pbar(ip)=pv(ip)
 100  continue
c
c  Recover external velocities for algorithm checking purposes.
c
      do 150 j=1,jm-1
        do 140 i=1,im-1
          ip=i+(j-1)*im
          fac=p5/(dy*hv(ip)*vmety(ip))
          ubar(ip)=fac*((pbar(ip     )+pbar(ip+1   ))-
     *                   (pbar(ip+im  )+pbar(ip+im+1)))
          fac=p5/(dx*hv(ip)*vmetx(ip))
          vbar(ip)=fac*((pbar(ip+1   )+pbar(ip+im+1))-
     *                   (pbar(ip     )+pbar(ip+im  )))
 140    continue
 150  continue
c
      return
      end
