      subroutine fsave(fsav,mn,f,m,n,im,jm,km)
c
c=======================================================================
c                                                                    ===
c  This routine is used by  GET_DATA to stored read fields in their  ===
c  appropriate array.   Entries FSAVEU, FSAVEV, and FSAVET are used  ===
c  when the coastal option is activated to mask and then save zonal  ===
c  velocity component,  meridional velocity component,  and tracers  ===
c  (temperature and salinity), respectively.                         ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <cstseg.h>
#include <iounits.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,im,ip,j,jm,k,km,m,mn,n,npts
      real c0,f(m,n),fsav(mn)
      parameter (c0=0.0)
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
      npts=im*jm*km
      if(npts.gt.mn) then
        write(stdout,100) 'MN, NPTS = ',mn,npts
 100    format (/,' FSAVE: underdimensioned array: ',a,2i6)
        call exitus('FSAVE')
      endif
c
      npts=0
      do 130 j=1,jm
        do 120 i=1,im
          ip=i+(j-1)*im
          do 110 k=1,km
            npts=npts+1
            fsav(npts)=f(ip,k)
 110      continue
 120    continue
 130  continue
      return
c
c=======================================================================
c  If coastal set-up, mask and save zonal velocity component.
c=======================================================================
c
      entry fsaveu(fsav,mn,f,m,n,im,jm,km)
c
      npts=im*jm*km
      if(npts.gt.mn) then
        write(stdout,200) 'MN, NPTS = ',mn,npts
 200    format (/,' FSAVEU: underdimensioned array: ',a,2i6)
        call exitus('FSAVEU')
      endif
c
      npts=0
      do 230 j=1,jm
        do 220 i=1,im
          ip=i+(j-1)*im
          do 210 k=1,km
            npts=npts+1
            if(landv(ip).eq.2) then
              fsav(npts)=f(ip,k)
            elseif(landv(ip).eq.1) then
              if((landv(min(i+1,im)+(j-1)*im).eq.1).and.
     &           (landv(max(i-1,1 )+(j-1)*im).eq.1)) then
                fsav(npts)=f(ip,k)
              else
                fsav(npts)=c0
              endif
            else
              fsav(npts)=c0
            endif
 210      continue
 220    continue
 230  continue
      return
c
c=======================================================================
c  If coastal set-up, mask and save meridional velocity component.
c=======================================================================
c
      entry fsavev(fsav,mn,f,m,n,im,jm,km)
c
      npts=im*jm*km
      if(npts.gt.mn) then
        write(stdout,300) 'MN, NPTS = ',mn,npts
 300    format (/,' FSAVEV: underdimensioned array: ',a,2i6)
        call exitus('FSAVEV')
      endif
c
      npts=0
      do 330 j=1,jm
        do 320 i=1,im
          ip=i+(j-1)*im
          do 310 k=1,km
            npts=npts+1
            if(landv(ip).eq.2) then
              fsav(npts)=f(ip,k)
            elseif(landv(ip).eq.1) then
              if((landv(i+(max(j-1,1 )-1)*im).eq.1).and.
     &           (landv(i+(min(j+1,jm)-1)*im).eq.1)) then
                fsav(npts)=f(ip,k)
              else
                fsav(npts)=c0
              endif
            else
              fsav(npts)=c0
            endif
 310      continue
 320    continue
 330  continue
      return
      end
