      subroutine get_cdfdat(day,iread)
c
c=======================================================================
c                                                                    ===
c  This routine read in the temperature and salinity fields from     ===
c  input NetCDF file.                                                ===
c                                                                    ===
c  On Input:                                                         ===
c                                                                    ===
c       DAY    day to read (real)                                    ===
c                                                                    ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <curflds.h>
#include <moddat.h>
#include <ndimen.h>
#include <obserr.h>
#include <pi_netcdf.h>
#include <switches.h>
#include <workspa.h>
#include <zdat.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      logical first,onerrfld
      integer i,ip,iread,j,k,m,n,ntrc,lenvar,lentst(3),timindx
      integer lnblk
      real c0,day,dm2cm2s2,scale
      character*128 tst_str(3)
c
      parameter (c0=0.0,dm2cm2s2=1.0e+5)
c
      save first,scale
      data first /.true./
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c  Compute scale for dynamic height.  The dynamic height is assumed to
c  be in dynamic meters; 1 dyn m = 10 J/kg = 10 m2/s2 = 10^5 cm2/s2.
c
      if(first) then
        day=tstart
        tsave=tstart
        first=.false.
        scale=dm2cm2s2/(f0*v0*dhor)
      endif
c
c-----------------------------------------------------------------------
c  Determine time index.
c-----------------------------------------------------------------------
c
      dcur=tsave
      iread=0
      timindx=0
      do 10 n=1,ntime
        if(time(n).eq.tsave) then
          timindx=n
        endif
 10   continue
      if(timindx.eq.0) then
        iread=1
        return
      endif
      if(time(ntime).eq.tsave) iread=1
c
c-----------------------------------------------------------------------
c  Read in streamfunction, temperature, salinity, and other tracers.
c  If applicable, read in their associated error fields.
c-----------------------------------------------------------------------
c
      onerrfld=.false.
      lwrtdynht=.false.
      do 30 n=1,nvars
        varid=n
        lenvar=lnblk(varnam(n),len(varnam(n)))
        do 20 ntrc = 1,nt
          call blank(3,tst_str)
          tst_str(1) = tname(1,ntrc)
          lentst(1) = lnblk(tst_str(1),len(tst_str(1)))
          tst_str(2) = tst_str(1)(1:lentst(1))//'err'
          lentst(2) = lentst(1)+3
          tst_str(3) = tst_str(1)(1:lentst(1))//'rmsdev'
          lentst(3) = lentst(1)+6
          if(varnam(n)(1:lenvar).eq.tst_str(1)(1:lentst(1))) then
            call readcdf(ncinpid,timindx,varid,varnam(n),nvdims(n),
     *                   vdims(1,n),t(1,1,ntrc),np,nz)
          elseif(varnam(n)(1:lenvar).eq.tst_str(2)(1:lentst(2))) then
            call readcdf(ncinpid,timindx,varid,varnam(n),nvdims(n),
     *                   vdims(1,n),toerr(1,1,ntrc),np,nz)
            lwrtoerr=.true.
            ioerr(ntrc+4)=1
          elseif(varnam(n)(1:lenvar).eq.tst_str(3)(1:lentst(3))) then
            call read1cdf(ncinpid,timindx,varid,varnam(n),nvdims(n),
     *                    vdims(1,n),toscl(1,ntrc),nz)
            ioscl(ntrc+4)=1
          endif
 20     continue
        if(varnam(n)(1:lenvar).eq.'dynht') then
          call readcdf(ncinpid,timindx,varid,varnam(n),nvdims(n),
     *                 vdims(1,n),psi(1,1),np,nz)
          lwrtdynht=.true.
        elseif(varnam(n)(1:lenvar).eq.'dynhterr') then
          call readcdf(ncinpid,timindx,varid,varnam(n),nvdims(n),
     *                 vdims(1,n),psioerr(1,1),np,nz)
          lwrtoerr=.true.
          ioerr(0)=1
        elseif(varnam(n)(1:lenvar).eq.'dynhtrmsdev') then
          call read1cdf(ncinpid,timindx,varid,varnam(n),nvdims(n),
     *                  vdims(1,n),psioscl,nz)
          ioscl(0)=1
        elseif(varnam(n)(1:lenvar).eq.'stream') then
          call readcdf(ncinpid,timindx,varid,varnam(n),nvdims(n),
     *                 vdims(1,n),psi(1,1),np,nz)
        elseif(varnam(n)(1:lenvar).eq.'strmerr') then
          call readcdf(ncinpid,timindx,varid,varnam(n),nvdims(n),
     *                 vdims(1,n),psioerr(1,1),np,nz)
          lwrtoerr=.true.
          ioerr(0)=1
        elseif(varnam(n)(1:lenvar).eq.'strmrmsdev') then
          call read1cdf(ncinpid,timindx,varid,varnam(n),nvdims(n),
     *                  vdims(1,n),psioscl,nz)
          ioscl(0)=1
        elseif(varnam(n)(1:lenvar).eq.'error') then
          onerrfld=.true.
          call readcdf(ncinpid,timindx,varid,varnam(n),nvdims(n),
     *                 vdims(1,n),psioerr(1,1),np,nz)
          lwrtoerr=.true.
          ioerr(0)=1
        elseif(varnam(n)(1:lenvar).eq.'rmsdev') then
          call read1cdf(ncinpid,timindx,varid,varnam(n),nvdims(n),
     *                  vdims(1,n),psioscl,nz)
          ioscl(0)=1
        endif
  30  continue
c
c-----------------------------------------------------------------------
c  If field ERROR was present, duplicate the same error field to
c  all variables.
c-----------------------------------------------------------------------
c
      if(onerrfld) then
        do 60 m=1,nt
          ioerr(m+4)=1
          ioscl(m+4)=ioscl(0)
          do 50 k=1,kfld
            do 40 j=1,jm
            do 40 i=1,im
              ip=i+(j-1)*im
              toerr(ip,k,m)=psioerr(ip,k)
  40        continue
            if(ioscl(0).ne.0) toscl(k,m)=psioscl(k)
  50      continue
  60    continue
      endif
c
c-----------------------------------------------------------------------
c  If applicable, scale dynamic height to streamfunction.
c-----------------------------------------------------------------------
c
      if(lwrtdynht) then
        do 70 k=1,kfld
        do 70 j=1,jm
        do 70 i=1,im
          ip=i+(j-1)*im
          psi(ip,k)=scale*psi(ip,k)
  70    continue
      endif
c
c-----------------------------------------------------------------------
c  Determine the next time to save.
c-----------------------------------------------------------------------
c
      day=tsave
      if(tskip.ne.c0) then
        tsave=dcur+tskip
      else
        tsave=time(timindx+1)
      endif
      return
      end
