      subroutine get_data(day,iread)
c
c=======================================================================
c                                                                    ===
c  This routine reads in and saves input FM or QG formatted fields   ===
c  at time DAY.                                                      ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <curflds.h>
#include <iounits.h>
#include <moddat.h>
#include <ndimen.h>
#include <obserr.h>
#include <pefldid.h>
#include <qgfldid.h>
#include <switches.h>
#include <workspa.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      logical first,reading
      integer iread,n
      real c0,day,r1,r2,sec2day,time
c
      parameter (c0=0.0,sec2day=1.0/86400.0)
c
      save first
      data first /.true./
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
      if(first) then
        ifield=0
        level=0
        iread=0
        if(ifile.eq.1) tsave=tstart
        if(ifile.eq.2) tsave=c0
        first=.false.
      endif
c
c-----------------------------------------------------------------------
c  Read formatted hexadecimal fields.
c-----------------------------------------------------------------------
c
      dcur=tsave
      reading=.true.
      write(stdout,10) tsave
  10  format (/,' Reading data for day = ',f12.4)
c
c  Scan input file and save fields at requested time.
c
      do 40 while (reading.and.(iread.eq.0))
c
c  Load read field to the appropriate array.
c
        do 20 n = 1, nt
           if (ifield.eq.trcid(n)) then
              call save(f,t(1,level,n),nm)
             else if (ifield.eq.trcerrid(n)) then
              call save(f,toerr(1,level,n),nm)
           end if
 20     continue
        if(ifield.eq.qgmpsi) call save(f,psi(1,level),nm)
        if(ifield.eq.qgwvzv) call save(f,dwdz(1,level),nm)
        if(ifield.eq.qgdher) call save(f,psioerr(1,level),nm)
        if(ifield.eq.peuoer) call save(f,uoerr(1,level),nm)
        if(ifield.eq.pevoer) call save(f,voerr(1,level),nm)
        if(ifield.eq.pepoer) call save(f,pbaroerr(1),nm)
c
c  Read in hexadecimal field.
c
  30    call xread(f,nm,time,ifield,level,r1,r2,hexinp,iread)
c
c  Set DAY to just read time (in days).
c
        if(ifile.eq.1) then
          tread=time
        elseif(ifile.eq.2) then
          tread=time0+t0*time*sec2day
        endif
        if(tread.lt.tsave) goto 30
        if(tread.ne.tsave) reading=.false.
  40  continue
      day=tsave
      if(tskip.ne.c0) then
        tsave=dcur+tskip
      else
        tsave=tread
      endif
c
c  Read addional tracers file, if necessary.
c
      if(itrc.eq.1) call get_trc(day)
      return
      end
