      subroutine get_isval (pcrs,corrcst,psisl)
c
c=======================================================================
c                                                                    ===
c  This routine finds values to impose on islands from corresponding ===
c  coasts in the large domain.                                       ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     PCRS      Coarse transport streamfunction.     (real array)    ===
c                                                                    ===
c   Common Blocks:                                                   ===
c                                                                    ===
c   /CRS_DOM/                                                        ===
c                                                                    ===
c     CICST    Coarse coastline x-components.      (integer array)   ===
c     CJCST    Coarse coastline y-components.      (integer array)   ===
c     CNY      Number of coarse points in y-dir.   (integer)         ===
c                                                                    ===
c   /FNE_DOM/                                                        ===
c                                                                    ===
c     FLANDP   Fine transport Sfn mask.          (integer vector)    ===
c     FNCST    Number of coastlines in fine.     (integer)           ===
c     FNISL    Number of islands in fine grid.   (integer)           ===
c     FNX      Number of fine points in x-dir.   (integer)           ===
c     FNY      Number of fine points in y-dir.   (integer)           ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     CORRCST   Identifier for coasts in coarse      (integer vector)===
c               grid which correspond to fine isles.                 ===
c     PSISL     Sfunction values on the islands.     (real vector)   ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     HOPS:  GET_NBHRS,  ISINCRS                                     ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <pconst.h>
#include <crs_dom.h>
#include <fne_dom.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,ip,islptr,j,lstext,n,nnbhr
      integer corrcst(mcseg),nbhrs(4)
      logical isincrs
      real    pcrs(np),psisl(mcseg)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Get index of last exterior coast.  Initialize output.
c-----------------------------------------------------------------------
c
      lstext = fncst - fnisl
c
      do 10 n = 1, mcseg
         corrcst(n) = 0
         psisl(n)   = c0
  10  continue
c
c-----------------------------------------------------------------------
c  Loop over all fine grid points, identifying coast correspondances
c  for fine grid islands.  This algorithm assumes well defined land
c  masks by arbitrarily taking the first "success".
c-----------------------------------------------------------------------
c
      do 20 j = 1, fny
      do 20 i = 1, fnx
c
         ip = i + (j-1)*fnx
c
         if (flandp(ip).gt.lstext) then
c
            islptr = flandp(ip) - lstext
            if (corrcst(islptr).eq.0) then
c
               call get_nbhrs (i,j,nnbhr,nbhrs)
               if (isincrs(nnbhr,nbhrs)) corrcst(islptr)=nbhrs(1)
c
            end if
c
         end if
c
  20  continue
c
c-----------------------------------------------------------------------
c  Get index of last exterior coast.
c-----------------------------------------------------------------------
c
      do 30 n = 1, fnisl
c
         if (corrcst(n).ne.0) then
c
            ip       = cicst(1,corrcst(n)) + (cjcst(1,corrcst(n))-1)*cnx
            psisl(n) = pcrs(ip)
c
         end if
c
  30  continue
c
      return
      end
