      subroutine get_nbhrs (i,j,nnbhr,nbhrs)
c
c=======================================================================
c                                                                    ===
c  This routine determines the values of the coarse grid coastal     ===
c  mask which bound the given fine grid location.                    ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     I, J    Location of fine grid point.         (integer)         ===
c                                                                    ===
c   Common Blocks:                                                   ===
c                                                                    ===
c   /CRS_DOM/                                                        ===
c                                                                    ===
c     CCLN     Coarse transform centroid long.     (real)            ===
c     CCLT     Coarse transform centroid lat.      (real)            ===
c     CCRD     Coarse grid type.                   (integer)         ===
c     CDLX     Coarse grid x-offset.               (real)            ===
c     CDLY     Coarse grid y-offset.               (real)            ===
c     CDX      Coarse spacing in x-direction.      (real)            ===
c     CDY      Coarse spacing in y-direction.      (real)            ===
c     CLANDP   Coarse transport Sfn mask.          (integer vector)  ===
c     CNX      Number of coarse points in x-dir.   (integer)         ===
c     CNY      Number of coarse points in y-dir.   (integer)         ===
c     CTHTA    Coarse rotation angle (WRT East).   (real)            ===
c                                                                    ===
c   /FNE_DOM/                                                        ===
c                                                                    ===
c     FCLN     Fine transform centroid long.     (real)              ===
c     FCLT     Fine transform centroid lat.      (real)              ===
c     FCRD     Fine grid type.                   (integer)           ===
c     FDLX     Fine grid x-offset.               (real)              ===
c     FDLY     Fine grid y-offset.               (real)              ===
c     FDX      Fine spacing in x-direction.      (real)              ===
c     FDY      Fine spacing in y-direction.      (real)              ===
c     FNX      Number of fine points in x-dir.   (integer)           ===
c     FNY      Number of fine points in y-dir.   (integer)           ===
c     FTHTA    Fine rotation angle (WRT East).   (real)              ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     NNBHR   Number of coarse neighbors.          (integer)         ===
c     NBHRS   Values of neighboring coarse mask.   (integer vector)  ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     HOPS:  LL2XY,  XY2LL                                           ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <pconst.h>
#include <crs_dom.h>
#include <fne_dom.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,ip,ix,iy,j,nnbhr
      integer nbhrs(4)
      real    c5r6,lon,lat,x,y
c
      parameter (c5r6=c5*r6)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Convert fine grid location to coarse grid location.
c-----------------------------------------------------------------------
c
      call xy2ll (float(i),float(j),fcrd,fnx,fny,fdx,fdy,fcln,fclt,fdlx,
     &            fdly,fthta,lon,lat)
c
      call ll2xy (lon,lat,ccrd,cnx,cny,cdx,cdy,ccln,cclt,cdlx,cdly,
     &            cthta,x,y)
c
      ix = int(x)
      x  = x - float(ix)
      if (abs(x).lt.r6) then
         x = c0
       elseif (abs(x).gt.c5r6) then
         ix = ix + 1
         x  = c0
      end if
c
      iy = int(y)
      y  = y - float(iy)
      if (abs(y).lt.r6) then
         y = c0
       elseif (abs(y).gt.c5r6) then
         iy = iy + 1
         y  = c0
      end if
c
c-----------------------------------------------------------------------
c  Extract neighboring values.
c-----------------------------------------------------------------------
c
      if ((x.gt.c0).and.(y.gt.c0)) then
         nnbhr    = 4
         ip       = ix + (iy-1)*cnx
         nbhrs(1) = clandp(ip)
         ip       = ix+1 + (iy-1)*cnx
         nbhrs(2) = clandp(ip)
         ip       = ix + iy*cnx
         nbhrs(3) = clandp(ip)
         ip       = ix+1 + iy*cnx
         nbhrs(4) = clandp(ip)
       else if (x.gt.c0) then
         nnbhr    = 2
         ip       = ix + (iy-1)*cnx
         nbhrs(1) = clandp(ip)
         ip       = ix+1 + (iy-1)*cnx
         nbhrs(2) = clandp(ip)
       else if (y.gt.c0) then
         nnbhr    = 2
         ip       = ix + (iy-1)*cnx
         nbhrs(1) = clandp(ip)
         ip       = ix + iy*cnx
         nbhrs(2) = clandp(ip)
       else
         nnbhr    = 1
         ip       = ix + (iy-1)*cnx
         nbhrs(1) = clandp(ip)
      end if
c
      return
      end
