      subroutine get_opn (ist,jst,ind,jnd,mxpt,im,jm,nopn,iopn,jopn)
c
c=======================================================================
c                                                                    ===
c  This routine gets the open boundary bracketted by the given       ===
c  coastal endpoints.                                                ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     IST    I-index of coastline at start.          (integer)       ===
c     JST    J-index of coastline at start.          (integer)       ===
c     IND    I-index of coastline at end.            (integer)       ===
c     JND    J-index of coastline at end.            (integer)       ===
c     MXPT   Maximum length for the open segment.    (integer)       ===
c     IM        number of vertical levels.    (integer)              ===
c     JM        number of vertical levels.    (integer)              ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     NOPN   Number of points in the open segment.   (integer)       ===
c     IOPN   I-indices of the open segment.          (integer vector)===
c     JOPN   J-indices of the open segment.          (integer vector)===
c                                                                    ===
c  Call:  none                                                       ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer im,ist,jm,jst,ind,jnd,mxpt,nopn
      integer iopn(mxpt),jopn(mxpt)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Start at first point.
c-----------------------------------------------------------------------
c
      nopn       = 1
      iopn(nopn) = ist
      jopn(nopn) = jst
c
c-----------------------------------------------------------------------
c  Coasts end one point away from outer boundary.
c-----------------------------------------------------------------------
c
      if (iopn(nopn).eq.2) then
         iopn(nopn) = 1
       elseif (iopn(nopn).eq.im-1) then
         iopn(nopn) = im
       elseif (jopn(nopn).eq.2) then
         jopn(nopn) = 1
       elseif (jopn(nopn).eq.jm-1) then
         jopn(nopn) = jm
      end if
c
c-----------------------------------------------------------------------
c  Extract remaining open boundary points in current segment.
c-----------------------------------------------------------------------
c
      do 10 while ( (iopn(nopn).ne.ind) .or. (jopn(nopn).ne.jnd) )
c
         nopn = nopn + 1
c
         if ( (jopn(nopn-1).eq.1) .and. (iopn(nopn-1).lt.im) ) then
            iopn(nopn) = iopn(nopn-1) + 1
            jopn(nopn) = jopn(nopn-1)
c
          elseif ((iopn(nopn-1).eq.im).and.(jopn(nopn-1).lt.jm)) then
            iopn(nopn) = iopn(nopn-1)
            jopn(nopn) = jopn(nopn-1) + 1
c
          elseif ((jopn(nopn-1).eq.jm).and.(iopn(nopn-1).gt.1)) then
            iopn(nopn) = iopn(nopn-1) - 1
            jopn(nopn) = jopn(nopn-1)
c
          elseif ((iopn(nopn-1).eq.1).and.(jopn(nopn-1).gt.1)) then
            iopn(nopn) = iopn(nopn-1)
            jopn(nopn) = jopn(nopn-1) - 1
         end if
c
  10  continue
c
      return
      end
