      subroutine get_parm
c
c=======================================================================
c                                                                    ===
c  This routine reads in the input parameters from standard input.   ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <netcdf.inc>
#include <baropar.h>
#include <curflds.h>
#include <cstseg.h>
#include <hybrid.h>
#include <iounits.h>
#include <meants.h>
#include <moddat.h>
#include <ndimen.h>
#include <obserr.h>
#include <pi_netcdf.h>
#include <shapfil.h>
#include <switches.h>
#include <zdat.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,ip,j,k,n,nisland
#ifdef trytrby
     &        ,ios
#endif
      integer lnblk
      real c2,c24,c180,c3600,cm1,cm2m,cenlat,cenlon,deg2rad,km2m,m2cm,
     &     omega,p5,pi,re,radius
      parameter (c2=2.0,c24=24.0,c180=180.0,c3600=3600.0,cm1=-1.0,
     *           cm2m=0.01,km2m=1000.0,m2cm=100.0,p5=0.5,re=6371.315)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c  Read in type of input file: [0] NetCDF, [1] FM or OA, [2] QG model
c
      read(stdinp,*) ifile
      if((ifile.lt.0).or.(ifile.gt.2)) then
        write(stdout,10) 'IFILE = ',ifile
  10    format(/,' GET_PARM - illegal flag, ',a,i2)
        call exitus('GET_PARM')
      endif
c
c  Read in job type:
c
c     [0] produce initial and boundary fields
c     [1] produce fields for assimilation
c     [2] produce initial and boundary conditions with barotropic
c         mode specification for open domains (all boundaries).
c     [3] produce initial and boundary conditions with horizontally
c         uniform T,S and zero velocities
c
      read(stdinp,*) job
      if((job.lt.0).or.(job.gt.3)) then
        write(stdout,10) 'JOB = ',job
        call exitus('GET_PARM')
      endif
c
c  Initialize initialization flag.
c
      if(job.eq.2) iflag(1)=1
c
c  Read in the day of the input data that is assigned for
c  initialization.
c
      read(stdinp,*) tstart
c
c  Read in last day to process.  For persisted boundary conditions
c  must be equal to TSTART.
c
      read(stdinp,*) tstop
      if(tstart.eq.tstop) then
        iflag(3)=1
        ifpers=1
      endif
c
c  Read in time interval (days) for scanning and processing of input
c  data.  Output fields having a time-coordinate will be written
c  every other TSKIP days.  However, if TSKIP=0, then the input data
c  is scanned and processed at its own (input) time frequency.
c
      read(stdinp,*) tskip
c
c  Read in switch ITS2PSI to compute PSI from TS.
c
c    [0] No
c    [1] Yes
c
      read(stdinp,*) its2psi
c
c  Read in flag for boundary condition on barotropic streamfunction
c  (PBAR): [1] PBAR at the boundary and next interior points, [2] PBAR
c  and d(barotropic vorticity)/dt.
c
      read(stdinp,*) iflag(4)
      if( (iflag(4).lt.1) .or. (iflag(4).gt.2) ) then
        write(stdout,10) 'IFLAG(4) = ',iflag(4)
        call exitus('GET_PARM')
      endif
c
c  Read in switch for setting barotropic velocities:
c
c    [0] Reference depth as is, no bottom steering, bndy from QG psi
c    [1] Reference depth as is, no bottom steering, bndy from UBARO est.
c    [2] Reference depth as is, bottom steering, bndy from QG psi
c    [3] Reference depth as is, bottom steering, bndy from UBARO est.
c    [4] Reference depth = DEF_DEPTH, no bottom steering, bndy from QG psi
c    [5] Reference depth = DEF_DEPTH, no bottom steering, bndy from UBARO est.
c    [6] Reference depth = DEF_DEPTH, bottom steering, bndy from QG psi
c    [7] Reference depth = DEF_DEPTH, bottom steering, bndy from UBARO est.
c    [8] Reference depth from nc-file, no bottom steering, bndy from QG psi
c    [9] Reference depth from nc-file, no bottom steering, bndy from UBARO est.
c   [10] Reference depth from nc-file, bottom steering, bndy from QG psi
c   [11] Reference depth from nc-file, bottom steering, bndy from UBARO est.
c
      read(stdinp,*) iflag(5)
      if( (iflag(5).lt.0) .or. (iflag(5).gt.11) ) then
        write(stdout,10) 'IFLAG(5) = ',iflag(5)
        call exitus('GET_PARM')
      endif
c
c  Read in default reference level.
c
      read(stdinp,*) def_depth
      def_depth = def_depth*m2cm
c
c  Read in wbot_depth.
c
      read(stdinp,*) wbot_depth
      wbot_depth = wbot_depth*m2cm
c
c  Read in flag for ageostrophic motion: [1] none, [2] beta effect,
c  [3] full Coriolis.
c
      read(stdinp,*) iflag(6)
      if( (iflag(6).lt.1) .or. (iflag(6).gt.3) ) then
        write(stdout,10) 'IFLAG(6) = ',iflag(6)
        call exitus('GET_PARM')
      endif
c
c  Read in number of tracers to process (minimum 2: temperature and
c  salinity
c
      read(stdinp,*) nt
      if(nt.lt.2) then
        write(stdout,20) nt
  20    format(/,' GET_PARM - illegal number of tracers, NT = ',i4)
      elseif(nt.gt.mt) then
        write(stdout,30) 'MT, NT = ',mt,nt
  30    format(/,' GET_PARM - underdimension arrays, ',a,2i4)
        call exitus('GET_PARM')
      endif
c
c  Read in biological model type, IBIOM:
c        [0] None,
c        [1] McGillicuddy et al. (1995)
c        [2] Anderson (1995) expansion of McGillicuddy model.
c        [3] Fasham et al. (1990)
c
      read(stdinp,*) ibiom
#ifdef bioDuse
c
c  Note that ibiom is not used if -DbioDuse is specified
c
      if(nt.ne.9) then
        write(stdout,40) 'Dusenberry',nt,9
        call exitus('GET_PARM')
      endif
#else
      if((ibiom.lt.0).or.(ibiom.gt.3)) then
        write(stdout,10) 'IBIOM = ',ibiom
        call exitus('GET_PARM')
      elseif((ibiom.eq.1).and.(nt.ne.6)) then
        write(stdout,40) 'McGillicuddy',nt,6
cjad  40    format(/,' GET_PARM - inconsitent number of tracers with ',a,
c     *           ' biological model, NT = ',i2/12x,'Required number of',
c     &           ' tracers:  ',i2)
        call exitus('GET_PARM')
      elseif((ibiom.eq.2).and.(nt.ne.7)) then
        write(stdout,40) 'Anderson',nt,7
        call exitus('GET_PARM')
      elseif((ibiom.eq.3).and.(nt.ne.9)) then
        write(stdout,40) 'Fasham',nt,9
        call exitus('GET_PARM')
      endif
#endif
  40    format(/,' GET_PARM - inconsitent number of tracers with ',a,
     *           ' biological model, NT = ',i2/12x,'Required number of',
     &           ' tracers:  ',i2)
c
c  Read in switch to read additional tracers from provided file.
c
      read(stdinp,*) itrc
c
c  Read in switch for type of interpolation to hybrid coordinates:
c  [0] linear, [1] cubic splines.
c
      read(stdinp,*) intopt
      iflag(2)=intopt
      if((intopt.lt.0).or.(intopt.gt.1)) then
        write(stdout,10) 'INTOPT = ',intopt
        call exitus('GET_PARM')
      endif
c
c  Read in flags to Shapiro filter the input fields.
c
      read(stdinp,*) ifilter
      read(stdinp,*) nord
      read(stdinp,*) nrep
c
      ifilter = abs (ifilter)
c
c  Read in switch to write out fields for quick browsing and/or
c  debugging purposes: [0] no, [else] yes.
c
      read(stdinp,*) idbug
c
c  Read in output NetCDF filename.
c
      read(stdinp,'(a)') fname(1)
c
c  Read in output echo filename.
c
      read(stdinp,'(a)') fname(2)
      open(stdout,file=fname(2),form='formatted',status='unknown')
      call headln (stdout)
c
c  Read in data input filename.
c
      read(stdinp,'(a)') fname(3)
      if (ifile.ne.0 .or. job .eq. 3)
     &   open(hexinp,file=fname(3),form='formatted',status='old')
c
c  Read in mean temperature and salinity profiles (mean stratification).
c
      read(stdinp,'(a)') fname(4)
      open(mtsinp,file=fname(4),form='formatted',status='old')
      read(mtsinp,*) nprof
      if(nprof.gt.mprof) then
        write(stdout,30) 'MPROF, NPROF = ',mprof,nprof
        call exitus('GET_PARM')
      endif
      do 50 k=1,nprof
        read(mtsinp,*) zm(k),tm(k),sm(k)
        zm(k)=cm1*zm(k)
  50  continue
c
c  Read in GRIDS netCDF filename.
c
      read(stdinp,'(a)') fname(5)
c
c  Read in geometry data from GRIDS NetCDF file
c
      call read_grids
c
c  Read in transport around islands and along open segments filename.
c
      read(stdinp,'(a)') fname(6)
      if(icoast.ne.0) then
        open(islinp,file=fname(6),form='formatted',status='old')
#ifdef trytrby
       else
        open (islinp, file=fname(6), form='formatted', status='old',
     &        iostat=ios)
        usetrby = ios .eq. 0
#endif
      endif
c
c  Read in additional tracers input filename.
c
      read(stdinp,'(a)') fname(7)
      if((itrc.ge.1).and.(nt.gt.2)) then
        open(trcinp,file=fname(7),form='formatted',status='old')
      endif
c
c  Read in barotropic velocity components filename
c
      read(stdinp,'(a)') fname(8)
      if(job.eq.2) then
        open(extinp,file=fname(8),form='formatted',status='old')
      endif
c
c  Read in barotropic velocity components filename
c
      read(stdinp,'(a)') fname(9)
      if ((iflag(5)/4).eq.2) then
        call ncpopt (ncverbos)
        ncsnmid = ncopn (fname(9),ncnowrit,rcode)
        if (rcode.eq.0) then
          ncsnmfl=1
         else
          k=lnblk(fname(9),len(fname(9)))
          write(stdout,60) fname(9)(1:k)
  60      format(/,' GET_PARM - Unable to open reference surface file'/
     &           12x,1h",a,2h".)
          call exitus('GET_PARM')
        endif
      endif
c
      write(stdout,70) fname(3),fname(4),fname(5),fname(1),fname(2)
  70  format(/,'       Input file: ',a,
     *       /,' Climatology file: ',a,
     *       /,'GRIDS netCDF file: ',a,
     *       /,'      Output file: ',a,
     *       /,'     History file: ',a)
#ifndef trytrby
      if(icoast.ne.0) write(stdout,80) fname(6)
# else
      if((icoast.ne.0).or.usetrby) write(stdout,80) fname(6)
#endif
  80  format(  '   Transport file: ',a)
      if((itrc.eq.1).and.(nt.gt.2)) write(stdout,90) fname(7)
  90  format(  '     tracers file: ',a)
      if(job.eq.2) write(stdout,100) fname(8)
 100  format(  '  barotropic file: ',a)
      if((iflag(5)/4).eq.2) write(stdout,110) fname(9)
 110  format(  'Ref. Surface file: ',a)
      if ((iflag(6).eq.2).or.(iflag(6).eq.3)) write(stdout,120)
 120  format (/,' Streamfunction adjusted for changes in the Coriolis',
     *          ' parameter.')
      if (ifilter.gt.0) then
        write (stdout,130) ifilter
 130    format (//' Shapiro filter is active:'/
     *          /5x,'                IFILTER = ',i4)
        if (mod(ifilter,2).eq.1)
     &     write (stdout,140) 'Filtering input fields'
 140    format (31x,a)
        if (mod(ifilter,4).gt.1)
     &     write (stdout,140) 'Filtering flat-level velocities'
        write (stdout,150) nord,nrep
 150    format (5x,'                  order = ',i4/
     *          5x,' number of applications = ',i4/)
      else
        write(stdout,160)
 160    format(//' Shapiro filter is inactive.')
      endif
      if((iflag(5)/4).eq.1) write(stdout,170) def_depth*cm2m
 170  format(/5x,'   Level of no motion (m) = ',f10.4/)
      if(mod(iflag(5),4).gt.1) write(stdout,180) wbot_depth*cm2m
 180  format(/5x,'Bottom Steering depth (m) = ',f10.4/)
c
c  Reset NetCDF names of tracer variables as needed.
c
      call trc_names (ibiom)
c
c  Read in input file header or open input NetCDF file
c
      if(job.ne.3) then
        if(ifile.eq.0) then
          call opencdf(fname(3))
        elseif(ifile.eq.1) then
          call header_fm(hexinp)
        elseif(ifile.eq.2) then
          call header_qg(hexinp)
        else
          write(stdout,190) ifile
 190      format(/,' GET_PARM - illegal file type, IFILE = ',i2)
          call exitus('GET_PARM')
        endif
       else
        call head_unif
      endif
c
c  Read in coastal boundary mask and segments and create auxiliary
c  arrays.
c
      if(icoast.ne.0) then
        call set_land
      endif
c
c  Read in transport around islands and tranport along open segments.
c
      if(icoast.ne.0) then
        read(islinp,*) openseg
        read(islinp,*) nisland
        if(nisland.gt.0) then
          if(nisland.ne.nisle) then
            write(stdout,200) nisland,nisle
 200        format(/,'GET_PARM - inconsistent number of islands, ',
     *               'NISLAND, NISLE = ',2i2)
            call exitus('GET_PARM')
          else
            do 210 n=1,nisland
              read(islinp,*) icvalis(n),cvalis(n)
 210        continue
          endif
        endif
        if(openseg.eq.1.or.openseg.eq.2) then
          read(islinp,*) nopnseg
          do 220 n=1,nopnseg
            read(islinp,*) nptsopn(n)
            read(islinp,*) (cvalopn(i,n),i=1,nptsopn(n))
 220      continue
        endif
#ifdef trytrby
       elseif (usetrby) then
        read(islinp,*,iostat=ios) openseg
        usetrby = usetrby .and. (ios.eq.0)
        read(islinp,*,iostat=ios) nisland
        usetrby = usetrby .and. (ios.eq.0)
        read(islinp,*,iostat=ios) nopnseg
        usetrby = usetrby .and. (ios.eq.0) .and. (openseg.eq.2) .and.
     &            (nisland.eq.0) .and. (nopnseg.eq.1)
        if(usetrby) read(islinp,*,iostat=ios) nptsopn(1)
        usetrby = usetrby .and. (ios.eq.0) .and.
     &            (nptsopn(1).eq.2*(im+jm-2))
        if(usetrby)
     &    read(islinp,*,iostat=ios) (cvalopn(i,1),i=1,nptsopn(1))
        usetrby = usetrby .and. (ios.eq.0)
#endif
      endif
c
c  Report mean temperature and salinity to model levels.
c
      write(stdout,230)
 230  format (//,' Provided mean temperature and salinity:',/)
      do 250 k=1,nprof
        write(stdout,240) k,zm(k),tm(k),sm(k)
 240    format(i4,3f11.3)
 250  continue
c
      write(stdout,260)
 260  format(/,' PE model flags:',/)
      do 280 n=1,10
        write(stdout,270) n,iflag(n)
 270    format(' iflag(',i2,') = ',i3)
 280  continue
c
c  If applicable, set topography for flat case.
c
      if(iflag(7).eq.0) then
        do 300 j=1,jm
          do 290 i=1,im
            ip=i+(j-1)*im
            h(ip)=zbot
 290      continue
 300    continue
      endif
c
c  Set rotation parameters.
c
      pi=acos(cm1)
      radius=re*km2m*m2cm
      deg2rad=pi/c180
      omega=c2*pi*366.25/(c24*c3600*365.25)
      call xy2ll (p5*float(im+1),p5*float(jm+1),coord,im,jm,dx,dy,rlng0,
     *            rlat0,delx,dely,thetad,cenlon,cenlat)
      f0=c2*omega*sin(cenlat*deg2rad)
      beta=c2*omega*cos(cenlat*deg2rad)/radius
c
#ifdef sunflush
      call flush(stdout)
c
#endif
      return
      end
