      subroutine get_pbar (pifile,nx,ny,pbar)
c
c=======================================================================
c                                                                    ===
c  This routine reads the transport streamfunction.                  ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c   PIFILE   Name of PE_initial netCDF file.         (string)        ===
c   NX, NY   number of grid points in x & y dir.s.   (integer)       ===
c                                                                    ===
c   Common Blocks:                                                   ===
c                                                                    ===
c   /IOUNITS/                                                        ===
c                                                                    ===
c   STDOUT   standard output unit.                   (integer)       ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c   PBAR     Transport Streamfunction field.         (real array)    ===
c                                                                    ===
c         Calls:  EXITUS,    LENGTH                                  ===
c  NetCDF Calls:  NF_CLOSE,  NF_GET_VARA_REAL,  NF_INQ_VARID,        ===
c                 NF_OPEN                                            ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <netcdf.inc>
#include <iounits.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer ncid,nx,ny,sbgn,send,slen,status,varid
      integer count(3),start(3)
      real          pbar(np)
      character*(*) pifile
c
      data start /3*1/
      data count /3*1/
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Open PE_initial netCDF file.
c-----------------------------------------------------------------------
c
c  Determine length of PE_initial file name.
c
      call length (pifile,slen,sbgn,send)
c
      if (slen.lt.1) then
         write (stdout,900)
         call exitus ('GET_PBAR')
      end if
c
c  Open PE_initial netCDF file.
c
      status = nf_open (pifile(sbgn:send),NF_NOWRITE,ncid)
c
      if (status.ne.NF_NOERR) then
         write (stdout,910) 'open',pifile(sbgn:send)
         call exitus ('GET_PBAR')
      end if
c
c-----------------------------------------------------------------------
c  Read transport streamfunction.
c-----------------------------------------------------------------------
c
c  Read coordinate type.
c
      status = nf_inq_varid (ncid,'pbar',varid)
      if (status.ne.NF_NOERR) then
         write (stdout,920) 'find','pbar',pifile(sbgn:send)
         call exitus ('GET_PBAR')
      end if
c
      count(1) = nx
      count(2) = ny
c
      status = nf_get_vara_real (ncid,varid,start,count,pbar)
      if (status.ne.NF_NOERR) then
         write (stdout,920) 'read','pbar',pifile(sbgn:send)
         call exitus ('GET_PBAR')
      end if
c
c-----------------------------------------------------------------------
c  Close PE_initial netCDF file.
c-----------------------------------------------------------------------
c
      status = nf_close (ncid)
c
      if (status.ne.NF_NOERR) then
         write (stdout,910) 'close',pifile(sbgn:send)
         call exitus ('GET_PBAR')
      end if
c
      return
c
 900  format (/'***Error:  GET_PBAR - zero length name for PE_initial',
     &        ' netCDF file.')
 910  format (/'***Error:  GET_PBAR - unable to ',a,' PE_initial netCDF'
     &        ' file:'/11x,1h",a,1h")
 920  format (/'***Error:  GET_PBAR - unable to ',a,' variable ',1h",a,
     &        1h",' in PE_initial netCDF file:'/11x,1h",a,1h")
c
      end
