      subroutine get_trc(day)
c
c=======================================================================
c                                                                    ===
c  This routine reads in additonal tracers from hexadecimal tracer   ===
c  file (OA format).                                                 ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <curflds.h>
#include <iounits.h>
#include <moddat.h>
#include <ndimen.h>
#include <obserr.h>
#include <pefldid.h>
#include <switches.h>
#include <workspa.h>
#ifdef trcascii
# include <zdat.h>
#endif
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      logical first,reading
      integer iread,n
#ifndef trcascii
     &        ,imtrc,jmtrc,k,kmtrc
#else
     &        ,i,j
#endif
      real c0,c1,c180,day,eps,m2cm,tol
#ifndef trcascii
     &     ,dhort,dxdat,dydat,htt,pi,r1,r2,rladt,rlndt,theta,v0t,xbasint
      real ztrc(nz)
#endif
      parameter (c0=0.0,c1=1.0,c180=180.0,eps=1.1920929e-07,m2cm=100.0,
     &           tol=eps*(c1+eps))
      save first,iread
      data first /.true./
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
      if(first) then
        ifield=0
        level=0
        iread=0
        tsave=tstart
        first=.false.
#ifndef trcascii
c
c  Read in OA header.
c
        read(trcinp,*) imtrc,jmtrc,kmtrc,xbasint,dhort,v0t
        read(trcinp,*) rladt,rlndt,theta
        read(trcinp,*) htt,(ztrc(k),k=1,kmtrc)
c
c  Check domain parameters.
c
        xbasint=xbasint*dhort*m2cm
        ybasin=xbasint*float(jmtrc-1)/float(imtrc-1)
        dxdat=xbasint/float(imtrc-1)
        dydat=ybasin/float(jmtrc-1)
        pi = acos(-c1)
        theta = theta*c180/pi
c
        if (imtrc.ne.im) write(stdout,900) 'im',im,'im',imtrc
        if (jmtrc.ne.jm) write(stdout,900) 'jm',jm,'jm',jmtrc
        if ((im.ne.imtrc).or.(jm.ne.jmtrc)) call exitus ('GET_TRC')
c
        if (coord.ne.0)  write(stdout,910) 'coord',coord,'coord',0
        if (abs(dx-dxdat).gt.tol*abs(dx))
     *     write(stdout,920) 'dx',dx,'dx',dxdat
        if (abs(dy-dydat).gt.tol*abs(dy))
     *     write(stdout,920) 'dy',dy,'dy',dydat
        if (abs(rlat0-rladt).gt.tol*abs(rlat0))
     *     write(stdout,920) 'rlatd',rlat0,'rlatd',rladt
        if (abs(rlng0-rlndt).gt.tol*abs(rlng0))
     *     write(stdout,920) 'rlngd',rlng0,'rlngd',rlndt
        if (abs(thetad-theta).gt.tol*abs(thetad))
     *     write(stdout,920) 'thetad',thetad,'thetad',theta
        if(delx.ne.c0) write(stdout,920) 'delx',delx,'delx',c0
        if(dely.ne.c0) write(stdout,920) 'dely',dely,'dely',c0
#endif
      endif
c
c-----------------------------------------------------------------------
c  Read formatted hexadecimal fields.
c-----------------------------------------------------------------------
c
#ifndef fakebio
      dcur=tsave
      reading=.true.
      write(stdout,10) tsave
  10  format (/,' Reading Additional tracers at day = ',f12.4,/)
#endif
c
#ifndef trcascii
      do 40 while (reading.and.(iread.eq.0))
c
c  Load additonal tracers into their appropriate arrays.
c
        do 20 n = 3, nt
          if(ifield.eq.tid(n))    call save(f,t(1,level,n),nm)
          if(ifield.eq.toerid(n)) call save(f,toerr(1,level,n),nm)
  20    continue
c
c  Read in hexadecimal field.
c
  30    call xread(f,nm,tread,ifield,level,r1,r2,trcinp,iread)
c
c  Set DAY to just read time (in days).
c
        if(tread.lt.tsave) goto 30
        if(tread.ne.tsave) reading=.false.
  40  continue
#else
#ifndef fakebio
c I know how I wrote the fields
      do 20 n = 3,nt   
         do 30 i=1,im
            do 30 j=1,jm
               read(trcinp,*)(t(i+(j-1)*im,level,n),level=1,kfld)
 30      continue
 20   continue
c
csb read error fields for biological tracers
#ifdef readbioerr
       do 21 n = 3,nt   
         do 31 i=1,im
            do 31 j=1,jm
               read(trcinp,*)(toerr(i+(j-1)*im,level,n),level=1,kfld)
 31         continue
         ioscl(n+4)=0
         ioerr(n+4)=1
 21      continue
#endif
#endif
#endif
#ifndef fakebio
      day=tsave
      if(tskip.ne.c0) then
        tsave=dcur+tskip
      else
        tsave=tread
      endif
#endif
c
      return
c
 900  format (/' GET_TRC - Incompatible dimensions:'/11x,'GRIDS ',a,
     *       ' = ',i10/11x,'Data ',a,' = ',i10)
 910  format (/' GET_TRC - Unequal domain parameter, taking GRIDS ',
     *        'value'/11x,'GRIDS ',a,' = ',i10/11x,'Data ',a,' = ',i10)
 920  format (/' GET_TRC - Unequal domain parameter, taking GRIDS ',
     *        'value'/11x,'GRIDS ',a,' = ',1pg15.8/11x,'Data ',a,' = ',
     *                                                          1pg15.8)
c
      end
