      subroutine get_unif (day,iread)
c
c=======================================================================
c                                                                    ===
c  This routine reads in a single T,S profile (mean T,S format) and  ===
c  produces horizontally uniform fields.                             ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <curflds.h>
#include <iounits.h>
#include <moddat.h>
#include <ndimen.h>
#include <zdat.h>
#include <switches.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer ip,iread,k,m,i
      real    c0,day,m2cm,tsave
c
      parameter (c0=0.0, m2cm=100.0)
c
      data tsave /c0/
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Read in mean temperature and salinity profiles (mean stratification).
c-----------------------------------------------------------------------
c
      read(hexinp,*) kfld
      if(kfld.gt.nz) then
        write(stdout,30) 'KFLD, NZ = ',kfld,nz
        call exitus('GET_UNIF')
      endif
c
      do 10 k=1,kfld
cjad        read(hexinp,*) zfld(k),(t(1,k,i),i=1,nt)
         read(hexinp,*) zfld(k),(t(1,k,i),i=1,2)
         if((itrc.ge.1).and.(nt.gt.2)) then
cjad note:  these must be on same levels as ts file above
            read(trcinp,*) (t(1,k,i),i=3,nt)
         endif
        zfld(k) = zfld(k)*m2cm
  10  continue
c
      zbot = zfld(kfld)
c
      rewind (hexinp)
cjad not sure if I need this or not...
      if((itrc.ge.1).and.(nt.gt.2)) rewind (trcinp)
c
c-----------------------------------------------------------------------
c  Spread profile data horizontally.
c-----------------------------------------------------------------------
c
      do 20 m  = 1, nt
      do 20 k  = 1, kfld
      do 20 ip = 2, im*jm
         t(ip,k,m) = t(1,k,m)
 20   continue
c
c-----------------------------------------------------------------------
c  Set time management flags.
c-----------------------------------------------------------------------
c
c -- Set data time.
c
      if (tsave.eq.c0) then
         tsave = tstart
        else if (tskip.ne.c0) then
         tsave = tsave + tskip
        else
         tsave = tstop
      end if
c
      day = tsave
      dcur = day
c
c -- Set flags.
c
      if (day .lt. tstop) then
         iread = 0
        else
         iread = 1
      end if
c
      return
c
  30  format(/' GET_UNIF - underdimension arrays, ',a,i4,1x,i4)
c
      end
