      subroutine head_unif
c
c=======================================================================
c                                                                    ===
c  This routine reads in the depths from a single profile.  This is  ===
c  done for checking data spread.                                    ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <iounits.h>
#include <zdat.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer k
      real    m2cm,s,t
c
      parameter (m2cm=100.0)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Read in mean temperature and salinity profiles (mean stratification).
c-----------------------------------------------------------------------
c
      read(hexinp,*) kfld
      if(kfld.gt.nz) then
        write(stdout,20) 'KFLD, NZ = ',kfld,nz
        call exitus('HEAD_UNIF')
      endif
c
      do 10 k=1,kfld
        read(hexinp,*) zfld(k),t,s
        zfld(k) = zfld(k)*m2cm
  10  continue
c
      zbot = zfld(kfld)
c
      rewind (hexinp)
c
      return
c
  20  format(/' HEAD_UNIF - underdimension arrays, ',a,i4,1x,i4)
c
      end
