      subroutine header_fm(iunit)
c
c=======================================================================
c                                                                    ===
c  This routine reads in the header information from the FM type     ===
c  input file.  All dimensional quantities are converted to  CGS     ===
c  units.                                                            ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <iounits.h>
#include <moddat.h>
#include <ndimen.h>
#include <zdat.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer imdat,iunit,jmdat,k
      real c0,c1,cm2m,dxdat,dydat,eps,m2cm,p5,rladt,rlndt,thetdt,tol
      parameter (c0=0.0,c1=1.0,cm2m=0.01,eps=1.1920929e-07,m2cm=100.0,
     *           p5=0.5,tol=eps*(c1+eps))
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
      read(iunit,*) imdat,jmdat,kfld,xbasin,dhor,v0
      read(iunit,*) rladt,rlndt,thetdt
      read(iunit,*) ht,(hzfld(k),k=1,kfld)
c
      if (im.ne.imdat) write (stdout,910) 'im',im,'im',imdat
      if (jm.ne.jmdat) write (stdout,910) 'jm',jm,'jm',jmdat
      if ((im.ne.imdat).or.(jm.ne.jmdat)) call exitus('HEADER_FM')
c
c  Convert quantities to CGS units.
c
      ht=ht*m2cm
      dhor=dhor*m2cm
      v0=v0*m2cm
c
c  Set basin dimensions in centimeters.
c
      xbasin=xbasin*m2cm
      ybasin=xbasin*float(jm-1)/float(im-1)
      dxdat=xbasin/float(im-1)
      dydat=ybasin/float(jm-1)
c
      if(coord.ne.0) write(stdout,911) 'coord',coord,'coord',0
      if(abs(dx-dxdat).gt.tol*abs(dx))
     *  write(stdout,912) 'dx',dx,'dx',dxdat
      if(abs(dy-dydat).gt.tol*abs(dy))
     *  write(stdout,912) 'dy',dy,'dy',dydat
      if(abs(rlat0-rladt).gt.tol*abs(rlat0))
     *  write(stdout,912) 'rlatd',rlat0,'rlatd',rladt
      if(abs(rlng0-rlndt).gt.tol*abs(rlng0))
     *  write(stdout,912) 'rlngd',rlng0,'rlngd',rlndt
      if(abs(thetad-thetdt).gt.tol*abs(thetad))
     *  write(stdout,912) 'thetad',thetad,'thetad',thetdt
      if(delx.ne.c0) write(stdout,912) 'delx',delx,'delx',c0
      if(dely.ne.c0) write(stdout,912) 'dely',dely,'dely',c0
c
      write(stdout,10) im,jm,km,xbasin,ybasin,thetad,dx,dy,dhor,v0
  10  format(/,' Geometry parameters: ',/,
     *       /,'     im = ',i4,
     *       /,'     jm = ',i4,
     *       /,'     km = ',i4,
     *       /,' xbasin = ',e12.5,' (cm)',
     *       /,' ybasin = ',e12.5,' (cm)',
     *       /,' thetad = ',e12.5,
     *       /,'     dx = ',e12.5,' (cm)',
     *       /,'     dy = ',e12.5,' (cm)',
     *       /,'   dhor = ',e12.5,' (cm)',
     *       /,'     v0 = ',e12.5,' (cm/s)')
c
c  Get field depths in centimeters (get depths from thicknesses).
c
      if(ht.ne.0) then
        do 20 k=1,kfld
          hzfld(k)=anint(hzfld(k)*ht*cm2m)*m2cm
  20    continue
c
        write(stdout,30)
  30    format(/' Input field depths (m) and thicknesses (m):'/)
        zfld(1)=p5*hzfld(1)
        write(stdout,40) 1,zfld(1)*cm2m,hzfld(1)*cm2m
  40    format(i4,2f11.3)
        do 50 k=2,kfld
          zfld(k)=zfld(k-1)+p5*(hzfld(k-1)+hzfld(k))
          write (stdout,40) k,zfld(k)*cm2m,hzfld(k)*cm2m
  50    continue
        zbot=zfld(kfld)+p5*hzfld(kfld)
      else
c
c  The array HZFLD contains the depths (m) instead of the thicknesses.
c
        write(stdout,60)
  60    format(/' Input field depths (m)'/)
        do 70 k=1,kfld
          zfld(k)=hzfld(k)*m2cm
          write(stdout,40) k,zfld(k)*cm2m
  70    continue
        zbot=zfld(kfld)
      endif
      return
 910  format (/' HEADER_FM - Incompatible dimensions:'/11x,'GRIDS ',a,
     *       ' = ',i10/11x,'Data ',a,' = ',i10)
 911  format (/' HEADER_FM - Unequal domain parameter, taking GRIDS ',
     *        'value'/11x,'GRIDS ',a,' = ',i10/11x,'Data ',a,' = ',i10)
 912  format (/' HEADER_FM - Unequal domain parameter, taking GRIDS ',
     *        'value'/11x,'GRIDS ',a,' = ',1pg15.8/11x,'Data ',a,' = ',
     *                                                          1pg15.8)
      end
