      subroutine header_qg(iunit)
c
c=======================================================================
c                                                                    ===
c  This routine reads in the header information from the QG type     ===
c  input file.  All dimensional quantities are converted to  CGS     ===
c  units.                                                            ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <iounits.h>
#include <moddat.h>
#include <ndimen.h>
#include <zdat.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer ifbot,ifdiff,ifpert,ifrel,ifrst,iftop,iftvv,iltcnt,iltfrq,
     *        iltord,imdat,iunit,jmdat,k,m,n
      real alpha,c0,c1,c180,cm2m,dt,dxdat,dydat,eps,m2cm,p5,pi,rf,
     *     rhosur,rladt,rlndt,salsurf,scsig,theta,thetaqg,tmax,tol,
     *     tqgstart,tsurf
      real ainv(nz,nz),amat(nz,nz),eigval(nz),eta(nz+1),sigz(nz+1),
     *     xc(nz+1)
      character*4 restid(9),runid(6),titl(20,2)
      parameter (c0=0.0,c1=1.0,c180=180.0,cm2m=0.01,eps=1.1920929e-07,
     *           m2cm=100.0,p5=0.5,tol=eps*(c1+eps))
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
      read(iunit,10) runid,restid
  10  format(20a4)
      read(iunit,10) titl
      read(iunit,*) tqgstart,tmax,dt
      read(iunit,*) imdat,jmdat,kfld,xbasin,theta
      read(iunit,*) alpha,beta,rf
      read(iunit,*) iltord,iltfrq,iltcnt
      read(iunit,*) ifdiff,ifpert,ifrst,iftop,ifbot,iftvv,ifrel
      read(iunit,*) rladt,rlndt,t0,v0,dhor,ht,time0,r0
      read(iunit,*) (hzfld(k),k=1,kfld)
      read(iunit,*) rhosur,scsig,
     *              (sigz(k),k=1,kfld+1),
     *              (eigval(k),k=1,kfld),
     *              ((ainv(m,n),n=1,kfld),m=1,kfld),
     *              ((amat(m,n),n=1,kfld),m=1,kfld)
      read(iunit,*) tsurf,(xc(k),k=1,kfld+1)
      read(iunit,*) salsurf,(eta(k),k=1,kfld+1)
c
      if (im.ne.imdat) write (stdout,910) 'im',im,'im',imdat
      if (jm.ne.jmdat) write (stdout,910) 'jm',jm,'jm',jmdat
      if ((im.ne.imdat).or.(jm.ne.jmdat)) call exitus('HEADER_QG')
c
c  Convert quantities to CGS units.
c
      pi=acos(-1.)
      ht=ht*m2cm
      dhor=dhor*m2cm
      v0=v0*m2cm
      thetaqg=aint(p5+theta*c180/pi)
c
c  Set basin dimensions and grid spacing in centimeters.
c
      xbasin=xbasin*dhor
      ybasin=xbasin*float(jm-1)/float(im-1)
      dxdat=xbasin/float(im-1)
      dydat=ybasin/float(jm-1)
c
      if(coord.ne.0) write(stdout,911) 'coord',coord,'coord',0
      if(abs(dx-dxdat).gt.tol*abs(dx))
     *  write(stdout,912) 'dx',dx,'dx',dxdat
      if(abs(dy-dydat).gt.tol*abs(dy))
     *  write(stdout,912) 'dy',dy,'dy',dydat
      if(abs(rlat0-rladt).gt.tol*abs(rlat0))
     *  write(stdout,912) 'rlatd',rlat0,'rlatd',rladt
      if(abs(rlng0-rlndt).gt.tol*abs(rlng0))
     *  write(stdout,912) 'rlngd',rlng0,'rlngd',rlndt
      if(abs(thetad-thetaqg).gt.tol*abs(thetad))
     *  write(stdout,912) 'thetad',thetad,'thetaqg',thetaqg
      if(delx.ne.c0) write(stdout,912) 'delx',delx,'delx',c0
      if(dely.ne.c0) write(stdout,912) 'dely',dely,'dely',c0
c
      write(stdout,20) im,jm,km,xbasin,ybasin,thetad,dx,dy,dhor,v0
  20  format(/,' Geometry parameters: ',/,
     *       /,'     im = ',i4,
     *       /,'     jm = ',i4,
     *       /,'     km = ',i4,
     *       /,' xbasin = ',e12.5,' (cm)',
     *       /,' ybasin = ',e12.5,' (cm)',
     *       /,' thetad = ',e12.5,
     *       /,'     dx = ',e12.5,' (cm)',
     *       /,'     dy = ',e12.5,' (cm)',
     *       /,'   dhor = ',e12.5,' (cm)',
     *       /,'     v0 = ',e12.5,' (cm/s)')
c
c  Get field depths in centimeters.
c
      do 30 k=1,kfld
        hzfld(k)=anint(hzfld(k)*ht*cm2m)*m2cm
  30  continue
c
      write(stdout,40)
  40  format(/' Input field depths (m) and thicknesses (m):'/)
      zfld(1)=p5*hzfld(1)
      write(stdout,50) 1,zfld(1)*cm2m,hzfld(1)*cm2m
  50  format(i4,2f11.3)
      do 60 k=2,kfld
        zfld(k)=zfld(k-1)+p5*(hzfld(k-1)+hzfld(k))
        write(stdout,50) k,zfld(k)*cm2m,hzfld(k)*cm2m
  60  continue
      zbot=zfld(kfld)+p5*hzfld(kfld)
      return
 910  format (/' HEADER_QG - Incompatible dimensions:'/11x,'GRIDS ',a,
     *       ' = ',i10/11x,'Data ',a,' = ',i10)
 911  format (/' HEADER_QG - Unequal domain parameter, taking GRIDS ',
     *        'value'/11x,'GRIDS ',a,' = ',i10/11x,'Data ',a,' = ',i10)
 912  format (/' HEADER_QG - Unequal domain parameter, taking GRIDS ',
     *        'value'/11x,'GRIDS ',a,' = ',1pg15.8/11x,'Data ',a,' = ',
     *                                                          1pg15.8)
      end
