      subroutine headln (unit)
c
c=======================================================================
c                                                                    ===
c  This routine writes a date stamp header to an echo file.          ===
c                                                                    ===
c  On Input:                                                         ===
c                                                                    ===
c     UNIT   Unit number of the echo file.  (integer)                ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /VERSION/                                                         ===
c                                                                    ===
c     MODEL   The name of the model or code.  (character)            ===
c     VNUM    Version number.  (character)                           ===
c                                                                    ===
c  Calls:  GET_DATE, LNBLK                                           ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <version.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer lenstr,lnstr2,unit
      integer lnblk
      character*8  fmt
      character*44 date_str
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Write date stamp in echo file, if one can be created.
c-----------------------------------------------------------------------
c
      call get_date(date_str)
      lenstr=lnblk(date_str,len(date_str))
      if(lenstr.gt.0) then
        write (fmt,10) (80-lenstr)/2
        write (unit,fmt) date_str(1:lenstr)
      endif
c
c-----------------------------------------------------------------------
c  Write model name and version number.
c-----------------------------------------------------------------------
c
      lenstr=lnblk(model,len(model))
      lnstr2=lnblk(vnum,len(vnum))
      write (unit,20) model(1:lenstr),vnum(1:lnstr2)
c
      return
c
  10  format ('(/',i2,'x,a)')
  20  format (/a,',  Version ',a)
c
      end
