c
c=======================================================================
c  Include file "hybrid.h".
c=======================================================================
#ifndef rmdocinc
c
c  DBLSIGMA   switch to activate double "sigma" transformation
c             (integer): [0] no, [1] yes.
c  DEPTHMT    depths (cm) at the middle of the tracer boxes (real
c             array).
c  DEPTHMV    depths (cm) at the middle of the velocity boxes (real
c             array).
c  DZT        Thicknesses over T-grid.  (real; cm)
c  DZV        Thicknesses over V-grid.  (real; cm)
c  HAVG       average thickness (cm) of the hybrid levels (real).
c  HC         depth (cm) of the interface (real).
c  HV         bathymetry (cm) at the velocity points (real array).
c  HVZ        Total thickness over V-grid (real array; cm).
c  HZ         nominal vertical thicknesses (real array; cm).
c  KC         coordinate interface level (integer).
c  ZC1        minimum depth (cm) of coordinate interface (real).
c  ZC2        maximum depth (cm) of coordinate interface (real).
c  ZREF       reference depth (cm) for coordinate interface (real).
c  ZSLOPE     slope parameter of the coordinate interface (real).
c  ZPE        depths (cm) of the flat levels (real array).
c
c=======================================================================
#endif
c
      integer          dblsigma,kc
      common /ihybrid/ dblsigma,kc
c
      real havg,hc,zc1,zc2,zref,zslope
      real depthmt(np,nz),depthmv(np,nz),dzt(np,nz),dzv(np,nz),hv(np),
     &                 hvz(np),hz(nz),zpe(nz)
      common /fhybrid/ hc,havg,zc1,zc2,zref,zslope,zpe,hz,hv,hvz,
     &                 depthmt,depthmv,dzt,dzv
