      subroutine inside (x,y,xb,yb,nb,ind) 
c
c=======================================================================
c                                                                    === 
c  Given a point X,Y and the series XB(K),YB(K) (K=1...NB) defining  ===
c  vertices of a closed polygon. IND is set to 1 if the point is in  ===
c  the  polygon  and  0  if outside.   Each time a new set of bound  ===
c  points is introduced  IND  should be set to 999 on input.  It is  ===
c  best to do a series of Y for a single fixed X.                    ===
c                                                                    ===
c  METHOD: a count is made of the number of times the boundary cuts  ===
c  the meridian thru (X,Y) south of (X,Y).   an odd count indicates  ===
c  the point is inside , even indicates outside.                     ===
c  (See a long way from Euclid by Constance Reid,  p 174,            ===
c   Oceanography EMR, Oct/69).                                       ===
c                                                                    ===
c=======================================================================
c 
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer ind,k,ke,kp1,kw,nb,nc
      real xprev,x,y,slope
      real xb(nb),yb(nb),yc(200) 
      save xprev
      data xprev /0.0/
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      if(nb) 10,10,20 
  10  continue
      ind=1 
      return 
c
  20  continue
      if(ind-999) 30,40,30 
c
  30  continue
      if(x-xprev) 40,300,40 
c 
  40  continue
      xprev=x 
      nc=0 
      do 200 k=1,nb 
        kp1=k+1-k*(k/nb) 
        kw=k 
        if(xb(k)-xb(kp1)) 60,200,50 
  50    kw=kp1 
  60    ke=k+kp1-kw 
        if(x-xb(ke)) 80,90,200 
  80    if(x-xb(kw)) 200,200,90 
  90    nc=nc+1 
        slope=(yb(ke)-yb(kw))/(xb(ke)-xb(kw)) 
        yc(nc)=yb(kw)+(x-xb(kw))*slope 
 200  continue 
c 
 300  ind=0 
      if(nc) 340,340,310 
 310  do 330 k=1,nc 
        if(yc(k)-y) 320,330,330 
 320    ind=1-ind 
 330  continue 
 340  return 
      end 
