      subroutine interp(f,depth,zfld,kfld,intopt)
c
c=======================================================================
c                                                                    ===
c  This routine interpolates field F to hybrid coordinates. Linear   ===
c  or cubic spline interpolation is used.                            ===
c                                                                    ===
c     On input:                                                      ===
c                                                                    ===
c       DEPTH    the depth (cm) of each grid point in the hybrid     ===
c                coordinate system (real array)                      ===
c       F        the field in flat levels (real array)               ===
c       INTOPT   interpolation option (integer)                      ===
c                INTOPT = 0  linear interpolation                    ===
c                INTOPT = 1  cubic-spline interpolation              ===
c       KFLD     number of levels in the flat field (integer)        ===
c       ZFLD     the depths (cm) of flat levels (real array          ===
c                                                                    ===
c     On output:                                                     ===
c                                                                    ===
c       F        the interpolated field (real array)                 ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <ndimen.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,ip,j,k,intopt,kfld
      real    depth(np,nz),f(np,nz),fk(nz),frstder,wk(nz),zfld(*)
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
      do 40 j=1,jm
        do 30 i=1,im
          ip=i+(j-1)*im
          do 10 k=1,kfld
            fk(k)=f(ip,k)
  10      continue
          if(intopt.eq.1) call spline(zfld(1),fk,kfld,1.e+30,1.e+30,wk)
          do 20 k=1,km
            if(intopt.eq.1) then
              call splint(zfld,fk,wk,kfld,depth(ip,k),f(ip,k),frstder)
            else
              call lintrp(kfld,zfld,fk,1,depth(ip,k),f(ip,k))
            endif
  20      continue
  30    continue
  40  continue
c
      return
      end
