      subroutine intrp2d (f,kfld,depth,intopt,zsrf,fsrf)
c
c=======================================================================
c                                                                    ===
c  This routine interpolates field F to the given surface. Linear    ===
c  or cubic spline interpolation is used.                            ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c       DEPTH    the depth (cm) of the flat levels (real array) (nz) ===
c       F        the full volume field (real array)  (np by nz)      ===
c       INTOPT   interpolation option (integer)                      ===
c                INTOPT = 0  linear interpolation                    ===
c                INTOPT = 1  cubic-spline interpolation              ===
c       KFLD     the number of vertical data levels.                 ===
c       ZSRF     the depths (cm) of the inperpolating surface        ===
c                                                                    ===
c     Common Blocks:       (only relevent variables documented)      ===
c                                                                    ===
c     /NDIMEN/                                                       ===
c                                                                    ===
C       IM   Number of grid points in x direction.   (integer)       ===
C       JM   Number of grid points in y direction.   (integer)       ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c       FSRF      the interpolated field (real array)  (np)          ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     HOPS:  LINTRP,  SPLINE,  SPLINT                                ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <ndimen.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,ip,j,k,kfld,intopt
      real spval
      real depth(nz),f(np,nz),fk(nz),frstder,wk(nz),zsrf(np),
     &     fsrf(np)
c
      parameter (spval=1.0e30)
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
      do 40 j=1,jm
        do 30 i=1,im
          ip=i+(j-1)*im
          do 10 k=1,kfld
            fk(k)=f(ip,k)
  10      continue
          if(intopt.eq.1) call spline(depth,fk,kfld,spval,spval,wk)
          if(intopt.eq.1) then
            call splint(depth,fk,wk,kfld,zsrf(ip),fsrf(ip),frstder)
          else
            call lintrp(kfld,depth,fk,1,zsrf(ip),fsrf(ip))
          endif
  30    continue
  40  continue
c
      return
      end
