      subroutine intrp_pbar (lenopn,iopn,jopn,cpbar,popn)
c
c=======================================================================
c                                                                    ===
c  This routine interpolates the transport streamfunction boundary   ===
c  values along the specified segment.                               ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     CPBAR     Coarse transport Sfn field.          (real vector)   ===
c     LENOPN    Length of open boundary segment.     (integer)       ===
c     IOPN      X-indices of open segment.           (integer vector)===
c     JOPN      Y-indices of open segment.           (integer vector)===
c                                                                    ===
c   Common Blocks:                                                   ===
c                                                                    ===
c   /CRS_DOM/                                                        ===
c                                                                    ===
c     CCLN     Coarse transform centroid long.     (real)            ===
c     CCLT     Coarse transform centroid lat.      (real)            ===
c     CCRD     Coarse grid type.                   (integer)         ===
c     CDLX     Coarse grid x-offset.               (real)            ===
c     CDLY     Coarse grid y-offset.               (real)            ===
c     CDX      Coarse spacing in x-direction.      (real)            ===
c     CDY      Coarse spacing in y-direction.      (real)            ===
c     CICST    Coarse coastline x-components.      (integer array)   ===
c     CJCST    Coarse coastline y-components.      (integer array)   ===
c     CLANDP   Coarse transport Sfn mask.          (integer vector)  ===
c     CNCST    Number of coastlines in coarse.     (integer)         ===
c     CNX      Number of coarse points in x-dir.   (integer)         ===
c     CNY      Number of coarse points in y-dir.   (integer)         ===
c     CTHTA    Coarse rotation angle (WRT East).   (real)            ===
c                                                                    ===
c   /FNE_DOM/                                                        ===
c                                                                    ===
c     FCLN     Fine transform centroid long.     (real)              ===
c     FCLT     Fine transform centroid lat.      (real)              ===
c     FCRD     Fine grid type.                   (integer)           ===
c     FDLX     Fine grid x-offset.               (real)              ===
c     FDLY     Fine grid y-offset.               (real)              ===
c     FDX      Fine spacing in x-direction.      (real)              ===
c     FDY      Fine spacing in y-direction.      (real)              ===
c     FNX      Number of fine points in x-dir.   (integer)           ===
c     FNY      Number of fine points in y-dir.   (integer)           ===
c     FTHTA    Fine rotation angle (WRT East).   (real)              ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     POPN      Transport Sfn at open seg.           (real vector)   ===
c                                                                    ===
c   Common Blocks:                                                   ===
c                                                                    ===
c  Calls:  BESS2D_PMSK,  LL2XY,  XY2LL                               ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <crs_dom.h>
#include <fne_dom.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer lenopn,n,ix,iy
      integer iopn(mpseg),jopn(mpseg)
      real    lon,lat,x,y
      real    cpbar(np),popn(mpseg)
      real    bess2d_pmsk
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Interpolate coarse grid transport streamfunction to fine grid segment.
c-----------------------------------------------------------------------
c
      do 10 n = 1, lenopn
c
c  Convert fine grid location to coarse grid location.
c
         call xy2ll (float(iopn(n)),float(jopn(n)),fcrd,fnx,fny,
     &               fdx,fdy,fcln,fclt,fdlx,fdly,fthta,lon,lat)
c
         call ll2xy (lon,lat,ccrd,cnx,cny,
     &               cdx,cdy,ccln,cclt,cdlx,cdly,cthta,x,y)
c
c  Compute corresponding indices.
c
         ix = int(x)
         x  = x - float(ix)
c
         iy = int(y)
         y  = y - float(iy)
c
c  Interpolate transport streamfunction
c
         popn(n) = bess2d_pmsk (ix,iy,x,y,cpbar,clandp,cnx,cny,0,cncst,
     &                          mpseg,cicst,cjcst,1.0e35)
c
  10  continue
c
      return
      end
