      function isincrs (nnbhr,nbhrs)
c
c=======================================================================
c                                                                    ===
c  This function determines if a fine grid point is contained within ===
c  the coarse grid land mask by testing its coarse grid neighbors.   ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     NNBHR     Number of coarse neighbors.          (integer)       ===
c     NBHRS     Values of neighboring coarse mask.   (integer vector)===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     ISINCRS   Flag for fine point in coarse mask.  (logical)       ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     none                                                           ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer n,nnbhr
      integer nbhrs(4)
      logical testval
      logical isincrs
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  All neighbors must have same value and that value must be land.
c-----------------------------------------------------------------------
c
      testval = nbhrs(1) .gt. 0
c
      do 10 n = 2, nnbhr
         testval = testval .and. (nbhrs(n).eq.nbhrs(1))
  10  continue
c
      isincrs = testval
c
      return
      end
