      subroutine length (string,slen,bgn,end)
c
c=======================================================================
c                                                                    ===
c  This subroutine determines the length of a character string       ===
c  exclusive of any leading or trailing blanks.                      ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     STRING...String to be examined.                  (character)   ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     BGN......Position of first nonblank character.   (integer)     ===
c     END......Position of last nonblank character.    (integer)     ===
c     SLEN.....Number of characters in string.         (integer)     ===
c                                                                    ===
c  Calls:  none                                                      ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer     bgn,end,slen
      character*1   space,tab
      character*(*) string
c
      parameter (space = ' ', tab='	')
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Initialize beginning and ending pointers for the search.
c-----------------------------------------------------------------------
c
      end = len(string)
      bgn = 1
c
c-----------------------------------------------------------------------
c  Search for first nonblank character.
c-----------------------------------------------------------------------
c
      do 10 while ( (bgn.lt.end) .and. ((string(bgn:bgn).eq.tab) .or.
     &                                     (string(bgn:bgn).eq.space)) )
         bgn = bgn + 1
 10   continue
c
      if ((string(bgn:bgn).eq.space).or.(string(bgn:bgn).eq.tab))
     &   bgn = bgn + 1
c
c-----------------------------------------------------------------------
c  Search for last nonblank character.
c-----------------------------------------------------------------------
c
      do 20 while ( (end.gt.1) .and. ((string(end:end).eq.tab) .or.
     &                                     (string(end:end).eq.space)) )
         end = end - 1
 20   continue
c
      if ((string(end:end).eq.space).or.(string(end:end).eq.tab))
     &   end = end - 1
c
c-----------------------------------------------------------------------
c  Determine length exclusive of leading & trailing blanks.
c-----------------------------------------------------------------------
c
      if (end .ge. bgn) then
         slen = end - bgn + 1
        else
         slen = 0
      end if
c
      return
      end
