      subroutine ll2xy (lon,lat,coord,nx,ny,gridx,gridy,rlngd,rlatd,
     *                 delx,dely,thetad,x,y)
c
c=======================================================================
c                                                                    ===
c  This routine computes the grid coordinates from the given         ===
c  longitude and latitude.                                           ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c  LON, LAT  the longitude and latitude of the point   (real; deg)   ===
c  COORD     flag for coordinate type                  (integer)     ===
c               [0]  cartesian (tangent plane) grid.                 ===
c               [1]  unrotated spherical grid.                       ===
c               [2]  rotated spherical grid.                         ===
c  DELX,                                                             ===
c  DELY      Offset from transformation point to                     ===
c            grid center.                              (real; cm|deg)===
c  NX, NY    number of grid points in x & y directions (integer)     ===
c  GRIDX     grid spacing in x-direction               (real; cm|deg)===
c  GRIDY     grid spacing in y-direction               (real; cm|deg)===
c  RLNGD     longitude at center of grid               (real; deg)   ===
c  RLATD     latitude at center of grid                (real; deg)   ===
c  THETAD    angle grid is rotated with respect to east (real; deg)  ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c  X, Y      the corresponding grid coordinates        (real)        ===
c                                                                    ===
c  Calls:  ROTPARM                                                   ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      logical new
      integer coord,coordo,nx,ny,nxo,nyo
      real a,c0,c1,c2pi,c180,c360,cm1,cm360,cos1,cosl,cosp,cterm,
     *     deg2rad,delx,delxo,dely,delyo,dlat,dlon,f1x,f1y,f2x,f2y,gdxo,
     *     gdyo,gridx,gridy,lat,lon,p5,pi,plat,plon,rad2deg,re,re_d2r,
     *     rlat,rlatd,rlato,rlon,rlngd,rlngo,rnlon,sin1,sinl,sinp,
     *     sterm,thetad,thetao,x,xc,y,yc
      real lon_chk
      parameter (c0=0.0,c1=1.0,c180=180.0,c360=360.0,cm1=-1.0,
     *           p5=0.5,pi=3.14159 26535 89793 23846,re=637131500.0)
      parameter (cm360=cm1*c360,deg2rad=pi/c180,rad2deg=c180/pi,
     *           re_d2r=re*deg2rad,c2pi=pi+pi)
c
      save coordo,cosp,cterm,delxo,delyo,f1x,f1y,f2x,f2y,gdxo,gdyo,nxo,
     *     nyo,plat,plon,rlato,rlngo,rnlon,sinp,sterm,thetao,xc,yc
c
      data coordo,nxo,nyo /3*0/
      data delxo,delyo,gdxo,gdyo,rlato,rlngo,thetao /7*c0/
c
c-----------------------------------------------------------------------
c  Longitude range check function.
c-----------------------------------------------------------------------
c
      lon_chk(a)=sign(c1,a)*
     *           (mod(abs(a),c2pi)-c2pi*int(mod(abs(a),c2pi)/pi))
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c Determine if working with a new coordinate system.
c-----------------------------------------------------------------------
c
      new = (nx.ne.nxo).or.(ny.ne.nyo).or.(thetad.ne.thetao).or.
     *      (rlatd.ne.rlato).or.(rlngd.ne.rlngo).or.(gridx.ne.gdxo).or.
     *      (gridy.ne.gdyo).or.(coord.ne.coordo).or.(delx.ne.delxo).or.
     *         (dely.ne.delyo)
      if (new) then
        coordo = coord
        delxo  = delx
        delyo  = dely
        gdxo   = gridx
        gdyo   = gridy
        nxo    = nx
        nyo    = ny
        rlato  = rlatd
        rlngo  = rlngd
        thetao = thetad
      endif
c
c-----------------------------------------------------------------------
c  Cartesian (tangent plane) system.
c-----------------------------------------------------------------------
c
      if (coord.eq.0) then
        if (new) then
          f1x   = re_d2r/gridx
          f1y   = re_d2r/gridy
          f2x   = f1x*cos(rlatd*deg2rad)
          f2y   = f1y*cos(rlatd*deg2rad)
          sterm = sin(thetad*deg2rad)
          cterm = cos(thetad*deg2rad)
          xc    = p5*float(nx+1)-delx/gridx
          yc    = p5*float(ny+1)-dely/gridy
        endif
        dlat = lat-rlatd
        dlon = lon-rlngd
        x    = xc+f1x*dlat*sterm+f2x*dlon*cterm
        y    = yc+f1y*dlat*cterm-f2y*dlon*sterm
c
c-----------------------------------------------------------------------
c  Unrotated Spherical system.
c-----------------------------------------------------------------------
c
      elseif (coord.eq.1) then
        if (new) then
          xc = p5*float(nx+1)-delx/gridx
          yc = p5*float(ny+1)-dely/gridy
        endif
        x    = xc+lon/gridx
        y    = yc+lat/gridy
c
c-----------------------------------------------------------------------
c  Rotated spherical system.
c-----------------------------------------------------------------------
c
      elseif (coord.eq.2) then
        if (new) then
          call rotparm (rlngd*deg2rad,rlatd*deg2rad,thetad*deg2rad,plat,
     *                  plon,rnlon)
          xc   = p5*float(nx+1)-delx/gridx
          yc   = p5*float(ny+1)-dely/gridy
          cosp = cos(plat)
          sinp = sin(plat)
        endif
        cosl = cos(lat*deg2rad)
        sinl = sin(lat*deg2rad)
        rlat = asin(sinl*sinp+cosl*cosp*cos(lon*deg2rad-plon))
        sin1 = cosl*sin(lon*deg2rad-plon)
        cos1 = sinl*cosp-sinp*cosl*cos(lon*deg2rad-plon)
        rlon = rnlon-atan2(sin1,cos1)
        rlon = lon_chk(rlon)
        rlon = rlon*rad2deg
        rlat = rlat*rad2deg
        x    = xc+rlon/gridx
        y    = yc+rlat/gridy
      endif
c
      return
      end
