      subroutine mktby_data (gcrsfil,gfnefil,pifile,pbar)
c
c=======================================================================
c                                                                    ===
c  This routine extracts the raw data needed to extract transport    ===
c  streamfunction boundary conditions.                               ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     GCRSFIL   Coarse GRIDS netCDF filename.        (string)        ===
c     GFNEFIL   Fine GRIDS netCDF filename.          (string)        ===
c     PIFILE    Coarse PE_INITIAL netCDF filename.   (string)        ===
c                                                                    ===
c   Common Blocks:                                                   ===
c                                                                    ===
c   /IOUNITS/                                                        ===
c                                                                    ===
c     STDOUT     standard output unit.                (integer)      ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     PBAR      Coarse transport Sfn field.          (real vector)   ===
c                                                                    ===
c   Common Blocks:                                                   ===
c                                                                    ===
c   /CRS_DOM/                                                        ===
c                                                                    ===
c     CCLN     Coarse transform centroid long.     (real)            ===
c     CCLT     Coarse transform centroid lat.      (real)            ===
c     CCRD     Coarse grid type.                   (integer)         ===
c     CDLX     Coarse grid x-offset.               (real)            ===
c     CDLY     Coarse grid y-offset.               (real)            ===
c     CDX      Coarse spacing in x-direction.      (real)            ===
c     CDY      Coarse spacing in y-direction.      (real)            ===
c     CICST    Coarse coastline x-components.      (integer array)   ===
c     CJCST    Coarse coastline y-components.      (integer array)   ===
c     CLANDP   Coarse transport Sfn mask.          (integer vector)  ===
c     CLNCST   Lengths of coastlines, coarse.      (integer vector)  ===
c     CNCST    Number of coastlines in coarse.     (integer)         ===
c     CNISL    Number of islands in coarse grid.   (integer)         ===
c     CNX      Number of coarse points in x-dir.   (integer)         ===
c     CNY      Number of coarse points in y-dir.   (integer)         ===
c     CTHTA    Coarse rotation angle (WRT East).   (real)            ===
c                                                                    ===
c   /FNE_DOM/                                                        ===
c                                                                    ===
c     FCLN     Fine transform centroid long.     (real)              ===
c     FCLT     Fine transform centroid lat.      (real)              ===
c     FCRD     Fine grid type.                   (integer)           ===
c     FDLX     Fine grid x-offset.               (real)              ===
c     FDLY     Fine grid y-offset.               (real)              ===
c     FDX      Fine spacing in x-direction.      (real)              ===
c     FDY      Fine spacing in y-direction.      (real)              ===
c     FICST    Fine coastline x-components.      (integer array)     ===
c     FJCST    Fine coastline y-components.      (integer array)     ===
c     FLANDP   Fine transport Sfn mask.          (integer vector)    ===
c     FLNCST   Lengths of coastlines, fine.      (integer vector)    ===
c     FNCST    Number of coastlines in fine.     (integer)           ===
c     FNISL    Number of islands in fine grid.   (integer)           ===
c     FNX      Number of fine points in x-dir.   (integer)           ===
c     FNY      Number of fine points in y-dir.   (integer)           ===
c     FTHTA    Fine rotation angle (WRT East).   (real)              ===
c                                                                    ===
c  Calls:  GET_DOM,  GET_PBAR,  SET_PMASK                            ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <crs_dom.h>
#include <fne_dom.h>
#include <iounits.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer landt(np)
      real          pbar(np)
      character*(*) gcrsfil,gfnefil,pifile
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Get coarse grid data.
c-----------------------------------------------------------------------
c
c  Read coarse grid parameters.
c
      call get_dom (gcrsfil,ccrd,cnx,cny,cdx,cdy,ccln,cclt,cdlx,cdly,
     &                    cthta,cncst,cnisl,clncst,cicst,cjcst,landt)
c
c  Set transport streamfunction mask.
c
      if (cncst.gt.0) then
         call set_pmask (cnx,cny,cncst,clncst,cicst,cjcst,landt,
     &                   clandp)
      end if
c
c-----------------------------------------------------------------------
c  Get fine grid data.
c-----------------------------------------------------------------------
c
      call get_dom (gfnefil,fcrd,fnx,fny,fdx,fdy,fcln,fclt,fdlx,fdly,
     &                    fthta,fncst,fnisl,flncst,ficst,fjcst,landt)
c
c  Set transport streamfunction mask.
c
      if (fncst.gt.0) then
         call set_pmask (fnx,fny,fncst,flncst,ficst,fjcst,landt,
     &                   flandp)
      end if
c
c-----------------------------------------------------------------------
c  Get coarse transport streamfunction data.
c-----------------------------------------------------------------------
c
      call get_pbar (pifile,cnx,cny,pbar)
c
      return
      end
