      subroutine mktby_parm (gcrsfil,gfnefil,pifile,trnsfile)
c
c=======================================================================
c                                                                    ===
c  This routine reads the job control parameters.                    ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c   Common Blocks:                                                   ===
c                                                                    ===
c   /IOUNITS/                                                        ===
c                                                                    ===
c     STDINP     standard input unit.                 (integer)      ===
c     STDOUT     standard output unit.                (integer)      ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     GCRSFIL    Coarse GRIDS netCDF filename.        (string)       ===
c     GFNEFIL    Fine GRIDS netCDF filename.          (string)       ===
c     PIFILE     Coarse PE_INITIAL netCDF filename.   (string)       ===
c     TRNSFILE   Name of output  file.                (string)       ===
c                                                                    ===
c  Calls:  EXITUS                                                    ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <iounits.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer       ios
      character*(*) gcrsfil,gfnefil,pifile,trnsfile
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Get file names.
c-----------------------------------------------------------------------
c
c  Read coarse grid file name.
c
      read (stdinp,10,iostat=ios) gcrsfil
      if (ios.ne.0) then
         write (stdout,900) 'coarse GRIDS',ios
         call exitus ('MKTBY_PARM')
      end if
c
c  Read fine grid file name.
c
      read (stdinp,10) gfnefil
      if (ios.ne.0) then
         write (stdout,900) 'fine GRIDS',ios
         call exitus ('MKTBY_PARM')
      end if
c
c  Read coarse pe_initial file name.
c
      read (stdinp,10) pifile
      if (ios.ne.0) then
         write (stdout,900) 'coarse PE_initial',ios
         call exitus ('MKTBY_PARM')
      end if
c
c  Read output fine transport streamfunction boundary condition file name.
c
      read (stdinp,10) trnsfile
      if (ios.ne.0) then
         write (stdout,900) 'output boundary condition',ios
         call exitus ('MKTBY_PARM')
      end if
c
      return
c
  10  format (a)
 900  format (/'***Error:  MKTBY_PARM - unable to read ',a,' file name.'
     &        /11x,'Error status flag = ',i10)
c
      end
