      subroutine op(im,jm,yxmrat,xymrat,guess,residue,xr,ipt)
c
c=======================================================================
c                                                                    ===
c  This routine is called successively by CGPOIS to compute the      ===
c  residual of the solution of  Poisson  equation via conjugate      ===
c  gradient method.  The  finite  difference  stencil has  five      ===
c  five (+ or x) points.                                             ===
c                                                                    ===
c  On Input:                                                         ===
c                                                                    ===
c     IM      number of points in the x-direction (integer).         ===
c     JM      number of points in the y-direction (integer).         ===
c     YXMRAT  the ratio of the y-metric terms over the x-metric      ===
c             terms:                                                 ===
c             IPT=0 -> XYMRAT(i,j) evaluated at (i+1/2, j).          ===
c             IPT=1 -> XYMRAT(i,j) evaluated at (i+1/2, j+1/2).      ===
c     XYMRAT  the ratio of the x-metric terms over the y-metric      ===
c             terms:                                                 ===
c             IPT=0 -> XYMRAT(i,j) evaluated at (i, j+1/2).          ===
c             IPT=1 -> XYMRAT(i,j) evaluated at (i+1/2, j+1/2).      ===
c     GUESS   current guess solution (real array).                   ===
c     XR      forcing field (interior and boundary conditions)       ===
c             (real array).                                          ===
c     IPT     type of finite differences stencil for the forcing     ===
c             field (integer):                                       ===
c             [0] five point PLUS  (+) Laplacian.                    ===
c             [1] five point TIMES (x) Laplacian.                    ===
c                                                                    ===
c  On Ouput:                                                         ===
c                                                                    ===
c     RESIDUE current solution residual                              ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,im,ipt,j,jm
      real p25,val
      real guess(im,jm),residue(im,jm),xr(im,jm),xymrat(im,jm),
     *     yxmrat(im,jm)
      parameter (p25=0.25)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Five point, PLUS (+) stencil.
c-----------------------------------------------------------------------
c
      if(ipt.eq.0) then
c
c  Compute residual at the interior points.
c
        do 20 j=3,jm-2
          do 10 i=3,im-2
            val=(yxmrat(i  ,j  )*(guess(i+1,j  )-guess(i,j))+
     *           yxmrat(i-1,j  )*(guess(i-1,j  )-guess(i,j)))
     *         +(xymrat(i  ,j  )*(guess(i  ,j+1)-guess(i,j))+
     *           xymrat(i  ,j-1)*(guess(i  ,j-1)-guess(i,j)))
            residue(i,j)=val-xr(i,j)
  10      continue
  20    continue
c
c  Compute residual near the southern and northern boundaries.
c
        j=2
        do 30 i=3,im-2
          val=(yxmrat(i  ,j  )*(guess(i+1,j  )-guess(i,j))+
     *         yxmrat(i-1,j  )*(guess(i-1,j  )-guess(i,j)))
     *       +(xymrat(i  ,j  )*(guess(i  ,j+1)-guess(i,j))+
     *         xymrat(i  ,j-1)*(xr   (i  ,j-1)-guess(i,j)))
          residue(i,j)=val-xr(i,j)
  30    continue
        j=jm-1
        do 40 i=3,im-2
          val=(yxmrat(i  ,j  )*(guess(i+1,j  )-guess(i,j))+
     *         yxmrat(i-1,j  )*(guess(i-1,j  )-guess(i,j)))
     *       +(xymrat(i  ,j  )*(xr   (i  ,j+1)-guess(i,j))+
     *         xymrat(i  ,j-1)*(guess(i  ,j-1)-guess(i,j)))
          residue(i,j)=val-xr(i,j)
  40    continue
c
c  Compute residual near the western and eastern boundaries.
c
        i=2
        do 50 j=3,jm-2
          val=(yxmrat(i  ,j  )*(guess(i+1,j  )-guess(i,j))+
     *         yxmrat(i-1,j  )*(xr   (i-1,j  )-guess(i,j)))
     *       +(xymrat(i  ,j  )*(guess(i  ,j+1)-guess(i,j))+
     *         xymrat(i  ,j-1)*(guess(i  ,j-1)-guess(i,j)))
          residue(i,j)=val-xr(i,j)
  50    continue
        i=im-1
        do 60 j=3,jm-2
          val=(yxmrat(i  ,j  )*(xr   (i+1,j  )-guess(i,j))+
     *         yxmrat(i-1,j  )*(guess(i-1,j  )-guess(i,j)))
     *       +(xymrat(i  ,j  )*(guess(i  ,j+1)-guess(i,j))+
     *         xymrat(i  ,j-1)*(guess(i  ,j-1)-guess(i,j)))
          residue(i,j)=val-xr(i,j)
  60    continue
c
c  Compute residual at the corners.
c
        i=2
        j=2
        val=(yxmrat(i  ,j  )*(guess(i+1,j  )-guess(i,j))+
     *       yxmrat(i-1,j  )*(xr   (i-1,j  )-guess(i,j)))
     *     +(xymrat(i  ,j  )*(guess(i  ,j+1)-guess(i,j))+
     *       xymrat(i  ,j-1)*(xr   (i  ,j-1)-guess(i,j)))
        residue(i,j)=val-xr(i,j)
        i=2
        j=jm-1
        val=(yxmrat(i  ,j  )*(guess(i+1,j  )-guess(i,j))+
     *       yxmrat(i-1,j  )*(xr   (i-1,j  )-guess(i,j)))
     *     +(xymrat(i  ,j  )*(xr   (i  ,j+1)-guess(i,j))+
     *       xymrat(i  ,j-1)*(guess(i  ,j-1)-guess(i,j)))
        residue(i,j)=val-xr(i,j)
        i=im-1
        j=2
        val=(yxmrat(i  ,j  )*(xr   (i+1,j  )-guess(i,j))+
     *       yxmrat(i-1,j  )*(guess(i-1,j  )-guess(i,j)))
     *     +(xymrat(i  ,j  )*(guess(i  ,j+1)-guess(i,j))+
     *       xymrat(i  ,j-1)*(xr   (i  ,j-1)-guess(i,j)))
        residue(i,j)=val-xr(i,j)
        i=im-1
        j=jm-1
        val=(yxmrat(i  ,j  )*(xr   (i+1,j  )-guess(i,j))+
     *       yxmrat(i-1,j  )*(guess(i-1,j  )-guess(i,j)))
     *     +(xymrat(i  ,j  )*(xr   (i  ,j+1)-guess(i,j))+
     *       xymrat(i  ,j-1)*(guess(i  ,j-1)-guess(i,j)))
        residue(i,j)=val-xr(i,j)
c
c-----------------------------------------------------------------------
c  Five point, TIMES (X) stencil.
c-----------------------------------------------------------------------
c
      elseif(ipt.eq.1) then
c
c  Compute residual at the interior points.
c
        do 80 j=3,jm-2
          do 70 i=3,im-2
            val=p25*(yxmrat(i  ,j  )*((guess(i+1,j+1)-guess(i  ,j+1))+
     *                                (guess(i+1,j  )-guess(i  ,j  )))
     *              -yxmrat(i-1,j  )*((guess(i  ,j+1)-guess(i-1,j+1))+
     *                                (guess(i  ,j  )-guess(i-1,j  ))))
     *         +p25*(yxmrat(i  ,j-1)*((guess(i+1,j  )-guess(i  ,j  ))+
     *                                (guess(i+1,j-1)-guess(i  ,j-1)))
     *              -yxmrat(i-1,j-1)*((guess(i  ,j  )-guess(i-1,j  ))+
     *                                (guess(i  ,j-1)-guess(i-1,j-1))))
     *         +p25*(xymrat(i  ,j  )*((guess(i+1,j+1)-guess(i+1,j  ))+
     *                                (guess(i  ,j+1)-guess(i  ,j  )))
     *              -xymrat(i  ,j-1)*((guess(i+1,j  )-guess(i+1,j-1))+
     *                                (guess(i  ,j  )-guess(i  ,j-1))))
     *         +p25*(xymrat(i-1,j  )*((guess(i  ,j+1)-guess(i  ,j  ))+
     *                                (guess(i-1,j+1)-guess(i-1,j  )))
     *              -xymrat(i-1,j-1)*((guess(i  ,j  )-guess(i  ,j-1))+
     *                                (guess(i-1,j  )-guess(i-1,j-1))))
            residue(i,j)=val-xr(i,j)
  70      continue
  80    continue
c
c  Compute residual near the southern and northern boundaries.
c
        j=2
        do 90 i=3,im-2
          val=p25*(yxmrat(i  ,j  )*((guess(i+1,j+1)-guess(i  ,j+1))+
     *                              (guess(i+1,j  )-guess(i  ,j  )))
     *            -yxmrat(i-1,j  )*((guess(i  ,j+1)-guess(i-1,j+1))+
     *                              (guess(i  ,j  )-guess(i-1,j  ))))
     *       +p25*(yxmrat(i  ,j-1)*((guess(i+1,j  )-guess(i  ,j  ))+
     *                              (xr   (i+1,j-1)-xr   (i  ,j-1)))
     *            -yxmrat(i-1,j-1)*((guess(i  ,j  )-guess(i-1,j  ))+
     *                              (xr   (i  ,j-1)-xr   (i-1,j-1))))
     *       +p25*(xymrat(i  ,j  )*((guess(i+1,j+1)-guess(i+1,j  ))+
     *                              (guess(i  ,j+1)-guess(i  ,j  )))
     *            -xymrat(i  ,j-1)*((guess(i+1,j  )-xr   (i+1,j-1))+
     *                              (guess(i  ,j  )-xr   (i  ,j-1))))
     *       +p25*(xymrat(i-1,j  )*((guess(i  ,j+1)-guess(i  ,j  ))+
     *                              (guess(i-1,j+1)-guess(i-1,j  )))
     *            -xymrat(i-1,j-1)*((guess(i  ,j  )-xr   (i  ,j-1))+
     *                              (guess(i-1,j  )-xr   (i-1,j-1))))
          residue(i,j)=val-xr(i,j)
  90    continue
c
        j=jm-1
        do 100 i=3,im-2
          val=p25*(yxmrat(i  ,j  )*((xr   (i+1,j+1)-xr   (i  ,j+1))+
     *                              (guess(i+1,j  )-guess(i  ,j  )))
     *            -yxmrat(i-1,j  )*((xr   (i  ,j+1)-xr   (i-1,j+1))+
     *                              (guess(i  ,j  )-guess(i-1,j  ))))
     *       +p25*(yxmrat(i  ,j-1)*((guess(i+1,j  )-guess(i  ,j  ))+
     *                              (guess(i+1,j-1)-guess(i  ,j-1)))
     *            -yxmrat(i-1,j-1)*((guess(i  ,j  )-guess(i-1,j  ))+
     *                              (guess(i  ,j-1)-guess(i-1,j-1))))
     *       +p25*(xymrat(i  ,j  )*((xr   (i+1,j+1)-guess(i+1,j  ))+
     *                              (xr   (i  ,j+1)-guess(i  ,j  )))
     *            -xymrat(i  ,j-1)*((guess(i+1,j  )-guess(i+1,j-1))+
     *                              (guess(i  ,j  )-guess(i  ,j-1))))
     *       +p25*(xymrat(i-1,j  )*((xr   (i  ,j+1)-guess(i  ,j  ))+
     *                              (xr   (i-1,j+1)-guess(i-1,j  )))
     *            -xymrat(i-1,j-1)*((guess(i  ,j  )-guess(i  ,j-1))+
     *                              (guess(i-1,j  )-guess(i-1,j-1))))
          residue(i,j)=val-xr(i,j)
 100    continue
c
c  Compute residual near the western and eastern boundaries.
c
        i=2
        do 110 j=3,jm-2
          val=p25*(yxmrat(i  ,j  )*((guess(i+1,j+1)-guess(i  ,j+1))+
     *                              (guess(i+1,j  )-guess(i  ,j  )))
     *            -yxmrat(i-1,j  )*((guess(i  ,j+1)-xr   (i-1,j+1))+
     *                              (guess(i  ,j  )-xr   (i-1,j  ))))
     *       +p25*(yxmrat(i  ,j-1)*((guess(i+1,j  )-guess(i  ,j  ))+
     *                              (guess(i+1,j-1)-guess(i  ,j-1)))
     *            -yxmrat(i-1,j-1)*((guess(i  ,j  )-xr   (i-1,j  ))+
     *                              (guess(i  ,j-1)-xr   (i-1,j-1))))
     *       +p25*(xymrat(i  ,j  )*((guess(i+1,j+1)-guess(i+1,j  ))+
     *                              (guess(i  ,j+1)-guess(i  ,j  )))
     *            -xymrat(i  ,j-1)*((guess(i+1,j  )-guess(i+1,j-1))+
     *                              (guess(i  ,j  )-guess(i  ,j-1))))
     *       +p25*(xymrat(i-1,j  )*((guess(i  ,j+1)-guess(i  ,j  ))+
     *                              (xr   (i-1,j+1)-xr   (i-1,j  )))
     *            -xymrat(i-1,j-1)*((guess(i  ,j  )-guess(i  ,j-1))+
     *                              (xr   (i-1,j  )-xr   (i-1,j-1))))
          residue(i,j)=val-xr(i,j)
 110    continue
c
        i=im-1
        do 120 j=3,jm-2
          val=p25*(yxmrat(i  ,j  )*((xr   (i+1,j+1)-guess(i  ,j+1))+
     *                              (xr   (i+1,j  )-guess(i  ,j  )))
     *            -yxmrat(i-1,j  )*((guess(i  ,j+1)-guess(i-1,j+1))+
     *                              (guess(i  ,j  )-guess(i-1,j  ))))
     *       +p25*(yxmrat(i  ,j-1)*((xr   (i+1,j  )-guess(i  ,j  ))+
     *                              (xr   (i+1,j-1)-guess(i  ,j-1)))
     *            -yxmrat(i-1,j-1)*((guess(i  ,j  )-guess(i-1,j  ))+
     *                              (guess(i  ,j-1)-guess(i-1,j-1))))
     *       +p25*(xymrat(i  ,j  )*((xr   (i+1,j+1)-xr   (i+1,j  ))+
     *                              (guess(i  ,j+1)-guess(i  ,j  )))
     *            -xymrat(i  ,j-1)*((xr   (i+1,j  )-xr   (i+1,j-1))+
     *                              (guess(i  ,j  )-guess(i  ,j-1))))
     *       +p25*(xymrat(i-1,j  )*((guess(i  ,j+1)-guess(i  ,j  ))+
     *                              (guess(i-1,j+1)-guess(i-1,j  )))
     *            -xymrat(i-1,j-1)*((guess(i  ,j  )-guess(i  ,j-1))+
     *                              (guess(i-1,j  )-guess(i-1,j-1))))
          residue(i,j)=val-xr(i,j)
 120    continue
c
c  Compute residual at the corners.
c
        i=2
        j=2
        val=p25*(yxmrat(i  ,j  )*((guess(i+1,j+1)-guess(i  ,j+1))+
     *                            (guess(i+1,j  )-guess(i  ,j  )))
     *          -yxmrat(i-1,j  )*((guess(i  ,j+1)-xr   (i-1,j+1))+
     *                            (guess(i  ,j  )-xr   (i-1,j  ))))
     *     +p25*(yxmrat(i  ,j-1)*((guess(i+1,j  )-guess(i  ,j  ))+
     *                            (xr   (i+1,j-1)-xr   (i  ,j-1)))
     *          -yxmrat(i-1,j-1)*((guess(i  ,j  )-xr   (i-1,j  ))+
     *                            (xr   (i  ,j-1)-xr   (i-1,j-1))))
     *     +p25*(xymrat(i  ,j  )*((guess(i+1,j+1)-guess(i+1,j  ))+
     *                            (guess(i  ,j+1)-guess(i  ,j  )))
     *          -xymrat(i  ,j-1)*((guess(i+1,j  )-xr   (i+1,j-1))+
     *                            (guess(i  ,j  )-xr   (i  ,j-1))))
     *     +p25*(xymrat(i-1,j  )*((guess(i  ,j+1)-guess(i  ,j  ))+
     *                            (xr   (i-1,j+1)-xr   (i-1,j  )))
     *          -xymrat(i-1,j-1)*((guess(i  ,j  )-xr   (i  ,j-1))+
     *                            (xr   (i-1,j  )-xr   (i-1,j-1))))
        residue(i,j)=val-xr(i,j)
c
        i=2
        j=jm-1
        val=p25*(yxmrat(i  ,j  )*((xr   (i+1,j+1)-xr   (i  ,j+1))+
     *                            (guess(i+1,j  )-guess(i  ,j  )))
     *          -yxmrat(i-1,j  )*((xr   (i  ,j+1)-xr   (i-1,j+1))+
     *                            (guess(i  ,j  )-xr   (i-1,j  ))))
     *     +p25*(yxmrat(i  ,j-1)*((guess(i+1,j  )-guess(i  ,j  ))+
     *                            (guess(i+1,j-1)-guess(i  ,j-1)))
     *          -yxmrat(i-1,j-1)*((guess(i  ,j  )-xr   (i-1,j  ))+
     *                            (guess(i  ,j-1)-xr   (i-1,j-1))))
     *     +p25*(xymrat(i  ,j  )*((xr   (i+1,j+1)-guess(i+1,j  ))+
     *                            (xr   (i  ,j+1)-guess(i  ,j  )))
     *          -xymrat(i  ,j-1)*((guess(i+1,j  )-guess(i+1,j-1))+
     *                            (guess(i  ,j  )-guess(i  ,j-1))))
     *     +p25*(xymrat(i-1,j  )*((xr   (i  ,j+1)-guess(i  ,j  ))+
     *                            (xr   (i-1,j+1)-xr   (i-1,j  )))
     *          -xymrat(i-1,j-1)*((guess(i  ,j  )-guess(i  ,j-1))+
     *                            (xr   (i-1,j  )-xr   (i-1,j-1))))
        residue(i,j)=val-xr(i,j)
c
        i=im-1
        j=2
        val=p25*(yxmrat(i  ,j  )*((xr   (i+1,j+1)-guess(i  ,j+1))+
     *                            (xr   (i+1,j  )-guess(i  ,j  )))
     *          -yxmrat(i-1,j  )*((guess(i  ,j+1)-guess(i-1,j+1))+
     *                            (guess(i  ,j  )-guess(i-1,j  ))))
     *     +p25*(yxmrat(i  ,j-1)*((xr   (i+1,j  )-guess(i  ,j  ))+
     *                            (xr   (i+1,j-1)-xr   (i  ,j-1)))
     *          -yxmrat(i-1,j-1)*((guess(i  ,j  )-guess(i-1,j  ))+
     *                            (xr   (i  ,j-1)-xr   (i-1,j-1))))
     *     +p25*(xymrat(i  ,j  )*((xr   (i+1,j+1)-xr   (i+1,j  ))+
     *                            (guess(i  ,j+1)-guess(i  ,j  )))
     *          -xymrat(i  ,j-1)*((xr   (i+1,j  )-xr   (i+1,j-1))+
     *                            (guess(i  ,j  )-xr   (i  ,j-1))))
     *     +p25*(xymrat(i-1,j  )*((guess(i  ,j+1)-guess(i  ,j  ))+
     *                            (guess(i-1,j+1)-guess(i-1,j  )))
     *          -xymrat(i-1,j-1)*((guess(i  ,j  )-xr   (i  ,j-1))+
     *                            (guess(i-1,j  )-xr   (i-1,j-1))))
        residue(i,j)=val-xr(i,j)
c
        i=im-1
        j=jm-1
        val=p25*(yxmrat(i  ,j  )*((xr   (i+1,j+1)-xr   (i  ,j+1))+
     *                            (xr   (i+1,j  )-guess(i  ,j  )))
     *          -yxmrat(i-1,j  )*((xr   (i  ,j+1)-xr   (i-1,j+1))+
     *                            (guess(i  ,j  )-guess(i-1,j  ))))
     *     +p25*(yxmrat(i  ,j-1)*((xr   (i+1,j  )-guess(i  ,j  ))+
     *                            (xr   (i+1,j-1)-guess(i  ,j-1)))
     *          -yxmrat(i-1,j-1)*((guess(i  ,j  )-guess(i-1,j  ))+
     *                            (guess(i  ,j-1)-guess(i-1,j-1))))
     *     +p25*(xymrat(i  ,j  )*((xr   (i+1,j+1)-xr   (i+1,j  ))+
     *                            (xr   (i  ,j+1)-guess(i  ,j  )))
     *          -xymrat(i  ,j-1)*((xr   (i+1,j  )-xr   (i+1,j-1))+
     *                            (guess(i  ,j  )-guess(i  ,j-1))))
     *     +p25*(xymrat(i-1,j  )*((xr   (i  ,j+1)-guess(i  ,j  ))+
     *                            (xr   (i-1,j+1)-guess(i-1,j  )))
     *          -xymrat(i-1,j-1)*((guess(i  ,j  )-guess(i  ,j-1))+
     *                            (guess(i-1,j  )-guess(i-1,j-1))))
        residue(i,j)=val-xr(i,j)
      endif
      return
      end
