c
c=======================================================================
c  Include file "pconst.h".
c=======================================================================
#ifndef rmdocinc
c
c  Rules for parameter constants:
c
c  *  Use prefix of "c" for whole real numbers (c1 for 1.0).
c  *  Use "m" after prefix to designate negative values (cm1 for -1.0).
c  *  Use prefix of "p" for non repeating fractions (p5 for 0.5).
c  *  Use prefix of "r" for reciprocals (r3 for 1.0/3.0).
c  *  Combine use of prefix above and "e" for scientific notation (c1e4
c     for 1.0e+4, c1em4 for 1.0e-4).
c
c=======================================================================
#endif
c
      integer tgrid,vgrid,zgrid
      parameter (tgrid=0,vgrid=1,zgrid=2)
c
      real 
     *      c0,c1,c2,c3,c4,c5,c6,c8,c9,c10,c12,c24,c27,c100,c180,
     *      c1000,
     *      c3600,c12000,c86400,c1e6,c1e30,c1e35,c1em2,c1em3,c1em4,
     *      c1em8,
     *      c1em9,c1em10,c1em12,c1em15,c1em20,c1em30,c1em35,c9p9e29,
     *      c2r3,c3r2,cm1,cm2,cm10,mp5,p5,p25,r3,r6,r16,r24
      real
     *      avogadro,cm2m,cm2tom2,cm3tom3,day2sec,deg2rad,earthrot,
     *      m2cm,pi,rad2deg,re,root2,sec2day
      parameter (c0=0.0,c1=1.0,c2=2.0,c3=3.0,c4=4.0,c5=5.0,c6=6.0,
     *           c8=8.0,c9=9.0,c10=10.0,c12=12.0,c24=24.0,c27=27.0,
     *           c100=100.0,
     *           c180=180.0,c1000=1000.0,c3600=3600.0,c12000=12000.0,
     *           c86400=86400.0,
     *           c1e6=1.0e+6,c1e30=1.0e+30,c1e35=1.0e+35,c1em2=1.0e-2,
     *           c1em3=1.0e-3,c1em4=1.0e-4,c1em8=1.0e-8,c1em9=1.0e-9,
     *           c1em10=1.0e-10,c1em12=1.0e-12,c1em15=1.0e-15,
     *           c1em20=1.0e-20,c1em30=1.0e-30,c1em35=1.0e-35,
     *           c9p9e29=9.9e+29,avogadro=6.022e23,cm2tom2=1.0e-4,
     *           cm3tom3=1.0e-6,p5=0.5,
     *           p25=0.25,r6=c1/6.0,r16=c1/16.0,r24=c1/24.0,
     *           pi=3.14159 26535 89793 23846,re=637131500.0,
     *           root2=1.41421 35623 73095 04880)
      parameter (c2r3=c2/c3,c3r2=c3/c2,cm1=-c1,cm2=-c2,cm10=-c10,
     *           cm2m=c1/c100,day2sec=c86400,deg2rad=pi/c180,
     *           earthrot=c2*pi*366.25/365.25/c86400,m2cm=c100,
     *           mp5=-p5,r3=c1/c3,rad2deg=c180/pi,sec2day=c1/c86400)
