c
c=======================================================================
c  Include file "pefldid.h".
c=======================================================================
c
#ifndef rmdocinc
c  PE fields classification:
c
c   PEBATH  bottom topography at the tracer points (m).
c   PEBTHT  depth of each tracer point (m).
c   PEBTHV  depth of each velocity point (m).
c   PEBUOY  buoyancy work (gigaWatts)
c   PEBVOR  rate of change of barotropic vorticity.
c   PECDEN  density anomaly computed from PE temperature and salinity.
c   PEDANO  PE density anomaly (sigma-1000) g/cm^3.
c   PEDBAR  mean PE density anomaly (sigma-1000) g/cm^3.
c   PEEMAG  external mode, velocity vectors maginitude (cm/s).
c   PEEVEC  external mode, velocity vectors (cm/s).
c   PEGMAG  internal mode, geostrophic velocity vector magnitude (cm/s).
c   PEGVEC  internal mode, geostrophic velocity vectors (cm/s).
c   PEHSTA  hydrographic cruise track stations.
c   PEIMAG  internal mode, velocity vector magnitude (cm/s).
c   PEIVEC  internal mode, velocity vectors (cm/s).
c   PEKETS  time rate of change of KE.
c   PEKET1  time rate of change of KE due to pressure term.
c   PEKET2  time rate of change of KE due to zonal advection.
c   PEKET3  time rate of change of KE due to meridional advection.
c   PEKET4  time rate of change of KE due to vertical advection.
c   PEKET5  time rate of change of KE due to zonal diffusion.
c   PEKET6  time rate of change of KE due to meridional diffudion.
c   PEKET7  time rate of change of KE due to vertical diffusion.
c   PEKET8  time rate of change of KE due to Coriolis term.
c   PELTRK  Lagrangian drifter trajectories.
c   PEMLDH  mixed-layer depth (meter).
c   PENH4p  NH4 production rate (umoles/l/s).
c   PENO3p  NO3 production rate (umoles/l/s).
c   PEPBAR  barotropic transport streamfunction (cm^3/s).
c   PEPFER  forecast error for transport streamfunction.
c   PEPOER  observation error for transport streamfunction.
c   PERCBV  rate of change of barotropic vorticity at the boundaries.
c   PESALT  salinity (PSS).
c   PESFER  forecast error for salinity.
c   PESHFX  surface (net) heat flux (W/m^2).
c   PESIGT  sigma-t (kg/m^3).
c   PESMFM  wind stress vector magnitude (dynes/cm^2).
c   PESMFV  wind stress vectors (dynes/cm^2).
c   PESMFX  meridional wind stress (dynes/cm^2).
c   PESMFY  zonal wind stress (dynes/cm^2).
c   PESNDS  sound speed (m/s).
c   PESOER  observation error for salinity.
c   PESRAD  shortwave radiation (W/m^2).
c   PESWFX  surface water flux, E-P (cm/day).
c   PETEKE  total kinetic energy (petaJoules).
c   PETEMP  temperature (deg C).
c   PETFER  forecast error for temperature.
c   PETOER  observation error for temperature.
c   PETMAG  total velocity vector magnitude (cm/s).
c   PETMSK  land/sea mask at tracer points.
c   PETVEC  total velocity vectors (cm/s).
#ifdef bioDuse
c   PETRC3  tracer 3 quantity. (temp/salt are 1 and 2)
c   PETRC4  tracer 4 quantity.
c   PETRC5  tracer 5 quantity.
c   PETRC6  tracer 6 quantity.
c   PETRC7  tracer 7 quantity.
c   PETRC8  tracer 8 quantity.
c   PETRC9  tracer 9 quantity.
c   PET3FE  forecast error tracer 3
c   PET3OE  observation error tracer 3
c   PET4FE  forecast error tracer 4
c   PET4OE  observation error tracer 4
c   PET5FE  forecast error tracer 5
c   PET5OE  observation error tracer 5
c   PET6FE  forecast error tracer 6
c   PET6OE  observation error tracer 6
c   PET7FE  forecast error tracer 7
c   PET7OE  observation error tracer 7
c   PET8FE  forecast error tracer 8
c   PET8OE  observation error tracer 8
c   PET9FE  forecast error tracer 9
c   PET9OE  observation error tracer 9
#else
c   PETRC1  phytoplankton concentration (umoles/l).
c   PETRC2  zooplankton concentration (umoles/l).
c   PETRC3  nitrate concentration (umoles/l).
c   PETRC4  ammonium concentration (umoles/l).
c   PETRC5  detritus concentration (umoles/l).
c   PET1FE  forecast error for tracer 1.
c   PET1OE  observation error for tracer 1.
c   PET2FE  forecast error for tracer 2.
c   PET2OE  observation error for tracer 2.
c   PET3FE  forecast error for tracer 3.
c   PET3OE  observation error for tracer 3.
c   PET4FE  forecast error for tracer 4.
c   PET4OE  observation error for tracer 4.
c   PET5FE  forecast error for tracer 5.
c   PET5OE  observation error for tracer 5.
#endif
c   PEUBAR  external mode, zonal velocity (cm/s).
c   PEUFER  forecast error for internal mode zonal velocity.
c   PEUGEO  internal mode, zonal geostrophic velocity (cm/s).
c   PEUHAT  internal mode, zonal velocity (cm/s).
c   PEUOER  observation error for internal mode zonal velocity.
c   PEUTOT  total zonal velocity (cm/s).
c   PEUBAR  external mode, meridional velocity (cm/s).
c   PEVFER  forecast error for internal mode meridional velocity.
c   PEVGEO  internal mode, meridional geostrophic velocity (cm/s).
c   PEVHAT  internal mode, meridional velocity (cm/s).
c   PEVMSK  land/sea mask at tracer points.
c   PEVOER  observation error for internal mode meridional velocity.
c   PEVTOT  total meridional velocity (cm/s).
c   PEWVST  vertical "omega" velocity at tracer points (cm/s).
c   PEWVSV  vertical "omega" velocity at velocity points (cm/s).
c   PEWVZT  vertical "flat" velocity at tracer points (cm/s).
c   PEWVZV  vertical "flat" velocity at velocity points (cm/s).
c   PEZOOG  zooplankton grazing rate (umoles/l/s).
c   TFERID  vector of tracer forecast error IDs.
c   TID     vector of tracer IDs.
c   TOERID  vector of tracer observation error IDs.
c
c=======================================================================
c
#endif
      integer pebath,pebtht,pebthv,pebuoy,pebvor,pecden,pedano,pedbar,
     *        peemag,peevec,pegmag,pegvec,pehsta,peimag,peivec,pekets,
     *        peket1,peket2,peket3,peket4,peket5,peket6,peket7,peket8,
     *        peltrk,pemldh,penh4p,peno3p,pepbar,pepoer,pepfer,percbv,
     *        pesalt,pesfer,peshfx,pesigt,pesmfm,pesmfv,pesmfx,pesmfy,
     *        pesnds,pesoer,pesrad,peswfx,peteke,petemp,petfer,petmag,
     *        petmsk,petoer,petvec,peubar,peufer,peugeo,peuhat,peuoer,
     *        peutot,pevbar,pevfer,pevgeo,pevhat,pevmsk,pevoer,pevtot,
     *        pewvst,pewvsv,pewvzt,pewvzv,pezoog
#ifdef bioDuse
      integer petrc3,petrc4,petrc5,petrc6,petrc7,petrc8,petrc9,
     *        pet3fe,pet4fe,pet5fe,pet6fe,pet7fe,pet8fe,pet9fe,
     *        pet3oe,pet4oe,pet5oe,pet6oe,pet7oe,pet8oe,pet9oe
#else
      integer petrc1,petrc2,petrc3,petrc4,petrc5,
     *        pet1fe,pet1oe,pet2fe,pet2oe,pet3fe,pet3oe,pet4fe,pet4oe,
     *        pet5fe,pet5oe
#endif
      parameter (pebath=9  ,pebtht=53 ,pebthv=54 ,pebuoy=20 ,pebvor=27 ,
     *           pecden=71 ,pedano=8  ,pedbar=28 ,peemag=56 ,peevec=55 ,
     *           pegmag=15 ,pegvec=16 ,pehsta=19 ,peimag=14 ,peivec=13 ,
     *           pekets=40 ,peket1=41 ,peket2=42 ,peket3=43 ,peket4=44 ,
     *           peket5=45 ,peket6=46 ,peket7=47 ,peket8=48 ,peltrk=18 ,
     *           pemldh=29 ,penh4p=35 ,peno3p=36 ,pepbar=4  ,pepfer=204,
     *           pepoer=104,percbv=17 ,pesalt=6  ,pesfer=206,peshfx=81 ,
     *           pesigt=12 ,pesmfm=82 ,pesmfv=83 ,pesmfx=84 ,pesmfy=85 ,
     *           pesnds=63 ,pesoer=106,pesrad=86 ,peswfx=87 ,peteke=39 ,
     *           petemp=5  ,petfer=205,petmag=11 ,petmsk=50 ,petoer=105,
     *           petvec=10 ,peubar=57 ,peufer=201,peugeo=23 ,peuhat=21 ,
     *           peuoer=101,peutot=1  ,pevbar=58 ,pevfer=202,pevgeo=24 ,
     *           pevhat=22 ,pevmsk=51 ,pevoer=102,pevtot=2  ,pewvst=3  ,
     *           pewvsv=7  ,pewvzt=25 ,pewvzv=26 ,pezoog=37 )
#ifdef bioDuse
      parameter (petrc3=120,petrc4=121,petrc5=122,petrc6=123,petrc7=124,
     *           petrc8=125,petrc9=126,
     *           pet3fe=220,pet4fe=221,pet5fe=222,pet6fe=223,pet7fe=224,
     *           pet8fe=225,pet9fe=226,
     *           pet3oe=320,pet4oe=321,pet5oe=322,pet6oe=323,pet7oe=324,
     *           pet8oe=325,pet9oe=326)
#else
      parameter (petrc1=30 ,petrc2=31 ,petrc3=32 ,petrc4=33 ,petrc5=34 ,
     *           pet1fe=207,pet1oe=107,pet2fe=208,pet2oe=108,
     *           pet3fe=209,pet3oe=109,pet4fe=210,pet4oe=110,pet5fe=211,
     *           pet5oe=111)
#endif
c
#ifdef bioDuse
      integer          tid(9),toerid(9),tferid(9)
#else
      integer          tid(7),toerid(7),tferid(7)
#endif
      common /pefldid/ tid,toerid,tferid
