      subroutine psibar
c
c=======================================================================
c                                                                    ===
c  This routine computes verticaly integrated (flat topography)      ===
c  transport from geostrophic streamfunction.                        ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <curflds.h>
#include <hybrid.h>
#include <ndimen.h>
#include <moddat.h>
#include <switches.h>
#include <zdat.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer imjm,ip,k
      real    c0,c1,c2,pavg,scle
#ifdef gridold
      real       dz(np),psig(np)
#else
      real       psig(np)
#endif
      parameter (c0=0.0,c1=1.0,c2=2.0)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Integrate dynamic height to get transport streamfunction.
c-----------------------------------------------------------------------
c
c  Start mid-point integration at surface.
c
      scle=v0*dhor
      imjm=im*jm
c
      call intrp2d (psi,kfld,zfld,intopt,depthmt(1,1),psig)
      do 10 ip = 1, imjm
#ifdef gridold
         dz(ip)   = c2*depthmt(ip,1)
         pbar(ip) = scle*dz(ip)*psig(ip)
#else
         pbar(ip) = scle*dzt(ip,1)*psig(ip)
#endif
  10  continue
c
c  Continue mid-point integration on streamfunction.
c
      do 30 k = 2, km
         call intrp2d (psi,kfld,zfld,intopt,depthmt(1,k),psig)
         do 20 ip=1,imjm
#ifdef gridold
            dz(ip)   = c2*(depthmt(ip,k)-depthmt(ip,k-1)) - dz(ip)
            pbar(ip) = pbar(ip) + scle*dz(ip)*psig(ip)
#else
            pbar(ip) = pbar(ip) + scle*dzt(ip,k)*psig(ip)
#endif
  20     continue
  30  continue
c
c-----------------------------------------------------------------------
c  Remove the horizontal mean from the transport streamfunction.
c-----------------------------------------------------------------------
c
c  Compute the mean.
c
      pavg=c0
      scle=c1/float(imjm)
c
      do 40 ip=1,imjm
         pavg=pavg+pbar(ip)*scle
  40  continue
c
c  Remove the mean.
c
      do 50 ip=1,imjm
         pbar(ip)=pbar(ip)-pavg
  50  continue
c
      return
      end
