      function psibavg (im,jm,psib,dx,metx,dy,mety)
c
c=======================================================================
c  This function computes the average value of the transport         ===
c  streamfunction along the outer boundary.                          ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     IM     Grid size in x-direction.   (integer)                   ===
c     JM     Grid size in y-direction.   (integer)                   ===
c     PSIB   Transport streamfunction.   (cm^3/s; real array)        ===
c     DX     X-grid spacing.             (cm or degrees; real)       ===
c     METX   Metric factors for dx.      (none or cm/deg; real array)===
c     DY     Y-grid spacing.             (cm or degrees; real)       ===
c     METY   Metric factors for dx.      (none or cm/deg; real array)===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     PSIBAVG   Average value of transport                           ===
c               streamfunction along outer boundary.  (cm^3/s;  real)===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local variables
c-----------------------------------------------------------------------
c
      integer i,im,j,jm
      real    c0,dlen,dx,dy,metx(im,jm),mety(im,jm),p5,psib(im,jm),
     &        psibavg,tot_len
c
      parameter (c0=0.0, p5=0.5)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Initialize average value and total length around boundary.
c-----------------------------------------------------------------------
c
      psibavg = c0
      tot_len = c0
c
c-----------------------------------------------------------------------
c  Add contributions along Southern and Northern boundaries.
c-----------------------------------------------------------------------
c
      do 10 i = 1, im-1
c
         dlen = dx*(metx(i,1)+metx(i+1,1))*p5
         tot_len = tot_len + dlen
         psibavg =  psibavg + p5*(psib(i,1)+psib(i+1,1))*dlen
c
         dlen = dx*(metx(i,jm)+metx(i+1,jm))
         tot_len = tot_len + dlen
         psibavg = psibavg + p5*(psib(i,jm)+psib(i+1,jm))*dlen
c
 10   continue
c
c-----------------------------------------------------------------------
c  Add contributions along Western and Eastern boundaries.
c-----------------------------------------------------------------------
c
      do 20 j = 1, jm-1
c
         dlen = p5*dy*(mety(1,j)+mety(1,j+1))
         tot_len = tot_len + dlen      
         psibavg = psibavg + p5*(psib(1,j)+psib(1,j+1))*dlen
c
         dlen = p5*dy*(mety(im,j)+mety(im,j+1))
         tot_len = tot_len + dlen
         psibavg = psibavg + p5*(psib(im,j)+psib(im,j+1))*dlen
c
 20   continue
c
c-----------------------------------------------------------------------
c  Average is integrated value divided by total length.
c-----------------------------------------------------------------------
c
      psibavg = psibavg/tot_len
c
      return
      end
