      subroutine psibdy (ubaro,vbaro)
c
c=======================================================================
c     This routine makes an initial guess for the boundary conditions===
c     along the open boundaries.                                     ===
c                                                                    ===
c  Input:                                                            ===
c                                                                    ===
c  UBARO, VBARO...Chosen barotropic velocities. (cm/s)  (real arrays)===
c                                                                    ===
c  Common Blocks:        (only relevent variables documented)        ===
c                                                                    ===
c  /CSTSEG/                                                          ===
c                                                                    ===
c    LANDT........Land mask at tracer points.  (input; integer array)===
c                                                                    ===
c  /CURFLDS/                                                         ===
c                                                                    ===
c    PBAR.........Vertically integrated streamfunction, reset on     ===
c                 outer boundary.   (output; real array)             ===
c                                                                    ===
c  /GRDDAT/                                                          ===
c                                                                    ===
c    TMETX........X-coordinate metric coefficients at velocity grid  ===
c                   (input; real array; cm)                          ===
c    TMETY........Y-coordinate metric coefficients at velocity grid  ===
c                   (input; real array; cm)                          ===
c                                                                    ===
c  /HYBRID/                                                          ===
c                                                                    ===
c    HV...........Bottom depth at velocity points.  (cm)             ===
c                   (input; real array)                              ===
c                                                                    ===
c  /IOUNITS/                                                         ===
c                                                                    ===
c    STDOUT.......Standard output unit.  (input; integer)            ===
c                                                                    ===
c  /MODDAT/                                                          ===
c                                                                    ===
c    DX, DY.......Grid spacings.  (cm)  (input; real)                ===
c                                                                    ===
c  /NDIMEN/                                                          ===
c                                                                    ===
c    IM, JM, KM...Number of grid points in x, y and z directions.    ===
c                   (input; integers)                                ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <cstseg.h>
#include <curflds.h>
#include <grddat.h>
#include <hybrid.h>
#include <iounits.h>
#include <moddat.h>
#include <ndimen.h>
#include <switches.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer   bndysz
      real      c0,p5,small
      parameter (bndysz=4*mx, c0=0.0, p5=0.5, small=1.0e-35)
c
      integer i,ibnd,ip,j
      real    atot,pbavg0,pbavg1,tot,val,veldiff
      real    abtrns(bndysz),trnspt(bndysz),ubaro(np),vbaro(np)
      real    psibavg
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c        
c-----------------------------------------------------------------------
c     Compute average value of streamfunction along boundary.
c     Keep track of length around outer boundary for correction.
c-----------------------------------------------------------------------
c
      if(mod(iflag(5),2).eq.1) then
c
         pbavg0 = psibavg (im,jm,pbar,dx,tmetx,dy,tmety)
c
c-----------------------------------------------------------------------
c     First pass, set boundary values to get desired normal velocity.
c-----------------------------------------------------------------------
c
         ip       = im
         ibnd     = 0
         pbar(ip) = pbavg0
         atot     = c0
         tot      = c0
c
c  East.
c
         do 10 j = 2, jm
            ip   = j*im
            ibnd = ibnd + 1
            if((landt(ip)*landt(ip-im)).gt.0) then
              trnspt(ibnd) = - ubaro(ip-1-im)*hv(ip-1-im)*
     &                         p5*dy*(tmety(ip)+tmety(ip-im))
             else
              trnspt(ibnd) = c0
            end if
            abtrns(ibnd) = abs(trnspt(ibnd))
            pbar(ip)     = pbar(ip-im) + trnspt(ibnd)
            tot          = tot + trnspt(ibnd)
            atot         = atot + abtrns(ibnd)
 10      continue
c
c  North.
c
         do 20 i = im-1, 1, -1
            ip = i + (jm-1)*im
            ibnd = ibnd + 1
            if((landt(ip)*landt(ip+1)).gt.0) then
              trnspt(ibnd) = - vbaro(ip-im)*hv(ip-im)*
     &                         p5*dx*(tmetx(ip)+tmetx(ip+1))
             else
              trnspt(ibnd) = c0
            end if
            abtrns(ibnd) = abs(trnspt(ibnd))
            pbar(ip)     = pbar(ip+1) + trnspt(ibnd)
            tot          = tot + trnspt(ibnd)
            atot         = atot + abtrns(ibnd)
 20      continue
c
c  West.
c
         do 30 j = jm-1, 1, -1
            ip = 1 + (j-1)*im
            ibnd = ibnd + 1
            if((landt(ip)*landt(ip+im)).gt.0) then
              trnspt(ibnd) = ubaro(ip)*hv(ip)*
     &                       p5*dy*(tmety(ip)+tmety(ip+im))
             else
              trnspt(ibnd) = c0
            end if
            abtrns(ibnd) = abs(trnspt(ibnd))
            pbar(ip)     = pbar(ip+im) + trnspt(ibnd)
            tot          = tot + trnspt(ibnd)
            atot         = atot + abtrns(ibnd)
 30      continue
c
c  South.
c
         do 40 i = 2, im-1
            ip = i
            ibnd = ibnd + 1
            if((landt(ip)*landt(ip-1)).gt.0) then
              trnspt(ibnd) = vbaro(ip-1)*hv(ip-1)*
     &                       p5*dx*(tmetx(ip)+tmetx(ip-1))
             else
              trnspt(ibnd) = c0
            end if
            abtrns(ibnd) = abs(trnspt(ibnd))
            pbar(ip)     = pbar(ip-1) + trnspt(ibnd)
            tot          = tot + trnspt(ibnd)
            atot         = atot + abtrns(ibnd)
 40      continue
c
c-----------------------------------------------------------------------
c     Add velocity correction (proportional to original velocities) to
c     get zero net transport through domain.
c-----------------------------------------------------------------------
c
c  Check on closure
c
         ip = im
         ibnd = ibnd + 1
         if((landt(ip)*landt(ip-1)).gt.0) then
           trnspt(ibnd) = vbaro(ip-1)*hv(ip-1)*
     &                    p5*dx*(tmetx(ip)+tmetx(ip-1))
          else
           trnspt(ibnd) = c0
         end if
         abtrns(ibnd) = abs(trnspt(ibnd))
         tot          = tot + trnspt(ibnd)
         atot         = atot + abtrns(ibnd)
c
c  Compute correction factor
c
         veldiff = - tot/atot
         write(stdout,200) pbavg0,tot,atot,veldiff
c
c  Update transport through boundaries.
c
         ibnd     = 0
         atot     = c0
         tot      = c0
c
c  East.
c
         do 50 j = 2, jm
            ip   = j*im
            ibnd = ibnd + 1
            val      = trnspt(ibnd) + veldiff*abtrns(ibnd)
            pbar(ip) = pbar(ip-im) + val
            tot      = tot + val
 50      continue
c
c  North.
c
         do 60 i = im-1, 1, -1
            ip = i + (jm-1)*im
            ibnd = ibnd + 1
            val      = trnspt(ibnd) + veldiff*abtrns(ibnd)
            pbar(ip) = pbar(ip+1) + val
            tot      = tot + val
 60      continue
c
c  West.
c
         do 70 j = jm-1, 1, -1
            ip = 1 + (j-1)*im
            ibnd = ibnd + 1
            val      = trnspt(ibnd) + veldiff*abtrns(ibnd)
            pbar(ip) = pbar(ip+im) + val
            tot      = tot + val
 70      continue
c
c  South.
c
         do 80 i = 2, im-1
            ip = i
            ibnd = ibnd + 1
            val      = trnspt(ibnd) + veldiff*abtrns(ibnd)
            pbar(ip) = pbar(ip-1) + val
            tot      = tot + val
 80      continue
c
c  Check on closure
c
         ip = im
         ibnd = ibnd + 1
         val  = trnspt(ibnd) + veldiff*abtrns(ibnd)
         tot  = tot + val
c
         write(stdout,300) tot
         if ((small*abs(tot)).lt.abs(pbavg0)) then
            write(stdout,310) abs(tot)/abs(pbavg0)
         end if
c
c-----------------------------------------------------------------------
c     Compute new average around boundary.
c-----------------------------------------------------------------------
c
         pbavg1 = psibavg (im,jm,pbar,dx,tmetx,dy,tmety)
c
c-----------------------------------------------------------------------
c     Reset to original average value.
c-----------------------------------------------------------------------
c
         pbavg1 = pbavg0 - pbavg1
         write (stdout,320) pbavg1
c
         do 90 i = 1, im
            ip = i
            pbar(ip) = pbar(ip) + pbavg1
            ip = i + (jm-1)*im
            pbar(ip) = pbar(ip) + pbavg1
  90     continue
c
         do 100 j = 2, jm-1
            ip = 1 + (j-1)*im
            pbar(ip) = pbar(ip) + pbavg1
            ip = j*im
            pbar(ip) = pbar(ip) + pbavg1
 100     continue
c
#ifdef sunflush
         call flush(stdout)
c
#endif
      endif
c
      return
c
 200  format(/'PSIBDY:'/
     &       10x,' Average value of Transport along bndy : ',1pg16.7/
     &       10x,'       Initial difference in Transport : ',1pg16.7/
     &       10x,'Transport for inflow w/ 1st velocities : ',1pg16.7/
     &       10x,'                     Correction factor : ',1pg16.7)
 300  format(10x,'         Final difference in Transport : ',1pg16.7)
 310  format(10x,'      Relative difference in Transport : ',1pg16.7)
 320  format(10x,'      Correction to average bndy value : ',1pg16.7)
c
      end
