      subroutine put_bry
c
c=======================================================================
c                                                                    ===
c  This routine writes PE output boundary conditions.  The type of   ===
c  boundary condition on PBAR (transport streamfunction) is either   ===
c  specify PBAR at the boundary and next interior points  (IBRY=1)   ===
c  or specify PBAR and d(vorticity)/dt (IBRY=2).                     ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <cstseg.h>
#include <curflds.h>
#include <grddat.h>
#include <iounits.h>
#include <moddat.h>
#include <ndimen.h>
#include <oldflds.h>
#include <pefldid.h>
#include <pi_netcdf.h>
#include <switches.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer mxnz
      parameter (mxnz=mx*nz)
c
      integer i,ip,j,k,m,n
      integer ibdy(4),count(5),start(5)
      real day2sec,denom,c0,c2,dt,sec2day,t1,t2,t3,t4
      real f(mxnz),pbry(mx,4),qbry(mx,4),tbry(mx,nz,4,mt),ubry(mx,nz,4),
     *     vbry(mx,nz,4)
      parameter (c0=0.0,c2=2.0,day2sec=86400.0,sec2day=1.0/86400.0)
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
      ibdy(1)=jm
      ibdy(2)=im
      ibdy(3)=jm
      ibdy(4)=im
      dt=(dcur-dold)*day2sec
      write(stdout,900) dold,dt*sec2day
c
c-----------------------------------------------------------------------
c  Set western and eastern boundaries.
c-----------------------------------------------------------------------
c
      do 10 j=1,jm-1
c
c  Compute rate of change of barotropic vorticity.
c
        if(iflag(4).eq.2) then
          ip=1+(j-1)*im
          t1=(vbar(ip+1   )*vmety(ip+1   )-
     *        vbar(ip     )*vmety(ip     ))+
     *       (vbar(ip+im+1)*vmety(ip+im+1)-
     *        vbar(ip+im  )*vmety(ip+im  ))
          t2=(ubar(ip+im+1)*vmetx(ip+im+1)-
     *        ubar(ip+1   )*vmetx(ip+1   ))+
     *       (ubar(ip+im  )*vmetx(ip+im  )-
     *        ubar(ip     )*vmetx(ip     ))
          t3=(vbarold(ip+1   )*vmety(ip+1   )-
     *        vbarold(ip     )*vmety(ip     ))+
     *       (vbarold(ip+im+1)*vmety(ip+im+1)-
     *        vbarold(ip+im  )*vmety(ip+im  ))
          t4=(ubarold(ip+im+1)*vmetx(ip+im+1)-
     *        ubarold(ip+1   )*vmetx(ip+1   ))+
     *       (ubarold(ip+im  )*vmetx(ip+im  )-
     *        ubarold(ip     )*vmetx(ip     ))
          pbry(j+1,west)=pbarold(ip+im)
          denom=c2*dx*dt*tmetx(ip+im+1)*tmety(ip+im+1)
          if(denom.ne.c0) then
            qbry(j+1,west)=((t1-t2)-(t3-t4))/denom
          else
            qbry(j+1,west)=c0
          endif
c
          ip=(im-1)+(j-1)*im
          t1=(vbar(ip     )*vmety(ip     )-
     *        vbar(ip-1   )*vmety(ip-1   ))+
     *       (vbar(ip+im  )*vmety(ip+im  )-
     *        vbar(ip+im-1)*vmety(ip+im+1))
          t2=(ubar(ip+im  )*vmetx(ip+im  )-
     *        ubar(ip     )*vmetx(ip     ))+
     *       (ubar(ip+im-1)*vmetx(ip+im-1)-
     *        ubar(ip-1   )*vmetx(ip-1   ))
          t3=(vbarold(ip     )*vmety(ip     )-
     *        vbarold(ip-1   )*vmety(ip-1   ))+
     *       (vbarold(ip+im  )*vmety(ip+im  )-
     *        vbarold(ip+im-1)*vmety(ip+im-1))
          t4=(ubarold(ip+im  )*vmetx(ip+im  )-
     *        ubarold(ip     )*vmetx(ip     ))+
     *       (ubarold(ip+im-1)*vmetx(ip+im-1)-
     *        ubarold(ip-1   )*vmetx(ip-1   ))
          pbry(j+1,east)=pbarold(ip+im+1)
          denom=c2*dx*dt*tmetx(ip+im)*tmety(ip+im)
          if(denom.ne.c0) then
            qbry(j+1,east)=((t1-t2)-(t3-t4))/denom
          else
            qbry(j+1,east)=c0
          endif
c
c  Set boundary value to transport streamfunction instead.
c
        else
          ip=1+j*im
          pbry(j+1,west)=pbarold(ip  )
          qbry(j+1,west)=pbarold(ip+1)
          ip=im+j*im
          pbry(j+1,east)=pbarold(ip-1)
          qbry(j+1,east)=pbarold(ip  )
        end if
        if(icoast.ne.0) then
          if(landt(1+j*im).eq.0) then
            if((landt(1+(min(j+2,jm)-1)*im)+
     *          landt(1+(j-1)*im)).eq.0) then
              qbry(j+1,west)=c0
            endif
          endif
          if(landt(im+j*im).eq.0) then
            if((landt(im+(min(j+2,jm)-1)*im)+
     *          landt(im+(j-1)*im)).eq.0) then
              qbry(j+1,east)=c0
            endif
          endif
        endif
  10  continue
      pbry(1,west)=pbarold(1)
      pbry(1,east)=pbarold(im)
      qbry(1,west)=qbry(2,west)
      qbry(1,east)=qbry(2,east)
c
c  Set boundary condition for internal velocity and tracers.
c
      do 40 j=1,jm
        ip=1+(j-1)*im
        do 30 k=1,km
          if((icoast.ne.0).and.(landv(ip).lt.1)) then
            ubry(j,k,west)=c0
            vbry(j,k,west)=c0
          else
            ubry(j,k,west)=uiold(ip,k)
            vbry(j,k,west)=viold(ip,k)
          endif
          if((icoast.ne.0).and.(landv(im+(j-1)*im).lt.1)) then
            ubry(j,k,east)=c0
            vbry(j,k,east)=c0
          else
            ubry(j,k,east)=uiold(ip+im-2,k)
            vbry(j,k,east)=viold(ip+im-2,k)
          endif
          do 20 m=1,nt
            tbry(j,k,west,m)=told(ip,k,m)
            tbry(j,k,east,m)=told(ip+im-1,k,m)
  20      continue
  30    continue
  40  continue
c
c-----------------------------------------------------------------------
c  Set southern and northern boundaries.
c-----------------------------------------------------------------------
c
      do 50 i=1,im-1
c
c  Compute rate of change of barotropic vorticity.
c
        if(iflag(4).eq.2) then
          ip=i
          t1=(vbar(ip+1   )*vmety(ip+1   )-
     *        vbar(ip     )*vmety(ip     ))+
     *       (vbar(ip+im+1)*vmety(ip+im+1)-
     *        vbar(ip+im  )*vmety(ip+im  ))
          t2=(ubar(ip+im+1)*vmetx(ip+im+1)-
     *        ubar(ip+1   )*vmetx(ip+1   ))+
     *       (ubar(ip+im  )*vmetx(ip+im  )-
     *        ubar(ip     )*vmetx(ip     ))
          t3=(vbarold(ip+1   )*vmety(ip+1   )-
     *        vbarold(ip     )*vmety(ip     ))+
     *       (vbarold(ip+im+1)*vmety(ip+im+1)-
     *        vbarold(ip+im  )*vmety(ip+im  ))
          t4=(ubarold(ip+im+1)*vmetx(ip+im+1)-
     *        ubarold(ip+1   )*vmetx(ip+1   ))+
     *       (ubarold(ip+im  )*vmetx(ip+im  )-
     *        ubarold(ip     )*vmetx(ip     ))
          pbry(i+1,south)=pbarold(ip+1)
          denom=c2*dx*dt*tmetx(ip+im+1)*tmety(ip+im+1)
          if(denom.ne.c0) then
            qbry(i+1,south)=((t1-t2)-(t3-t4))/denom
          else
            qbry(i+1,south)=c0
          endif
c
          ip=i+((jm-1)-1)*im
          t1=(vbar(ip-im+1)*vmety(ip-im+1)-
     *        vbar(ip-im  )*vmety(ip-im  ))+
     *       (vbar(ip+1   )*vmety(ip+1   )-
     *        vbar(ip     )*vmety(ip     ))
          t2=(ubar(ip+1   )*vmetx(ip+1   )-
     *        ubar(ip-im+1)*vmetx(ip-im+1))+
     *       (ubar(ip     )*vmetx(ip     )-
     *        ubar(ip-im  )*vmetx(ip-im  ))
          t3=(vbarold(ip-im+1)*vmety(ip-im+1)-
     *        vbarold(ip-im  )*vmety(ip-im  ))+
     *       (vbarold(ip+1   )*vmety(ip+1   )-
     *        vbarold(ip     )*vmety(ip     ))
          t4=(ubarold(ip+1   )*vmetx(ip+1   )-
     *        ubarold(ip-im+1)*vmetx(ip-im+1))+
     *       (ubarold(ip     )*vmetx(ip     )-
     *        ubarold(ip-im  )*vmetx(ip-im  ))
          pbry(i+1,north)=pbarold(ip+im+1)
          denom=c2*dx*dt*tmetx(ip+1)*tmety(ip+1)
          if(denom.ne.c0) then
            qbry(i+1,north)=((t1-t2)-(t3-t4))/denom
          else
            qbry(i+1,north)=c0
          endif
c
c  Set boundary value to transport streamfunction instead.
c
        else
          ip=i+1
          pbry(i+1,south)=pbarold(ip   )
          qbry(i+1,south)=pbarold(ip+im)
          ip=(i+1)+(jm-1)*im
          pbry(i+1,north)=pbarold(ip-im)
          qbry(i+1,north)=pbarold(ip   )
        endif
        if(icoast.ne.0) then
          if(landt(i+1).eq.0) then
            if((landt(min(i+2,im))+landt(i)).eq.0) then
              qbry(i+1,south)=c0
            endif
          endif
          if(landt(i+1+(jm-1)*im).eq.0) then
            if((landt(min(i+2,im)+(jm-1)*im)+
     *          landt(i+(jm-1)*im)).eq.0) then
              qbry(i+1,north)=c0
            endif
          endif
        endif
  50  continue
      pbry(1,south)=pbarold(1)
      pbry(1,north)=pbarold(1+(jm-1)*im)
      qbry(1,south)=qbry(2,south)
      qbry(1,north)=qbry(2,north)
c
c  Set boundary codition for internal velocity and tracers.
c
      do 80 i=1,im
        do 70 k=1,km
          if((icoast.ne.0).and.(landv(i).lt.1)) then
            ubry(i,k,south)=c0
            vbry(i,k,south)=c0
          else
            ubry(i,k,south)=uiold(i,k)
            vbry(i,k,south)=viold(i,k)
          endif
          if((icoast.ne.0).and.(landv(i+(jm-1)*im).lt.1)) then
            ubry(i,k,north)=c0
            vbry(i,k,north)=c0
          else
            ubry(i,k,north)=uiold((jm-2)*im+i,k)
            vbry(i,k,north)=viold((jm-2)*im+i,k)
          endif
          do 60 m=1,nt
            tbry(i,k,south,m)=told(i,k,m)
            tbry(i,k,north,m)=told((jm-2)*im+i,k,m)
  60      continue
  70    continue
  80  continue
c
c-----------------------------------------------------------------------
c  Write out boundary information.
c-----------------------------------------------------------------------
c
c  Advance time counter and write out time.
c
      if(job.ne.1) then
        tindx=tindx+1
        start(1)=tindx
        count(1)=1
        call ncvpt(ncoutid,timeid,start,count,dold,rcode)
        if(rcode.ne.0) then
          write(stdout,901) 'time'
          call exitus('PUT_INIT')
        endif
      endif
c
c  Write boundary conditions for each boundary edge.
c
      do 100 n=1,4
        start(2)=1
        count(2)=km
        start(3)=1
        count(3)=ibdy(n)
        start(4)=n
        count(4)=1
        start(5)=tindx
        count(5)=1
c
c  Internal mode velocity.
c
        call fsave(f,mxnz,ubry(1,1,n),mx,nz,ibdy(n),1,km)
        start(1)=xindx
        count(1)=1
        call ncvpt(ncoutid,vbryid,start,count,f,rcode)
        if(rcode.ne.0) then
          write(stdout,902) 'vbry x-component',n
          call exitus('PUT_BRY')
        endif
        call fsave(f,mxnz,vbry(1,1,n),mx,nz,ibdy(n),1,km)
        start(1)=yindx
        count(1)=1
        call ncvpt(ncoutid,vbryid,start,count,f,rcode)
        if(rcode.ne.0) then
          write(stdout,902) 'vbry y-component',n
          call exitus('PUT_BRY')
        endif
c
c  Tracers.
c
        do 90 m=1,nt
          start(1)=m
          count(1)=1
          call fsave(f,mxnz,tbry(1,1,n,m),mx,nz,ibdy(n),1,km)
          call ncvpt(ncoutid,tbryid,start,count,f,rcode)
          if(rcode.ne.0) then
            write(stdout,903) 'tbry',n,m
            call exitus('PUT_BRY')
          endif
  90    continue
c
c  Trasport streamfunction and time rate of change of vorticity.
c
        start(1)=1
        count(1)=ibdy(n)
        start(2)=n
        count(2)=1
        start(3)=tindx
        count(3)=1
        call fsave(f,mxnz,pbry(1,n),mx,1,ibdy(n),1,1)
        call ncvpt(ncoutid,pbryid,start,count,f,rcode)
        if(rcode.ne.0) then
          write(stdout,902) 'pbry',n
          call exitus('PUT_BRY')
        endif
        call fsave(f,mxnz,qbry(1,n),mx,1,ibdy(n),1,1)
        call ncvpt(ncoutid,qbryid,start,count,f,rcode)
        if(rcode.ne.0) then
          write(stdout,902) 'qbry',n
          call exitus('PUT_BRY')
        endif
 100  continue
c
c  Synchronize NetCDF data to disk.
c
      call ncsnc(ncoutid,rcode)
      if(rcode.ne.0) then
        write(stdout,904)
        call exitus('PUT_BRY')
      endif
c
 900  format(/' Writing boundary conditions for day = ',f12.4,
     *       /'         boundary vorticity using DT = ',f12.4/)
 901  format(/' PUT_BRY - error while writing variable: ',a)
 902  format(/' PUT_BRY - error while writing variable: ',a,
     *        ' at BOUNDARY = ',i1)
 903  format(/' PUT_BRY - error while writing variable: ',a,
     *        ' at BOUNDARY = ',i1,2x,' and TRACER = ',i2)
 904  format(/' PUT_BRY - unable to synchronize data to disk.')
      return
      end
