      subroutine putdiag (which)
c
c=======================================================================
c                                                                    ===
c  This routine writes the composite and intermediate velocity data. ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     WHICH   Flag for which variable to write.  (string)            ===
c                'TotalVelocity'                                     ===
c                'BarotropicVelocity'                                ===
c                'InterpolatedGeostrophicVelocity'                   ===
c                'FlatGeostrophicVelocity'                           ===
c                'FirstGuessBarotropicVelocity'                      ===
c                'BottomAdjustedBarotropicVelocity'                  ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /CURFLDS/                                                         ===
c                                                                    ===
c     U      Total u-velocity component.        (real array; cm/s)   ===
c     UBAR   Barotropic u-velocity component.   (real array; cm/s)   ===
c     UI     Baroclinic u-velocity component.   (real array; cm/s)   ===
c     V      Total v-velocity component.        (real array; cm/s)   ===
c     VBAR   Barotropic v-velocity component.   (real array; cm/s)   ===
c     VI     Baroclinic v-velocity component.   (real array; cm/s)   ===
c                                                                    ===
c  /IOUNITS/                                                         ===
c                                                                    ===
c     STDOUT   standard output unit.  (integer)                      ===
c                                                                    ===
c  /NDIMEN/                                                          ===
c                                                                    ===
c     IM   number of points in the x-direction.  (integer)           ===
c     JM   number of points in the y-direction.  (integer)           ===
c     KM   number of points in the z-direction.  (integer)           ===
c                                                                    ===
c  /PI_NETCFD/                                                       ===
c                                                                    ===
c     TINDX     Time index for previous time.               (integer)===
c     VBA1ID    ID for first guess barotropic velocity.     (integer)===
c     VBA2ID    ID for bottom adjusted barotropic velocity. (integer)===
c     VBARID    ID for barotropic velocity.                 (integer)===
c     VFLTID    ID for flat geostrophic velocity.           (integer)===
c     VGEOID    ID for interpolated geostrophic velocity.   (integer)===
c     VTOTID    ID for total velocity.                      (integer)===
c                                                                    ===
c  /SWITCHES/                                                        ===
c                                                                    ===
c     IDBUG   flag for writing diagnostic fields.   (integer)        ===
c     IFLAG   PE/PE_INITIAL internal flags.         (integer)        ===
c                IFLAG(5)   barotropic velocities                    ===
c                                                                    ===
c  /ZDAT/                                                            ===
c                                                                    ===
c     KFLD   Number of levels in input data.  (integer)              ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     HOPS:    ALL_UC,  EXITUS,  LENGTH                              ===
c     NetCDF:  NCVPT                                                 ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <curflds.h>
#include <iounits.h>
#include <ndimen.h>
#include <netcdf.inc>
#include <pi_netcdf.h>
#include <switches.h>
#include <zdat.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer ij,k,sbgn,send,slen
      integer       count(5),start(5)
      character*80  whcap
      character*(*) which
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Ensure string has all upper case letters.
c-----------------------------------------------------------------------
c
      call all_uc (which,whcap)
      call length (whcap,slen,sbgn,send)
c
c-----------------------------------------------------------------------
c  Write requested field.
c-----------------------------------------------------------------------
c
      if (whcap(sbgn:send).eq.'TOTALVELOCITY') then
c
         count(1) = 1
         count(2) = 1
         start(3) = 1
         count(3) = im
         start(4) = 1
         count(4) = jm
         start(5) = tindx + 1
         count(5) = 1
c
         do 20 k = 1, km
c
            do 10 ij = 1, im*jm
               u(ij,k) = ui(ij,k) + ubar(ij)
               v(ij,k) = vi(ij,k) + vbar(ij)
  10        continue
c
            start(1) = xindx
            start(2) = k
            call ncvpt (ncoutid,vtotid,start,count,u(1,k),rcode)
            if (rcode.ne.0) then
              write (stdout,900) 'vtot x-component'
              call exitus ('PUTDIAG')
            endif
c
            start(1) = yindx
            call ncvpt (ncoutid,vtotid,start,count,v(1,k),rcode)
            if (rcode.ne.0) then
              write (stdout,900) 'vtot y-component'
              call exitus ('PUTDIAG')
            endif
c
  20     continue
c
       elseif (whcap(sbgn:send).eq.'BAROTROPICVELOCITY') then
c
         count(1) = 1
         start(2) = 1
         count(2) = im
         start(3) = 1
         count(3) = jm
         start(4) = tindx + 1
         count(4) = 1
c
         start(1) = xindx
         call ncvpt (ncoutid,vbarid,start,count,ubar,rcode)
         if (rcode.ne.0) then
           write (stdout,900) 'vbaro x-component'
           call exitus ('PUTDIAG')
         endif
c
         start(1) = yindx
         call ncvpt (ncoutid,vbarid,start,count,vbar,rcode)
         if (rcode.ne.0) then
           write (stdout,900) 'vbaro y-component'
           call exitus ('PUTDIAG')
         endif
c
       elseif(whcap(sbgn:send).eq.'INTERPOLATEDGEOSTROPHICVELOCITY')then
c
         count(1) = 1
         count(2) = 1
         start(3) = 1
         count(3) = im
         start(4) = 1
         count(4) = jm
         start(5) = tindx + 1
         count(5) = 1
c
         do 30 k = 1, km
c
            start(1) = xindx
            start(2) = k
            call ncvpt (ncoutid,vgeoid,start,count,u(1,k),rcode)
            if (rcode.ne.0) then
              write (stdout,900) 'vgeo x-component'
              call exitus ('PUTDIAG')
            endif
c
            start(1) = yindx
            call ncvpt (ncoutid,vgeoid,start,count,v(1,k),rcode)
            if (rcode.ne.0) then
              write (stdout,900) 'vgeo y-component'
              call exitus ('PUTDIAG')
            endif
c
  30     continue
c
       elseif ((whcap(sbgn:send).eq.'FLATGEOSTROPHICVELOCITY')
     &                                         .and. (idbug.ne.0) ) then
c
         count(1) = 1
         count(2) = 1
         start(3) = 1
         count(3) = im
         start(4) = 1
         count(4) = jm
         start(5) = tindx + 1
         count(5) = 1
c
         do 40 k = 1, kfld
c
            start(1) = xindx
            start(2) = k
            call ncvpt (ncoutid,vfltid,start,count,u(1,k),rcode)
            if (rcode.ne.0) then
              write (stdout,900) 'vflt x-component'
              call exitus ('PUTDIAG')
            endif
c
            start(1) = yindx
            call ncvpt (ncoutid,vfltid,start,count,v(1,k),rcode)
            if (rcode.ne.0) then
              write (stdout,900) 'vflt y-component'
              call exitus ('PUTDIAG')
            endif
c
  40     continue
c
       elseif ((whcap(sbgn:send).eq.'FIRSTGUESSBAROTROPICVELOCITY')
     &                                         .and. (idbug.ne.0) ) then
c
         count(1) = 1
         start(2) = 1
         count(2) = im
         start(3) = 1
         count(3) = jm
         start(4) = tindx + 1
         count(4) = 1
c
         start(1) = xindx
         call ncvpt (ncoutid,vba1id,start,count,ubar,rcode)
         if (rcode.ne.0) then
           write (stdout,900) 'vb1st x-component'
           call exitus ('PUTDIAG')
         endif
c
         start(1) = yindx
         call ncvpt (ncoutid,vba1id,start,count,vbar,rcode)
         if (rcode.ne.0) then
           write (stdout,900) 'vb1st y-component'
           call exitus ('PUTDIAG')
         endif
c
       elseif ((whcap(sbgn:send).eq.'BOTTOMADJUSTEDBAROTROPICVELOCITY')
     &            .and. (idbug.ne.0) .and. (mod(iflag(5),4).gt.1) ) then
c
         count(1) = 1
         start(2) = 1
         count(2) = im
         start(3) = 1
         count(3) = jm
         start(4) = tindx + 1
         count(4) = 1
c
         start(1) = xindx
         call ncvpt (ncoutid,vba2id,start,count,ubar,rcode)
         if (rcode.ne.0) then
           write (stdout,900) 'vb2nd x-component'
           call exitus ('PUTDIAG')
         endif
c
         start(1) = yindx
         call ncvpt (ncoutid,vba2id,start,count,vbar,rcode)
         if (rcode.ne.0) then
           write (stdout,900) 'vb2nd y-component'
           call exitus ('PUTDIAG')
         endif
c
      endif
c
      return
c
 900  format (/'***Error:  PUTDIAG - unable to write variable ',1h",a,
     &        1h")
c
      end
