      subroutine read_surfnm (surfnm)
c
c=======================================================================
c                                                                    ===
c  This routine references the streamfunction to the requested       ===
c  surface.                                                          ===
c                                                                    ===
c                                                                    ===
c  Common Blocks:        (only relevent variables documented)        ===
c                                                                    ===
c  /CURFLDS/                                                         ===
c                                                                    ===
c    DCUR.........Current time.  (Julian days or days)  (input; real)===
c                                                                    ===
c  /IOUNITS/                                                         ===
c                                                                    ===
c    FNAME........Array of file names.   (input; character array)    ===
c                   FNAME(9)  surface of no motion input file.       ===
c    STDOUT.......Standard output unit.  (input; integer)            ===
c                                                                    ===
c  /NDIMEN/                                                          ===
c                                                                    ===
c    IM, JM.......Number of grid points in x and y directions.       ===
c                   (input; integers)                                ===
c                                                                    ===
c         Calls:  EXITUS, LNBLK                                      ===
c  netCDF Calls:  NCDID, NCDINQ, NCVGT, NCVGT1, NCVID                ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <netcdf.inc>
#include <curflds.h>
#include <iounits.h>
#include <ndimen.h>
#include <pi_netcdf.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer count(4),dimid,err,ip,lenstr,ntimmax,nthi,ntlo,start(4)
      integer lnblk
      real    c0,c1,chi,clo,m2cm,surfnm(np),surfo(np),timhi,timlo
c
      logical first
c
      parameter (c0=0.0,c1=1.0,m2cm=100.0)
c
      save first,ntimmax,start,count
c
      data first/.true./
      data start,count /8*1/
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      if (ncsnmfl.eq.1) then
c
c-----------------------------------------------------------------------
c     Initialize counters for surface of no motion
c     netCDF input file.
c-----------------------------------------------------------------------
c
         if (first) then
            dimid = ncdid (ncsnmid,'time',err)
            if (err.ne.0) then
               lenstr=lnblk(fname(9),len(fname(9)))
               write (stdout,1000) 'time',fname(9)(1:lenstr)
               call exitus ('READ_SURFNM')
            endif
            call ncdinq (ncsnmid,dimid,dimnam,ntimmax,err)
            if (err.ne.0) then
               lenstr=lnblk(fname(9),len(fname(9)))
               write (stdout,1010) 'time',fname(9)(1:lenstr)
               call exitus ('READ_SURFNM')
            endif
            count(2) = im
            count(3) = jm
            first = .false.
         end if
c
c-----------------------------------------------------------------------
c         Find bracketting time levels
c-----------------------------------------------------------------------
c
         varid = ncvid (ncsnmid,'time',err)
         ntlo = ntimmax
         call ncvgt1 (ncsnmid,varid,ntlo,timlo,err)
         if (err.ne.0) then
            lenstr=lnblk(fname(9),len(fname(9)))
            write (stdout,1020) 'time',fname(9)(1:lenstr)
            call exitus ('READ_SURFNM')
         endif
         do 10 while ((timlo.gt.dcur).and.(ntlo.gt.1))
            ntlo = ntlo - 1
            call ncvgt1 (ncsnmid,varid,ntlo,timlo,err)
            if (err.ne.0) then
               lenstr=lnblk(fname(9),len(fname(9)))
               write (stdout,1020) 'time',fname(9)(1:lenstr)
               call exitus ('READ_SURFNM')
            endif
 10      continue
         nthi = ntlo
         if (timlo.le.dcur) nthi = min(nthi+1,ntimmax)
         call ncvgt1 (ncsnmid,varid,nthi,timhi,err)
         if (err.ne.0) then
            lenstr=lnblk(fname(9),len(fname(9)))
            write (stdout,1020) 'time',fname(9)(1:lenstr)
            call exitus ('READ_SURFNM')
         endif
c
c-----------------------------------------------------------------------
c     Read in surface of no motion.  Interpolate in time if
c     possible.  Use constant extrapolation if necessary.
c     Convert surface from meters to centimeters.
c-----------------------------------------------------------------------
c
         if (timlo.ne.timhi) then
c     
            clo = (timhi-dcur)/(timhi-timlo)
            chi = c1 - clo
            start(4) = ntlo
            varid = ncvid (ncsnmid,'surfnm',err)
            call ncvgt (ncsnmid,varid,start,count,surfo,err)
            if (err.ne.0) then
               lenstr=lnblk(fname(9),len(fname(9)))
               write (stdout,1020) 'surfnm',fname(9)(1:lenstr)
               call exitus ('READ_SURFNM')
            endif
            start(4) = nthi
            call ncvgt (ncsnmid,varid,start,count,surfnm,err)
            if (err.ne.0) then
               lenstr=lnblk(fname(9),len(fname(9)))
               write (stdout,1020) 'surfnm',fname(9)(1:lenstr)
               call exitus ('READ_SURFNM')
            endif
            do 20 ip = 1, im*jm
               surfnm(ip) = (clo*surfo(ip) + chi*surfnm(ip))*m2cm
 20         continue
c
         else
c
            start(4) = nthi
            varid = ncvid (ncsnmid,'surfnm',err)
            call ncvgt (ncsnmid,varid,start,count,surfnm,err)
            if (err.ne.0) then
               lenstr=lnblk(fname(9),len(fname(9)))
               write (stdout,1020) 'surfnm',fname(9)(1:lenstr)
               call exitus ('READ_SURFNM')
            endif
            do 30 ip = 1, im*jm
               surfnm(ip) = surfnm(ip)*m2cm
 30         continue
         endif
c
      endif
c
      return
c
1000  format (/'READ_SURFNM - Unable to find dimension ',a,' in ',
     &        'file ',1h",a,2h".)
1010  format (/'READ_SURFNM - Unable to inquire about dimension ',a,
     &        ' in file ',1h",a,2h".)
1020  format (/'READ_SURFNM - Unable to read variable ',a,' in file'
     &        ,1h",a,2h".)
c
      end
