      subroutine readcdf(ncinpid,tindx,varid,varnam,nvdims,vdims,field,
     *                   np,nz)
c
c=======================================================================
c                                                                    ===
c  This routine reads in requested field from input NetCDF file.     ===
c                                                                    ===
c  On Input:                                                         ===
c                                                                    ===
c     NCINPID    NetCDF ID for input file (integer).                 ===
c     TINDX      Time index to read (integer).                       ===
c     VARID      NetCDF ID of variable to read (integer).            ===
c     VARNAM     variable name (character).                          ===
c     NVDIMS     number of dimensions for variable (integer).        ===
c     VDIMS      NetCDF dimension IDs for variable (integer array).  ===
c     NP         Number of horizontal (X,Y) points allocated for     ===
c                variable in calling program (integer).              ===
c     NZ         Number of vertical (X,Y) points allocated for       ===
c                variable in calling program (integer).              ===
c                                                                    ===
c  On Output:                                                        ===
c                                                                    ===
c     FIELD      requested 3D variable (real array).                 ===
c                                                                    ===
c  Required Common blocks:                                           ===
c                                                                    ===
c     /IOUNITS/                                                      ===
c                                                                    ===
c  Calls:                                                            ===
c                                                                    ===
c     NCDINQ, NCVGT  (NetCDF library)                                ===
c     EXITUS, LNBLK                                                  ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <iounits.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer dimid,dimsiz,im,jm,k,km,lendim,lenvar,lindx,ncinpid,n,np,
     *        nz,tindx,nvdims,rcode,varid
      integer count(5),start(5),vdims(nvdims)
      integer lnblk
      real field(np,nz)
      character*128 dimnam
      character*(*) varnam
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      lenvar=lnblk(varnam,len(varnam))
      do 10 n=1,nvdims
        dimid=vdims(n)
        call ncdinq(ncinpid,dimid,dimnam,dimsiz,rcode)
        if(rcode.ne.0) then
          write(stdout,900) dimid,varnam(1:lenvar)
          call exitus('READCDF')
        endif
        lendim=lnblk(dimnam,len(dimnam))
        if((dimnam(1:lendim).eq.'lon').or.
     *     (dimnam(1:lendim).eq.'tlon').or.
     *     (dimnam(1:lendim).eq.'vlon')) then
          start(n)=1
          count(n)=dimsiz
          im=dimsiz
        elseif((dimnam(1:lendim).eq.'lat').or.
     *         (dimnam(1:lendim).eq.'tlat').or.
     *         (dimnam(1:lendim).eq.'vlat')) then
          start(n)=1
          count(n)=dimsiz
          jm=dimsiz
        elseif(dimnam(1:lendim).eq.'level') then
          lindx=n
          km=dimsiz
        elseif(dimnam(1:lendim).eq.'time') then
          start(n)=tindx
          count(n)=1
        endif
  10  continue
c
c  Check if the array size allocated is sufficient.
c
      if ((im*jm).gt.np)
     &  write(stdout,901) ' IM*JM = ',im*jm,' NP = ',np,'NP'
      if (km.gt.nz)
     &  write(stdout,901) ' KM = ',km,' NZ = ',nz,'NZ'
      if (((im*jm).gt.np).or.(km.gt.nz)) call exitus('READCDF')
c
c  Read in requested 3D field.
c
      do 20 k=1,km
        start(lindx)=k
        count(lindx)=1
        call ncvgt(ncinpid,varid,start,count,field(1,k),rcode)
        if(rcode.ne.0) then
          write(stdout,902) varnam(1:lenvar),k
          call exitus('READCDF')
        endif
  20  continue
c
 900  format(/' READCDF - error while inquiring dimension: ',a,2x,
     *        ' for variable: ',a,2x,' in input NetCDF file.' )
 901  format(/' READCDF - required array size, ',a,i6,2x,
     *        ' is bigger than that allocated, ',a,i6,/,12x,
     *        ' Change parameter ',a,' and recompile.')
 902  format(/' READCDF - error while reading variable: ',a,2x,
     *        ' at LEVEL = ',i3)
      return
      end
