      subroutine reset_isle (im,jm,nmvec,pvsave,pv,p)
c
c=======================================================================
c                                                                    ===
c  This routine sets values at the boundary of P and sets mask       ===
c  CSMASK  used in  CGPOIS1  to initialize values of P at land       ===
c  points.                                                           ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     IM      number of points in the x-direction.    (integer)      ===
c     JM      number of points in the y-direction.    (integer)      ===
c     NMVEC   dimension for P and PV.                 (integer)      ===
c     PVSAVE  interior vorticity & transport BCs.     (real array)   ===
c     PV      Previous solution.                      (real array)   ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /CSTSEG/                                                          ===
c                                                                    ===
c     CSTSEGX   coast x-coordinate.                  (integer array) ===
c     CSTSEGY   coast y-coordinate.                  (integer array) ===
c     ICVALIS   Flag for setting Sfn around islands. (integer vector)===
c     LANDP     transport streamfn land/sea mask.    (integer array) ===
c     LENSEG    number of points per coastal segment.(integer vector)===
c     NISLE     number of islands.                   (integer)       ===
c     NSEG      number of coastal segments.          (integer)       ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     P       initial guess for transport function.   (real array)   ===
c     PV      interior vorticity & transport BCs      (real array)   ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /CSTSEG/                                                          ===
c                                                                    ===
c     CVAL    values of Sfn at coastal segments.     (real vector)   ===
c     CSMASK  Working land mask for transport        (integer array) ===
c             streamfunction, allows islands to be                   ===
c             handled iteratively                                    ===
c             CSMASK=0      at sea points.                           ===
c             CSMASK=LSEG   at land points bounded by coastal        ===
c                           segment LSEG.                            ===
c                                                                    ===
c  Calls:   AVG_ISLE                                                 ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <cstseg.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer im,ip,isl,jm,llseg,nmvec
      real    p(nmvec),pv(nmvec),pvsave(nmvec)
      real avg_isle
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Reset initial conditions, forcing, boundary conditions & working mask.
c-----------------------------------------------------------------------
c
      do 10 ip = 1, im*jm
         p(ip)      = pv(ip)
         pv(ip)     = pvsave(ip)
         csmask(ip) = landp(ip)
  10  continue
c
c-----------------------------------------------------------------------
c  Set boundary values for each segment.
c-----------------------------------------------------------------------
c
      do 20 isl = 1, nisle
c
         if (icvalis(isl).eq.0) then
            llseg       = isl + nseg - nisle
            cval(llseg) = avg_isle (lenseg(llseg),cstsegx(1,llseg),
     &                                         cstsegy(1,llseg),p,im,jm)
         end if
c
  20  continue
c
      return
      end
