      subroutine rotparm(clon,clat,rotang,plat,plon,rnlon)
c
c=======================================================================
c                                                                    ===
c     This routine computes the parameters for a spherical rotation  ===
c     such that the new equator passes through the center point,     ===
c     making the prescribed angle with respect to East.              ===
c                                                                    ===
c     On Input:                                                      ===
c                                                                    ===
c     CLON, CLAT   The longitude and latitude of point center of the ===
c                  grid.  (radians; real)                            ===
c     ROTANG       The angle of rotation with respect to East.       ===
c                  (radians; real)                                   ===
c                                                                    ===
c     On Output:                                                     ===
c                                                                    ===
c     PLAT         The latitude of the rotated pole in the original  ===
c                  system.  (radians; real)                          ===
c     PLON         The longitude of the rotated pole in the original ===
c                  system.  (radians; real)                          ===
c     RNLON        The longitude of the original pole in the rotated ===
c                  system.  (radians; real)                          ===
c                                                                    ===
c     Calls:  GET_EWPT                                               ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      real a,c1,c2,c2pi,clat,clon,cm1,cos_pen,cos_pwn,cose,cosemw,cosw,
     *     denom,elon,elat,hpi,lon1,lon2,mhpi,numer,p25,p5,pi,plat,plon,
     *     qpi,rnlon,rotang,sin_pen,sin_pwn,sine,sinemw,sinw,wlon,wlat
      real lon_chk
      parameter (c1=1.0,c2=2.0,cm1=-1.0,p25=0.25,p5=0.5,
     *           pi=3.14159 26535 89793 23846)
      parameter (c2pi=c2*pi,hpi=p5*pi,mhpi=cm1*hpi,qpi=p25*pi)
c
c-----------------------------------------------------------------------
c  Longitude range check function.
c-----------------------------------------------------------------------
c
      lon_chk(a)=sign(c1,a)*
     *           (mod(abs(a),c2pi)-c2pi*int(mod(abs(a),c2pi)/pi))
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Compute the "eastern" and "western" points along the rotated
c  equator.
c-----------------------------------------------------------------------
c
      call get_ewpt(clon,clat,rotang,elon,elat,wlon,wlat)
c
c-----------------------------------------------------------------------
c  Compute the needed spherical rotation parameters if the rotation
c  angle permits it.
c-----------------------------------------------------------------------
c
      if(abs(rotang).le.c2pi) then
c
c-----------------------------------------------------------------------
c  Compute the trigonometric functions of east and west latitudes
c  and of the difference of their longitudes.
c-----------------------------------------------------------------------
c
        sine=sin(elat)
        sinw=sin(wlat)
        cose=cos(elat)
        cosw=cos(wlat)
c
        cosemw=cos(elon-wlon)
        sinemw=sin(elon-wlon)
c
c-----------------------------------------------------------------------
c  Compute the trigonometric functions of the interior angles.
c-----------------------------------------------------------------------
c
        sin_pen=sinw*cose-sine*cosw*cosemw
        cos_pen=cosw*sinemw
        sin_pwn=sine*cosw-sinw*cose*cosemw
        cos_pwn=cose*sinemw
c
c-----------------------------------------------------------------------
c  Compute latitude of rotated pole.
c-----------------------------------------------------------------------
c
        plat=asin(cose*cosw*sinemw)
c
c-----------------------------------------------------------------------
c  Compute longitude of rotated pole.  Keep all longitudes in the
c  range (-PI, PI].
c-----------------------------------------------------------------------
c
        numer=sin_pen
        denom=cm1*cos_pen*sine
        lon1=elon+atan2(numer,denom)
        lon1=lon_chk(lon1)
c
        numer=sin_pwn
        denom=cm1*cos_pwn*sinw
        lon2=wlon-atan2(numer,denom)
        lon2=lon_chk(lon2)
c
        plon=p5*(lon1+lon2)
        plon=lon_chk(plon)
c
c-----------------------------------------------------------------------
c  Compute longitude of north pole in rotated coordinates.  Keep
c  all longitudes in the range (-PI, PI].
c-----------------------------------------------------------------------
c
        numer=sin_pen*cose
        denom=sine
        lon1=qpi-atan2(numer,denom)
        lon1=lon_chk(lon1)
c
        numer=sin_pwn*cosw
        denom=sinw
        lon2=atan2(numer,denom)-qpi
        lon2=lon_chk(lon2)
c
        rnlon=p5*(lon1+lon2)
        rnlon=lon_chk(rnlon)
      endif
      return
      end
