      subroutine save(r,rsave,n)
c
c=======================================================================
c                                                                    ===
c  This routine stores the vector R of length N into RSAVE.  If      ===
c  the vector is an error field, it activates error flags.           ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <pefldid.h>
#include <qgfldid.h>
#include <ndimen.h>
#include <switches.h>
#include <workspa.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,n
      real r(*),rsave(*)
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
      do 10 i=1,n
        rsave(i)=r(i)
  10  continue
c
c  If assimilation error fields are stored, activate flags to
c  process and write out errors fields.
c
      if(ifield.eq.qgdher) then
        ioerr(0)=1
        lwrtoerr=.true.
      elseif(ifield.eq.peuoer) then
        ioerr(1)=1
        lwrtoerr=.true.
      elseif(ifield.eq.pevoer) then
        ioerr(2)=1
        lwrtoerr=.true.
      elseif(ifield.eq.pepoer) then
        ioerr(4)=1
        lwrtoerr=.true.
      endif
c
      do 20 i = 1, nt
         if (ifield.eq.trcerrid(i)) then
            ioerr(i+4)=1
            lwrtoerr=.true.
         end if
 20   continue
c
      return
      end
