      subroutine set_baro (ubaro,vbaro)
c
c=======================================================================
c                                                                    ===
c  This routine computes a guess to the barotropic velocity          ===
c  by weighting  topographic steering if requested.                  ===
c                                                                    ===
c  Input:                                                            ===
c                                                                    ===
c  UBARO, VBARO...Mean velocities.  (cm/s)   (real arrays)           ===
c                                                                    ===
c  Output:                                                           ===
c                                                                    ===
c  UBARO, VBARO...Chosen barotropic velocities. (cm/s)  (real arrays)===
c                                                                    ===
c                                                                    ===
c  Common Blocks:        (only relevent variables documented)        ===
c                                                                    ===
c  /BAROPAR/                                                         ===
c                                                                    ===
c    WBOT_DEPTH...Steering depth.  For topographic depths less than  ===
c                 or equal to WBOT_DEPTH, the bottom velocity lies   ===
c                 along isobaths.  For topographic depths greater    ===
c                 than WBOT_DEPTH, only a fraction (WBOT_DEPTH/h) of ===
c                 the cross isobath component is removed.  (cm)      ===
c                 (input; real)                                      ===
c                                                                    ===
c  /CURFLDS/                                                         ===
c                                                                    ===
c    UI, VI.......Internal mode velocities.  (cm/s)                  ===
c                   (input; real arrays)                             ===
c                                                                    ===
c  /GRDDAT/                                                          ===
c                                                                    ===
c    VMETX........X-coordinate metric coefficients at velocity grid  ===
c                   (input; real array; cm)                          ===
c    VMETY........Y-coordinate metric coefficients at velocity grid  ===
c                   (input; real array; cm)                          ===
c                                                                    ===
c  /HYBRID/                                                          ===
c                                                                    ===
c    HV...........Bottom depth at velocity points.  (cm)             ===
c                   (input; real array)                              ===
c                                                                    ===
c  /IOUNITS/                                                         ===
c                                                                    ===
c    STDOUT.......Standard output unit.  (input; integer)            ===
c                                                                    ===
c  /MODDAT/                                                          ===
c                                                                    ===
c    DX, DY.......Grid spacings.  (cm)  (input; real)                ===
c                                                                    ===
c  /NDIMEN/                                                          ===
c                                                                    ===
c    IM, JM, KM...Number of grid points in x, y and z directions.    ===
c                   (input; integers)                                ===
c                                                                    ===
c  /SWITCHES/                                                        ===
c                                                                    ===
c    IFLAG........Contains flag, IFLAG(5), for method of computing   ===
c                   barotropic velocities.  (input; integer array)   ===
c            [0] Ref. depth as is,    no bot. steer, bndy from QG psi===
c            [1] Ref. depth as is,    no bot. steer, bndy from UBARO ===
c            [2] Ref. depth as is,       bot. steer, bndy from QG psi===
c            [3] Ref. depth as is,       bot. steer, bndy from UBARO ===
c            [4] Ref. depth constant, no bot. steer, bndy from QG psi===
c            [5] Ref. depth constant, no bot. steer, bndy from UBARO ===
c            [6] Ref. depth constant,    bot. steer, bndy from QG psi===
c            [7] Ref. depth constant,    bot. steer, bndy from UBARO ===
c            [8] Ref. depth variable, no bot. steer, bndy from QG psi===
c            [9] Ref. depth variable, no bot. steer, bndy from UBARO ===
c           [10] Ref. depth variable,    bot. steer, bndy from QG psi===
c           [11] Ref. depth variable,    bot. steer, bndy from UBARO ===
c                                                                    ===
c  /ZDAT/                                                            ===
c                                                                    ===
c    H............Bottom depth at tracer points.  (cm)               ===
c                   (input; real array)                              ===
c                                                                    ===
c                                                                    ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <baropar.h>
#include <curflds.h>
#include <grddat.h>
#include <hybrid.h>
#include <iounits.h>
#include <moddat.h>
#include <ndimen.h>
#include <switches.h>
#include <zdat.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,ip,ip1,ipp1,ippj,ipp1j,j,jp1
      real    c0,c1,cm1,fx,fy,hx,hy,norm_dh,p5,renorm,small,
     &        ubaro(np),vbaro(np)
c
      parameter (c0=0.0,c1=1.0,cm1=-1.0,p5=0.5,small=1.0e-20)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Compute barotropic velocities as requested.
c-----------------------------------------------------------------------
c
      if (mod(iflag(5),4).gt.1) then
c
c-----------------------------------------------------------------------
c       Find component of bottom velocity normal to isobaths.  Subtract
c       it, or a fraction thereof, from the barotropic velocity.
c-----------------------------------------------------------------------
c
        write (stdout,1000)
c
        fx = p5/dx
        fy = p5/dy
c
        do 10 j = 1, jm
          do 10 i = 1, im
c
            ip1 = min( i+1, im )
            jp1 = min( j+1, jm )
c
            ip = i + (j-1)*im
            ipp1 = ip1 + (j-1)*im
            ippj = i + (jp1-1)*im
            ipp1j = ip1 + (jp1-1)*im
c
            hx = fx*( (h(ipp1j)-h(ippj)) + (h(ipp1)-h(ip)) )/vmetx(ip)
            hy = fy*( (h(ipp1j)-h(ipp1)) + (h(ippj)-h(ip)) )/vmety(ip)
c
            norm_dh = hx*hx + hy*hy
c
            if ( norm_dh.gt.small ) then
              renorm = ( hx*(ubaro(ip)+ui(ip,km)) +
     &                  hy*(vbaro(ip)+vi(ip,km)) ) / norm_dh
c
              if ( (wbot_depth.gt.c0) .and.(hv(ip).lt.wbot_depth) ) then
                renorm=renorm*hv(ip)/wbot_depth
              endif
c
              ubaro(ip) = ubaro(ip) - hx*renorm
              vbaro(ip) = vbaro(ip) - hy*renorm
c
            endif
 10     continue
c
      end if
c
      return
c
1000  format (/3x,'Applying topographic steering.')
c
      end
