      subroutine set_land
c
c=======================================================================
c                                                                    ===
c  This routine sets the mask at the velocity points and store it    ===
c  in common block CSTSEG.                                           ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <cstseg.h>
#include <ndimen.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,ip,isea,j
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
c  Construct the mask field ISMASK which is used for coastal segments
c  extraction. First, constuct mask at the velocity points as in the
c  PE model.
c
      do 20 j=1,jm-1
        do 10 i=1,im-1
          ip=i+(j-1)*im
          landv(ip)=landt(ip)*landt(ip+1)*landt(ip+im)*landt(ip+im+1)
  10    continue
  20  continue
c
c  Set mask indices at the outer boundaries.
c
      do 30 j=1,jm
        ip=im+(j-1)*im
        landv(ip)=landv(ip-1)
  30  continue
      do 40 i=1,im
        ip=i+(jm-1)*im
        landv(ip)=landv(ip-im)
  40  continue
c
c  Second, compute ISMASK.
c
      do 60 j=1,jm
        do 50 i=1,im
          ip=i+(j-1)*im
          ismask(ip)=0
  50    continue
  60  continue
      do 80 j=2,jm
        do 70 i=2,im
          ip=i+(j-1)*im
          isea=landv(ip)*landv(ip-1)*landv(ip-im)*landv(ip-im-1)
          if (isea.eq.0) ismask(ip)=1
          isea=landv(ip)+landv(ip-1)+landv(ip-im)+landv(ip-im-1)
          if (isea.eq.0) ismask(ip)=2
  70    continue
  80  continue
c
c  Set mask indices at the outer boundaries.
c
      do 90 j=2,jm
        ip=1+(j-1)*im
        isea=landv(ip-im)*landv(ip)
        if(isea.eq.0) ismask(ip)=1
        isea=landv(ip-im)+landv(ip)
        if(isea.eq.0) ismask(ip)=2
  90  continue
      do 100 ip=2,im
        isea=landv(ip-1)*landv(ip)
        if(isea.eq.0) ismask(ip)=1
        isea=landv(ip-1)+landv(ip)
        if(isea.eq.0) ismask(ip)=2
 100  continue
      if (landv(1).eq.0) ismask(1)=2
c
c-----------------------------------------------------------------------
c  Construct mask at the velocity points as it is used in PE_INITIAL.
c-----------------------------------------------------------------------
c
c  If a T-point land point is in the neighborhood of a U-point, then
c  the U-point not an interior point (LANDV=2).
c
      do 140 j=1,jm-1
        do 130 i=1,im-1
          ip=i+(j-1)*im
          landv(ip)=0
          isea=landt(ip)*landt(ip+1)*landt(ip+im)*landt(ip+im+1)
          if(isea.eq.0) landv(ip)=1
          isea=landt(ip)+landt(ip+1)+landt(ip+im)+landt(ip+im+1)
          if(isea.eq.0) landv(ip)=2
 130    continue
 140  continue
c
c  Set mask indices at the outer boundaries.
c
      do 150 j=1,jm
        ip=im+(j-1)*im
        landv(ip)=landv(ip-1)
 150  continue
      do 160 i=1,im
        ip=i+(jm-1)*im
        landv(ip)=landv(ip-im)
 160  continue
c
c  Reset indices.
c
      do 180 j=1,jm
        do 170 i=1,im
          ip=i+(j-1)*im
          landv(ip)=2-landv(ip)
 170    continue
 180  continue
c
      return
      end
