      subroutine set_meantrc
c
c=======================================================================
c                                                                    ===
c  This routine computes "mean" tracer fields for use in Shapiro     ===
c  filtering along terrain following levels.                         ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /CSTSEG/                                                          ===
c                                                                    ===
c     LANDT      mask for tracer points.   (integer array)           ===
c                                                                    ===
c  /CURFLDS/                                                         ===
c                                                                    ===
c     T        tracer type of variables.       (real array)          ===
c                                                                    ===
c  /NDIMEN/                                                          ===
c                                                                    ===
c     IM   number of points in the x-direction.   (integer)          ===
c     JM   number of points in the y-direction.   (integer)          ===
c     KM   number of points in the z-direction.   (integer)          ===
c     NT   number of tracer variables.            (integer)          ===
c                                                                    ===
c  /SWITCHES/                                                        ===
c                                                                    ===
c     ICOAST      flag to indicate land/sea data.   (integer)        ===
c                                                                    ===
c  /ZDAT/                                                            ===
c                                                                    ===
c     KFLD     number of levels in input data.      (integer)        ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /CURFLDS/                                                         ===
c                                                                    ===
c     TMEAN    Slowly varying tracer fields.   (real array)          ===
c                                                                    ===
c  Calls:  none                                                      ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <cstseg.h>
#include <curflds.h>
#include <ndimen.h>
#include <switches.h>
#include <zdat.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
#ifndef  meantracer_zip
      integer i,ii,ip,j,jj,k,n,iii,jjj,iip
      double precision c0,c1,rad,rrad2,wt,wtsum
      double precision sum(mt),subfld(np,mt)
      integer subsample
c
      parameter (rad=2.0d0)
c      parameter (rad=4.0d0)
c      parameter (rad=5.0d0)
      parameter (subsample=2)
c      parameter (rad=10.0d0)
c      parameter (subsample=4)
      parameter (c0=0.0d0, c1=1.0d0, rrad2=c1/(rad*rad))
#else
      integer k,n,ip,i,j
#endif
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      do 100 k = 1, kfld
#ifndef  meantracer_zip
c
c  Compute weighted sums of tracer fields.
c

         do 50 jj = 1, jm, subsample
         do 50 ii = 1, im, subsample
            ip = ii + (jj-1)*im
            if ((icoast.eq.0).or.(landt(ip).eq.1)) then
               do 10 n = 1, nt
                  sum(n)=c0
  10           continue
               wtsum=c0
               do 30 iii=-subsample/2+ii,subsample/2+ii
               do 30 jjj=-subsample/2+jj,subsample/2+jj
               if(iii.ge.1.and.iii.le.im.and.
     &            jjj.ge.1.and.jjj.le.jm)then
                  iip = iii + (jjj-1)*im
                  if ((icoast.eq.0).or.(landt(iip).eq.1)) then   
                     wt = c1
                     wtsum = wtsum + wt
                     do 20 n = 1, nt
                        sum(n) = sum(n) + wt*dble(t(iip,k,n))
  20                 continue
                  end if
               endif
  30           continue
c
c  Compute decimated tracer fields.
c
               do 40 n=1,nt
                  subfld(ip,n) = sum(n)/wtsum
  40           continue
            endif
  50     continue
c
c Computed averaged field from weighted decimated field
c
      do 100 j = 1, jm
      do 100 i = 1, im
c
c  Initialize accumulators.
c
         wtsum = c0
         do 60 n = 1, nt
            sum(n) = c0
  60     continue
c
c  Compute weighted sums of tracer fields.
c
         do 80 jj = 1, jm, subsample
         do 80 ii = 1, im, subsample
            ip = ii + (jj-1)*im
            if ((icoast.eq.0).or.(landt(ip).eq.1)) then
               wt = (dble((i-ii)**2)+dble((j-jj)**2))*rrad2
               wt = c1/(c1+wt)
               wtsum = wtsum + wt
               do 70 n = 1, nt
                  sum(n) = sum(n) + wt*subfld(ip,n)
  70           continue
            end if
  80     continue
c
c  Compute "mean" tracer fields.
c
#else
c
c  Use initial field as reference field
c
      do 100 j = 1, jm
      do 100 i = 1, im
#endif
         ip = i + (j-1)*im
         do 90 n = 1, nt
#ifndef  meantracer_zip
            tmean(ip,k,n) = sum(n)/wtsum
#else
            tmean(ip,k,n) = t (ip,k,n)
#endif
  90     continue
 100  continue
c
      return
      end
