      subroutine set_pmask (im,jm,nseg,lenseg,cstsegx,cstsegy,landt,
     &                      landp)
c
c=======================================================================
c                                                                    ===
c  This routine sets a special mask for the transport streamfunction.===
c  Active values are set to zero.  Land points get the number of the ===
c  adjacent coastline.                                               ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     CSTSEGX    coast x-coordinate.                 (integer array) ===
c     CSTSEGY    coast y-coordinate.                 (integer array) ===
c     IM        number of vertical levels.           (integer)       ===
c     JM        number of vertical levels.           (integer)       ===
c     LANDT      land/sea mask at tracer points.     (integer array) ===
c     LENSEG     number of points per coast.         (integer vector)===
c     NSEG       number of coastal segments.         (integer)       ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     LANDP      transport streamfn land/sea mask.   (integer array) ===
c                                                                    ===
c  Calls:  none                                                      ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer d,dlow,i,im,im1,ip,ip1,j,jm,jm1,jp1,m,n,nseg
      integer cstsegx(mpseg,mcseg),cstsegy(mpseg,mcseg),landp(np),
     &        landt(np),lenseg(mcseg),mskwk(np)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Extend land mask to include coastal nodes.
c-----------------------------------------------------------------------
c
      do 20 j = 1, jm
         jm1 = max( (j-1), 1 )
         jp1 = min( (j+1), jm)
         do 10 i = 1, im
            im1 = max( (i-1), 1 )
            ip1 = min( (i+1), im)
            ip  = i + (j-1)*im
            mskwk(ip) = landt(im1+(jp1-1)*im)*landt(i+(jp1-1)*im)*
     &                  landt(ip1+(jp1-1)*im)*landt(im1+(j-1)*im)*
     &                  landt(ip)*landt(ip1+(j-1)*im)*
     &                  landt(im1+(jm1-1)*im)*landt(i+(jm1-1)*im)*
     &                  landt(ip1+(jm1-1)*im)
  10     continue
  20  continue
c
c-----------------------------------------------------------------------
c Create mask indicating adjacent coasts.
c-----------------------------------------------------------------------
c
c
      do 40 j = 1, jm
      do 40 i = 1, im
c
         ip  = i + (j-1)*im
c
         if (mskwk(ip).eq.1) then
c
c           ---------------------
c           --- Active point. ---
c           ---------------------
c
            landp(ip) = 0
c
           else
c
c           ------------------------------------------------
c           --- Inactive point, find adjacent coastline. ---
c           ------------------------------------------------
c
            dlow = 1 + im*im + jm*jm
            do 30 n = 1, nseg
            do 30 m = 1, lenseg(n)
               d = (i-cstsegx(m,n))**2 + (j-cstsegy(m,n))**2
               if (d.lt.dlow) then
                  dlow = d
                  landp(ip) = n
               end if
  30        continue
c
         end if
c
  40  continue
c
      return
      end
