      subroutine set_psi
c
c=======================================================================
c                                                                    ===
c  This routine references the streamfunction to the requested       ===
c  surface.                                                          ===
c                                                                    ===
c                                                                    ===
c  Common Blocks:        (only relevent variables documented)        ===
c                                                                    ===
c  /BAROPAR/                                                         ===
c                                                                    ===
c    DEF_DEPTH....Default reference depth.  (cm)  (input; real)      ===
c                                                                    ===
c  /CURFLDS/                                                         ===
c                                                                    ===
c    PSI..........velocity streamfunction.  (input; real array)      ===
c                                                                    ===
c  /IOUNITS/                                                         ===
c                                                                    ===
c    STDOUT.......Standard output unit.  (input; integer)            ===
c                                                                    ===
c  /NDIMEN/                                                          ===
c                                                                    ===
c    IM, JM.......Number of grid points in x and y directions.       ===
c                   (input; integers)                                ===
c                                                                    ===
c  /SWITCHES/                                                        ===
c                                                                    ===
c    IFLAG........Contains flag, IFLAG(5), for method of computing   ===
c                   barotropic velocities.  (input; integer array)   ===
c            [0] Ref. depth as is,    no bot. steer, bndy from QG psi===
c            [1] Ref. depth as is,    no bot. steer, bndy from UBARO ===
c            [2] Ref. depth as is,       bot. steer, bndy from QG psi===
c            [3] Ref. depth as is,       bot. steer, bndy from UBARO ===
c            [4] Ref. depth constant, no bot. steer, bndy from QG psi===
c            [5] Ref. depth constant, no bot. steer, bndy from UBARO ===
c            [6] Ref. depth constant,    bot. steer, bndy from QG psi===
c            [7] Ref. depth constant,    bot. steer, bndy from UBARO ===
c            [8] Ref. depth variable, no bot. steer, bndy from QG psi===
c            [9] Ref. depth variable, no bot. steer, bndy from UBARO ===
c           [10] Ref. depth variable,    bot. steer, bndy from QG psi===
c           [11] Ref. depth variable,    bot. steer, bndy from UBARO ===
c    INTOPT.......Flag for method of interpolation.  (input; integer)===
c                                                                    ===
c  /ZDAT/                                                            ===
c                                                                    ===
c    KFLD.........number of levels in input data (input; integer).   ===
c    ZFLD.........depths (cm) of the flat levels in the input data   ===
c                 (input; real array).                               ===
c                                                                    ===
c         Calls:   INTRP2D                                           ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <baropar.h>
#include <curflds.h>
#include <iounits.h>
#include <ndimen.h>
#include <switches.h>
#include <zdat.h> 
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      real    c1,psis(np),surfnm(np)
      real    c0
      integer  ip,k
#ifdef rmpsimean
      real    psimean(nz),scle
#endif
c
      parameter (c1=1.0,c0=0.0)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c     Either read in surface of no-motion or set to default constant.
c-----------------------------------------------------------------------
c
      if ((iflag(5)/4).eq.2) then
         call read_surfnm (surfnm)
        else
         do 10 ip = 1, im*jm
            surfnm(ip) = def_depth
 10      continue
      end if
c
c-----------------------------------------------------------------------
c     Interpolate velocity streamfunction to surface.  Re-reference
c     the streamfunction to this surface.
c-----------------------------------------------------------------------
#ifdef rmpsimean
c
      scle=c1/float(im*jm)
c
      do 20 k=1,kfld
         psimean(k)=psi(1,k)*scle
         do 20 ip=2,im*jm
            psimean(k)=psimean(k) + psi(ip,k)*scle
 20   continue
c
      do 30 k=1,kfld
         do 30 ip=1,im*jm
            psi(ip,k)=psi(ip,k) - psimean(k)
 30   continue
#endif
c
      call intrp2d (psi,kfld,zfld,intopt,surfnm,psis)
c
      write (stdout,1030)
c
      do 40 k=1,kfld
         do 40 ip=1,im*jm
            psi(ip,k)=psi(ip,k)-psis(ip)
 40      continue
c
      return
c
1030  format (/3x,'Resetting streamfunction reference surface.')
c
      end
